/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search.providers;

import jadx.api.JavaClass;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.dex.info.MethodInfo;
import jadx.gui.jobs.Cancelable;
import jadx.gui.search.SearchSettings;
import jadx.gui.search.providers.BaseSearchProvider;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class MethodSearchProvider
extends BaseSearchProvider {
    private int clsNum = 0;
    private int mthNum = 0;

    public MethodSearchProvider(MainWindow mw, SearchSettings searchSettings, List<JavaClass> classes) {
        super(mw, searchSettings, classes);
    }

    @Override
    @Nullable
    public JNode next(Cancelable cancelable) {
        while (true) {
            if (cancelable.isCanceled()) {
                return null;
            }
            JavaClass cls = (JavaClass)this.classes.get(this.clsNum);
            List methods = cls.getMethods();
            if (this.mthNum < methods.size()) {
                JavaMethod mth;
                if (!this.checkMth(mth = (JavaMethod)methods.get(this.mthNum++))) continue;
                return this.convert((JavaNode)mth);
            }
            ++this.clsNum;
            this.mthNum = 0;
            if (this.clsNum >= this.classes.size()) break;
        }
        return null;
    }

    private boolean checkMth(JavaMethod mth) {
        MethodInfo mthInfo = mth.getMethodNode().getMethodInfo();
        return this.isMatch(mthInfo.getShortId()) || this.isMatch(mthInfo.getAlias());
    }

    @Override
    public int progress() {
        return this.clsNum;
    }
}

