/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import java.io.IOException;
import org.jitsi.xmpp.extensions.jitsimeet.MuteVideoIq;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class MuteVideoIqProvider
extends IqProvider<MuteVideoIq> {
    public static void registerMuteVideoIqProvider() {
        ProviderManager.addIQProvider("mute", "http://jitsi.org/jitmeet/video", new MuteVideoIqProvider());
    }

    @Override
    public MuteVideoIq parse(XmlPullParser parser, int initialDepth, IqData data2, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        MuteVideoIq iq;
        String namespace = parser.getNamespace();
        if (!"http://jitsi.org/jitmeet/video".equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("mute".equals(rootElement)) {
            String actorStr;
            iq = new MuteVideoIq();
            String jidStr = parser.getAttributeValue("", "jid");
            if (jidStr != null) {
                Jid jid = JidCreate.from(jidStr);
                iq.setJid(jid);
            }
            if ((actorStr = parser.getAttributeValue("", "actor")) != null) {
                Jid actor = JidCreate.from(actorStr);
                iq.setActor(actor);
            }
        } else {
            return null;
        }
        boolean done = false;
        while (!done) {
            switch (parser.next()) {
                case END_ELEMENT: {
                    String name = parser.getName();
                    if (!rootElement.equals(name)) break;
                    done = true;
                    break;
                }
                case TEXT_CHARACTERS: {
                    Boolean mute = Boolean.parseBoolean(parser.getText());
                    iq.setMute(mute);
                    break;
                }
            }
        }
        return iq;
    }
}

