/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.dtls;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsSRTPUtils;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.UseSRTPData;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.CertificateInfo;
import org.jitsi.nlj.dtls.DtlsConfig;
import org.jitsi.nlj.dtls.DtlsUtils;
import org.jitsi.nlj.dtls.DtlsUtilsKt;
import org.jitsi.nlj.srtp.SrtpConfig;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.rtp.extensions.ByteBufferKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030!H\u0016J\b\u0010\"\u001a\u00020\fH\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0015H\u0016J\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0014\u00a2\u0006\u0002\u0010'J,\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0018\u00100\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0016J\b\u00101\u001a\u00020\u0007H\u0016J\u0012\u00102\u001a\u00020\u00072\b\u00103\u001a\u0004\u0018\u00010&H\u0016J\u001a\u00104\u001a\u00020\u00072\u0010\u00105\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00066"}, d2={"Lorg/jitsi/nlj/dtls/TlsClientImpl;", "Lorg/bouncycastle/tls/DefaultTlsClient;", "certificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "notifyServerCertificate", "Lkotlin/Function1;", "Lorg/bouncycastle/tls/Certificate;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/nlj/dtls/CertificateInfo;Lkotlin/jvm/functions/Function1;Lorg/jitsi/utils/logging2/Logger;)V", "chosenSrtpProtectionProfile", "", "getChosenSrtpProtectionProfile", "()I", "setChosenSrtpProtectionProfile", "(I)V", "clientCredentials", "Lorg/bouncycastle/tls/TlsCredentials;", "logger", "session", "Lorg/bouncycastle/tls/TlsSession;", "srtpKeyingMaterial", "", "getSrtpKeyingMaterial", "()[B", "setSrtpKeyingMaterial", "([B)V", "getAuthentication", "Lorg/bouncycastle/tls/TlsAuthentication;", "getCipherSuites", "", "getClientExtensions", "Ljava/util/Hashtable;", "getHandshakeTimeoutMillis", "getSessionToResume", "getSupportedVersions", "", "Lorg/bouncycastle/tls/ProtocolVersion;", "()[Lorg/bouncycastle/tls/ProtocolVersion;", "notifyAlertRaised", "alertLevel", "", "alertDescription", "message", "", "cause", "", "notifyAlertReceived", "notifyHandshakeComplete", "notifyServerVersion", "serverVersion", "processServerExtensions", "serverExtensions", "jitsi-media-transform"})
@SuppressFBWarnings(value={"NP_ALWAYS_NULL"}, justification="False positives with 'lateinit'.")
public final class TlsClientImpl
extends DefaultTlsClient {
    @NotNull
    private final CertificateInfo certificateInfo;
    @NotNull
    private final Function1<Certificate, Unit> notifyServerCertificate;
    @NotNull
    private final Logger logger;
    @Nullable
    private TlsSession session;
    @Nullable
    private TlsCredentials clientCredentials;
    public byte[] srtpKeyingMaterial;
    private int chosenSrtpProtectionProfile;

    public TlsClientImpl(@NotNull CertificateInfo certificateInfo2, @NotNull Function1<? super Certificate, Unit> notifyServerCertificate, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(certificateInfo2, "certificateInfo");
        Intrinsics.checkNotNullParameter(notifyServerCertificate, "notifyServerCertificate");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(DtlsUtilsKt.getBC_TLS_CRYPTO());
        this.certificateInfo = certificateInfo2;
        this.notifyServerCertificate = notifyServerCertificate;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    @NotNull
    public final byte[] getSrtpKeyingMaterial() {
        if (this.srtpKeyingMaterial != null) {
            return this.srtpKeyingMaterial;
        }
        Intrinsics.throwUninitializedPropertyAccessException("srtpKeyingMaterial");
        return null;
    }

    public final void setSrtpKeyingMaterial(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<set-?>");
        this.srtpKeyingMaterial = byArray;
    }

    public final int getChosenSrtpProtectionProfile() {
        return this.chosenSrtpProtectionProfile;
    }

    public final void setChosenSrtpProtectionProfile(int n) {
        this.chosenSrtpProtectionProfile = n;
    }

    @Override
    @Nullable
    public TlsSession getSessionToResume() {
        return this.session;
    }

    @Override
    @NotNull
    public TlsAuthentication getAuthentication() {
        return new TlsAuthentication(this){
            final /* synthetic */ TlsClientImpl this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public TlsCredentials getClientCredentials(@NotNull CertificateRequest certificateRequest) {
                Intrinsics.checkNotNullParameter(certificateRequest, "certificateRequest");
                if (TlsClientImpl.access$getClientCredentials$p(this.this$0) == null) {
                    TlsCrypto tlsCrypto = TlsClientImpl.access$getContext$p$s489618374(this.this$0).getCrypto();
                    if (tlsCrypto == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto");
                    }
                    TlsClientImpl.access$setClientCredentials$p(this.this$0, new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters(TlsClientImpl.access$getContext$p$s489618374(this.this$0)), (BcTlsCrypto)tlsCrypto, PrivateKeyFactory.createKey(TlsClientImpl.access$getCertificateInfo$p(this.this$0).getKeyPair().getPrivate().getEncoded()), TlsClientImpl.access$getCertificateInfo$p(this.this$0).getCertificate(), TlsUtils.isSignatureAlgorithmsExtensionAllowed(TlsClientImpl.access$getContext$p$s489618374(this.this$0).getServerVersion()) ? new SignatureAndHashAlgorithm(4, 3) : null));
                }
                TlsCredentials tlsCredentials = TlsClientImpl.access$getClientCredentials$p(this.this$0);
                Intrinsics.checkNotNull(tlsCredentials);
                return tlsCredentials;
            }

            public void notifyServerCertificate(@NotNull TlsServerCertificate serverCertificate) {
                Intrinsics.checkNotNullParameter(serverCertificate, "serverCertificate");
                TlsClientImpl.access$getNotifyServerCertificate$p(this.this$0).invoke(serverCertificate.getCertificate());
            }
        };
    }

    @Override
    @NotNull
    public Hashtable<?, ?> getClientExtensions() {
        Hashtable<Integer, byte[]> clientExtensions = super.getClientExtensions();
        if (TlsSRTPUtils.getUseSRTPExtension(clientExtensions) == null) {
            if (clientExtensions == null) {
                clientExtensions = new Hashtable<Integer, byte[]>();
            }
            TlsSRTPUtils.addUseSRTPExtension(clientExtensions, new UseSRTPData(CollectionsKt.toIntArray((Collection<Integer>)SrtpConfig.Companion.getProtectionProfiles()), TlsUtils.EMPTY_BYTES));
        }
        byte[] byArray = new byte[]{0};
        clientExtensions.put(65281, byArray);
        Hashtable<Integer, byte[]> hashtable = clientExtensions;
        Intrinsics.checkNotNullExpressionValue(hashtable, "clientExtensions");
        return hashtable;
    }

    public void processServerExtensions(@Nullable Hashtable<?, ?> serverExtensions) {
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension(serverExtensions);
        int[] protectionProfiles2 = useSRTPData.getProtectionProfiles();
        Iterable iterable = SrtpConfig.Companion.getProtectionProfiles();
        Intrinsics.checkNotNullExpressionValue(protectionProfiles2, "protectionProfiles");
        this.chosenSrtpProtectionProfile = DtlsUtils.Companion.chooseSrtpProtectionProfile(iterable, ArraysKt.asIterable(protectionProfiles2));
    }

    @Override
    @NotNull
    public int[] getCipherSuites() {
        return CollectionsKt.toIntArray((Collection<Integer>)DtlsConfig.Companion.getConfig().getCipherSuites());
    }

    @Override
    public int getHandshakeTimeoutMillis() {
        return (int)DtlsUtils.Companion.getConfig().getHandshakeTimeout().toMillis();
    }

    @Override
    public void notifyHandshakeComplete() {
        super.notifyHandshakeComplete();
        TlsSession tlsSession = this.context.getResumableSession();
        if (tlsSession != null) {
            Unit unit;
            TlsSession newSession = tlsSession;
            boolean bl = false;
            TlsSession tlsSession2 = this.session;
            if (tlsSession2 != null) {
                TlsSession existingSession = tlsSession2;
                boolean bl2 = false;
                byte[] byArray = existingSession.getSessionID();
                boolean bl3 = byArray != null ? Arrays.equals(byArray, newSession.getSessionID()) : false;
                if (bl3) {
                    Logger $this$cdebug$iv = this.logger;
                    boolean $i$f$cdebug = false;
                    if ($this$cdebug$iv.isDebugEnabled()) {
                        Logger logger = $this$cdebug$iv;
                        boolean bl4 = false;
                        ByteBuffer byteBuffer = ByteBuffer.wrap(newSession.getSessionID());
                        Intrinsics.checkNotNullExpressionValue(byteBuffer, "wrap(newSession.sessionID)");
                        String newSessionIdHex = ByteBufferKt.toHex(byteBuffer);
                        logger.debug("Resumed DTLS session " + newSessionIdHex);
                    }
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                TlsClientImpl $this$notifyHandshakeComplete_u24lambda_u2d4_u24lambda_u2d3 = this;
                boolean bl5 = false;
                Logger $this$cdebug$iv = $this$notifyHandshakeComplete_u24lambda_u2d4_u24lambda_u2d3.logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    Logger logger = $this$cdebug$iv;
                    boolean bl6 = false;
                    ByteBuffer byteBuffer = ByteBuffer.wrap(newSession.getSessionID());
                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "wrap(newSession.sessionID)");
                    String newSessionIdHex = ByteBufferKt.toHex(byteBuffer);
                    logger.debug("Established DTLS session " + newSessionIdHex);
                }
                $this$notifyHandshakeComplete_u24lambda_u2d4_u24lambda_u2d3.session = newSession;
            }
        }
        SrtpProfileInformation srtpProfileInformation = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(this.chosenSrtpProtectionProfile);
        byte[] byArray = this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 2 * (srtpProfileInformation.getCipherKeyLength() + srtpProfileInformation.getCipherSaltLength()));
        Intrinsics.checkNotNullExpressionValue(byArray, "context.exportKeyingMate\u2026pherSaltLength)\n        )");
        this.setSrtpKeyingMaterial(byArray);
    }

    @Override
    public void notifyServerVersion(@Nullable ProtocolVersion serverVersion) {
        super.notifyServerVersion(serverVersion);
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info("Negotiated DTLS version " + serverVersion);
        }
    }

    @Override
    @NotNull
    protected ProtocolVersion[] getSupportedVersions() {
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[1];
        Intrinsics.checkNotNullExpressionValue(ProtocolVersion.DTLSv12, "DTLSv12");
        return protocolVersionArray;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, @Nullable String message, @Nullable Throwable cause) {
        Logger $this$notifyAlertRaised$iv = this.logger;
        boolean $i$f$notifyAlertRaised = false;
        if (alertDescription == 0) {
            Logger $this$cdebug$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv$iv;
                boolean bl = false;
                logger.debug("close_notify raised, connection closing");
            }
        } else {
            StringBuffer $this$notifyAlertRaised_u24lambda_u2d1$iv = new StringBuffer();
            boolean bl = false;
            Exception e$iv = new Exception();
            StackTraceElement[] stackTraceElementArray = e$iv.getStackTrace();
            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "e.stackTrace");
            for (StackTraceElement el$iv : stackTraceElementArray) {
                Appendable appendable = ((Appendable)$this$notifyAlertRaised_u24lambda_u2d1$iv).append(el$iv.toString());
                Intrinsics.checkNotNullExpressionValue(appendable, "append(value)");
                Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append('\\n')");
            }
            String string = $this$notifyAlertRaised_u24lambda_u2d1$iv.toString();
            Intrinsics.checkNotNullExpressionValue(string, "with(StringBuffer()) {\n \u2026 toString()\n            }");
            String stack$iv = string;
            Logger $this$cinfo$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                Logger logger = $this$cinfo$iv$iv;
                boolean bl2 = false;
                logger.info("Alert raised: level=" + alertLevel + ", description=" + alertDescription + ", message=" + message + " cause=" + cause + " " + stack$iv);
            }
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Logger $this$notifyAlertReceived$iv = this.logger;
        boolean $i$f$notifyAlertReceived = false;
        if (alertDescription == 0) {
            Logger $this$cinfo$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                Logger logger = $this$cinfo$iv$iv;
                boolean bl = false;
                logger.info("close_notify received, connection closing");
            }
        } else {
            Logger $this$cerror$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cerror = false;
            Logger logger = $this$cerror$iv$iv;
            boolean bl = false;
            logger.error("Alert received: level=" + alertLevel + ", description=" + alertDescription + " (" + AlertDescription.getName(alertDescription) + ")");
        }
    }

    public static final /* synthetic */ TlsCredentials access$getClientCredentials$p(TlsClientImpl $this) {
        return $this.clientCredentials;
    }

    public static final /* synthetic */ void access$setClientCredentials$p(TlsClientImpl $this, TlsCredentials tlsCredentials) {
        $this.clientCredentials = tlsCredentials;
    }

    public static final /* synthetic */ TlsClientContext access$getContext$p$s489618374(TlsClientImpl $this) {
        return $this.context;
    }

    public static final /* synthetic */ CertificateInfo access$getCertificateInfo$p(TlsClientImpl $this) {
        return $this.certificateInfo;
    }

    public static final /* synthetic */ Function1 access$getNotifyServerCertificate$p(TlsClientImpl $this) {
        return $this.notifyServerCertificate;
    }
}

