/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.AudioLevelListener;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.transform.node.incoming.Stats;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.AudioLevelHeaderExtension;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0016\u0010!\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0#H\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/AudioLevelReader;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;)V", "audioLevelExtId", "", "Ljava/lang/Integer;", "audioLevelListener", "Lorg/jitsi/nlj/AudioLevelListener;", "getAudioLevelListener", "()Lorg/jitsi/nlj/AudioLevelListener;", "setAudioLevelListener", "(Lorg/jitsi/nlj/AudioLevelListener;)V", "forceMute", "", "getForceMute", "()Z", "setForceMute", "(Z)V", "forwardedSilencePackets", "getForwardedSilencePackets", "()I", "setForwardedSilencePackets", "(I)V", "stats", "Lorg/jitsi/nlj/transform/node/incoming/Stats;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "Companion", "jitsi-media-transform"})
public final class AudioLevelReader
extends ObserverNode {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private Integer audioLevelExtId;
    @Nullable
    private AudioLevelListener audioLevelListener;
    private int forwardedSilencePackets;
    @NotNull
    private final Stats stats;
    private boolean forceMute;
    public static final int MUTED_LEVEL = 127;
    @NotNull
    private static final ConfigDelegate<Integer> forwardedSilencePacketsLimit$delegate;

    public AudioLevelReader(@NotNull ReadOnlyStreamInformationStore streamInformationStore) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        super("Audio level reader");
        this.stats = new Stats(0L, 0L, 0L, 0L, 0L, 0L, 63, null);
        streamInformationStore.onRtpExtensionMapping(RtpExtensionType.SSRC_AUDIO_LEVEL, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>(){

            @Override
            public final void invoke(@Nullable Integer it) {
                audioLevelExtId = it;
            }
        });
    }

    @Nullable
    public final AudioLevelListener getAudioLevelListener() {
        return this.audioLevelListener;
    }

    public final void setAudioLevelListener(@Nullable AudioLevelListener audioLevelListener) {
        this.audioLevelListener = audioLevelListener;
    }

    public final int getForwardedSilencePackets() {
        return this.forwardedSilencePackets;
    }

    public final void setForwardedSilencePackets(int n) {
        this.forwardedSilencePackets = n;
    }

    public final boolean getForceMute() {
        return this.forceMute;
    }

    public final void setForceMute(boolean bl) {
        this.forceMute = bl;
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        block3: {
            boolean silence;
            int level;
            AudioRtpPacket audioRtpPacket;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                    Packet packet = packetInfo.getPacket();
                    AudioRtpPacket audioRtpPacket2 = packet instanceof AudioRtpPacket ? (AudioRtpPacket)packet : null;
                    if (audioRtpPacket2 == null) {
                        return;
                    }
                    audioRtpPacket = audioRtpPacket2;
                    Integer n = this.audioLevelExtId;
                    if (n == null) break block3;
                    int audioLevelId = ((Number)n).intValue();
                    boolean bl = false;
                    RtpPacket.HeaderExtension headerExtension = audioRtpPacket.getHeaderExtension(audioLevelId);
                    if (headerExtension == null) break block3;
                    RtpPacket.HeaderExtension ext = headerExtension;
                    boolean bl2 = false;
                    this.stats.audioLevel();
                    level = AudioLevelHeaderExtension.Companion.getAudioLevel(ext);
                    boolean bl3 = silence = level == 127;
                    if (!silence) {
                        this.stats.nonSilence(AudioLevelHeaderExtension.Companion.getVad(ext));
                    }
                    if (!silence || this.forwardedSilencePackets <= AudioLevelReader.Companion.getForwardedSilencePacketsLimit()) break block4;
                    packetInfo.setShouldDiscard(true);
                    this.stats.discardedSilence();
                    break block3;
                }
                if (!this.forceMute) break block5;
                packetInfo.setShouldDiscard(true);
                this.stats.discardedForceMute();
                break block3;
            }
            this.forwardedSilencePackets = silence ? this.forwardedSilencePackets + 1 : 0;
            AudioLevelListener audioLevelListener = this.audioLevelListener;
            if (audioLevelListener == null) break block3;
            AudioLevelListener listener = audioLevelListener;
            boolean bl = false;
            if (listener.onLevelReceived(audioRtpPacket.getSsrc(), UnsignedKt.toPositiveLong(127 - level))) {
                packetInfo.setShouldDiscard(true);
                this.stats.discardedRanking();
            }
        }
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d3 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d3.addString("audio_level_ext_id", String.valueOf(this.audioLevelExtId));
        $this$getNodeStats_u24lambda_u2d3.addNumber("num_audio_levels", this.stats.getNumAudioLevels());
        $this$getNodeStats_u24lambda_u2d3.addNumber("num_silence_packets_discarded", this.stats.getNumDiscardedSilence());
        $this$getNodeStats_u24lambda_u2d3.addNumber("num_force_mute_discarded", this.stats.getNumDiscardedForceMute());
        $this$getNodeStats_u24lambda_u2d3.addNumber("num_ranking_discarded", this.stats.getNumDiscardedRanking());
        $this$getNodeStats_u24lambda_u2d3.addNumber("num_non_silence", this.stats.getNumNonSilence());
        $this$getNodeStats_u24lambda_u2d3.addNumber("num_non_silence_with_vad", this.stats.getNumNonSilenceWithVad());
        $this$getNodeStats_u24lambda_u2d3.addBoolean("force_mute", this.forceMute);
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    static {
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        boolean $i$f$config = false;
        SupplierBuilder $this$forwardedSilencePacketsLimit_delegate_u24lambda_u2d4 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Integer.TYPE));
        boolean bl = false;
        $this$forwardedSilencePacketsLimit_delegate_u24lambda_u2d4.from("jmt.audio.level.forwarded-silence-packets-limit", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        forwardedSilencePacketsLimit$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/AudioLevelReader$Companion;", "", "()V", "MUTED_LEVEL", "", "forwardedSilencePacketsLimit", "getForwardedSilencePacketsLimit", "()I", "forwardedSilencePacketsLimit$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final int getForwardedSilencePacketsLimit() {
            return ((Number)forwardedSilencePacketsLimit$delegate.getValue(this, $$delegatedProperties[0])).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "forwardedSilencePacketsLimit", "getForwardedSilencePacketsLimit()I", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

