/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.LossListener;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.util.BitrateTracker;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.nlj.util.Rfc3711IndexTracker;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacketBuilder;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.TccHeaderExtension;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u001fJ*\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u000e2\b\u0010/\u001a\u0004\u0018\u00010\u00192\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u000202H\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u000205042\u0006\u00106\u001a\u000202H\u0002J\b\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u0010H\u0002J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020=H\u0014J\u000e\u0010>\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u001fJ\u0010\u0010?\u001a\u00020\u00052\u0006\u0010@\u001a\u000205H\u0002J\u0016\u0010A\u001a\u00020\u00052\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050CH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00190#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/TccGeneratorNode;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "onTccPacketReady", "Lkotlin/Function1;", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "", "streamInformation", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "(Lkotlin/jvm/functions/Function1;Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "currTccSeqNum", "", "<set-?>", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "enabled$delegate", "Lkotlin/properties/ReadWriteProperty;", "lastTccSentTime", "Ljava/time/Instant;", "lock", "", "logger", "lossListeners", "", "Lorg/jitsi/nlj/rtp/LossListener;", "numMultipleTccPackets", "numTccSent", "packetArrivalTimes", "Ljava/util/TreeMap;", "rfc3711IndexTracker", "Lorg/jitsi/nlj/util/Rfc3711IndexTracker;", "tccExtensionId", "Ljava/lang/Integer;", "tccFeedbackBitrate", "Lorg/jitsi/nlj/util/BitrateTracker;", "windowStartSeq", "addLossListener", "listener", "addPacket", "tccSeqNum", "timestamp", "isMarked", "ssrc", "", "buildFeedback", "", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket;", "mediaSsrc", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "isTccReadyToSend", "currentPacketMarked", "observe", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "removeLossListener", "sendTcc", "tccPacket", "trace", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class TccGeneratorNode
extends ObserverNode {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Function1<RtcpPacket, Unit> onTccPacketReady;
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformation;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @Nullable
    private Integer tccExtensionId;
    private int currTccSeqNum;
    @NotNull
    private Instant lastTccSentTime;
    @NotNull
    private final Object lock;
    @NotNull
    private final TreeMap<Integer, Instant> packetArrivalTimes;
    private int windowStartSeq;
    @NotNull
    private final BitrateTracker tccFeedbackBitrate;
    private int numTccSent;
    private int numMultipleTccPackets;
    @NotNull
    private final ReadWriteProperty enabled$delegate;
    @NotNull
    private final Rfc3711IndexTracker rfc3711IndexTracker;
    @NotNull
    private final List<LossListener> lossListeners;

    public TccGeneratorNode(@NotNull Function1<? super RtcpPacket, Unit> onTccPacketReady, @NotNull ReadOnlyStreamInformationStore streamInformation, @NotNull Logger parentLogger, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(onTccPacketReady, "onTccPacketReady");
        Intrinsics.checkNotNullParameter(streamInformation, "streamInformation");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        super("TCC generator");
        this.onTccPacketReady = onTccPacketReady;
        this.streamInformation = streamInformation;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.lastTccSentTime = ClockUtils.NEVER;
        this.lock = new Object();
        this.packetArrivalTimes = new TreeMap();
        this.windowStartSeq = -1;
        this.tccFeedbackBitrate = new BitrateTracker(DurationKt.getSecs(1), DurationKt.getMs(10), null, 4, null);
        Boolean initialValue$iv = false;
        boolean $i$f$observableWhenChanged = false;
        Delegates this_$iv$iv = Delegates.INSTANCE;
        boolean $i$f$observable = false;
        this.enabled$delegate = new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ TccGeneratorNode this$0;
            {
                this.this$0 = tccGeneratorNode;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                void oldValue2;
                Intrinsics.checkNotNullParameter(property, "property");
                Object object = newValue;
                Object object2 = oldValue;
                KProperty property2 = property;
                boolean bl = false;
                if (!Intrinsics.areEqual(oldValue2, newValue2)) {
                    void newValue3;
                    boolean bl2 = (Boolean)newValue2;
                    ((Boolean)oldValue2).booleanValue();
                    boolean bl3 = false;
                    TccGeneratorNode.access$getLogger$p(this.this$0).debug("Setting enabled=" + (boolean)newValue3);
                }
            }
        };
        this.rfc3711IndexTracker = new Rfc3711IndexTracker();
        this.lossListeners = new ArrayList();
        this.streamInformation.onRtpExtensionMapping(RtpExtensionType.TRANSPORT_CC, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>(){

            @Override
            public final void invoke(@Nullable Integer it) {
                tccExtensionId = it;
            }
        });
        this.streamInformation.onRtpPayloadTypesChanged((Function1<? super Map<Byte, ? extends PayloadType>, Unit>)new Function1<Map<Byte, ? extends PayloadType>, Unit>(){

            @Override
            public final void invoke(@NotNull Map<Byte, ? extends PayloadType> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.setEnabled(streamInformation.getSupportsTcc());
            }
        });
    }

    public /* synthetic */ TccGeneratorNode(Function1 function1, ReadOnlyStreamInformationStore readOnlyStreamInformationStore, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemDefaultZone()");
            clock = clock2;
        }
        this(function1, readOnlyStreamInformationStore, logger, clock);
    }

    private final boolean getEnabled() {
        return (Boolean)this.enabled$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setEnabled(boolean bl) {
        this.enabled$delegate.setValue(this, $$delegatedProperties[0], bl);
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        block2: {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            if (!this.getEnabled()) {
                return;
            }
            Integer n = this.tccExtensionId;
            if (n == null) break block2;
            int tccExtId = ((Number)n).intValue();
            boolean bl = false;
            RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
            RtpPacket.HeaderExtension headerExtension = rtpPacket.getHeaderExtension(tccExtId);
            if (headerExtension != null) {
                RtpPacket.HeaderExtension ext = headerExtension;
                boolean bl2 = false;
                int tccSeqNum = this.rfc3711IndexTracker.update(TccHeaderExtension.Companion.getSequenceNumber(ext));
                this.addPacket(tccSeqNum, packetInfo.getReceivedTime(), rtpPacket.isMarked(), rtpPacket.getSsrc());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLossListener(@NotNull LossListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.lossListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void removeLossListener(@NotNull LossListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.lossListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addPacket(int tccSeqNum, Instant timestamp, boolean isMarked, long ssrc2) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.packetArrivalTimes.ceilingKey(this.windowStartSeq) == null) {
                this.packetArrivalTimes.clear();
            }
            Instant instant = timestamp;
            if (instant != null) {
                Instant $this$addPacket_u24lambda_u2d10_u24lambda_u2d8 = instant;
                boolean bl2 = false;
                if (this.packetArrivalTimes.isEmpty() && this.windowStartSeq == -1) {
                    Iterable $this$forEach$iv = this.lossListeners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        LossListener it = (LossListener)element$iv;
                        boolean bl3 = false;
                        it.packetReceived(false);
                    }
                } else {
                    Integer oldMax = !((Map)this.packetArrivalTimes).isEmpty() ? this.packetArrivalTimes.lastKey() : Integer.valueOf(this.windowStartSeq - 1);
                    Intrinsics.checkNotNullExpressionValue(oldMax, "oldMax");
                    if (tccSeqNum > oldMax) {
                        int numLost = tccSeqNum - oldMax - 1;
                        Iterable $this$forEach$iv = this.lossListeners;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            LossListener it = (LossListener)element$iv;
                            boolean bl4 = false;
                            if (numLost > 0) {
                                it.packetLost(numLost);
                            }
                            it.packetReceived(false);
                        }
                    } else if (tccSeqNum < this.windowStartSeq || !this.packetArrivalTimes.containsKey(tccSeqNum)) {
                        Iterable $this$forEach$iv = this.lossListeners;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            LossListener it = (LossListener)element$iv;
                            boolean bl5 = false;
                            it.packetReceived(true);
                        }
                    }
                }
                if (this.windowStartSeq == -1 || tccSeqNum < this.windowStartSeq) {
                    this.windowStartSeq = tccSeqNum;
                }
                this.packetArrivalTimes.putIfAbsent(tccSeqNum, timestamp);
            }
            if (this.isTccReadyToSend(isMarked)) {
                Iterable $this$forEach$iv = this.buildFeedback(ssrc2);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RtcpFbTccPacket it = (RtcpFbTccPacket)element$iv;
                    boolean bl6 = false;
                    this.sendTcc(it);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<RtcpFbTccPacket> buildFeedback(long mediaSsrc) {
        Object object = this.lock;
        synchronized (object) {
            Map.Entry<Integer, Instant> entry;
            Map.Entry<Integer, Instant> entry2;
            block7: {
                boolean bl = false;
                entry2 = this.packetArrivalTimes.ceilingEntry(this.windowStartSeq);
                if (entry2 != null) break block7;
                List<RtcpFbTccPacket> list = CollectionsKt.emptyList();
                return list;
            }
            Intrinsics.checkNotNullExpressionValue(entry, "packetArrivalTimes.ceili\u2026eq) ?: return emptyList()");
            Map.Entry<Integer, Instant> firstEntry = entry2;
            List tccPackets = new ArrayList();
            Ref.ObjectRef currentTccPacket = new Ref.ObjectRef();
            int n = this.currTccSeqNum;
            this.currTccSeqNum = n + 1;
            currentTccPacket.element = new RtcpFbTccPacketBuilder(null, mediaSsrc, n, 1, null);
            RtcpFbTccPacketBuilder rtcpFbTccPacketBuilder = (RtcpFbTccPacketBuilder)currentTccPacket.element;
            Instant instant = firstEntry.getValue();
            Intrinsics.checkNotNullExpressionValue(instant, "firstEntry.value");
            rtcpFbTccPacketBuilder.SetBase(this.windowStartSeq, ClockUtils.toEpochMicro(instant));
            int nextSequenceNumber = 0;
            nextSequenceNumber = this.windowStartSeq;
            SortedMap<Integer, Instant> feedbackBlockPackets = this.packetArrivalTimes.tailMap(this.windowStartSeq);
            Intrinsics.checkNotNullExpressionValue(feedbackBlockPackets, "feedbackBlockPackets");
            Map $this$forEach$iv = feedbackBlockPackets;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry3 = element$iv = iterator2.next();
                boolean bl = false;
                Integer seq = (Integer)entry3.getKey();
                Instant timestamp = (Instant)entry3.getValue();
                Intrinsics.checkNotNullExpressionValue(timestamp, "timestamp");
                long timestampUs = ClockUtils.toEpochMicro(timestamp);
                RtcpFbTccPacketBuilder rtcpFbTccPacketBuilder2 = (RtcpFbTccPacketBuilder)currentTccPacket.element;
                Intrinsics.checkNotNullExpressionValue(seq, "seq");
                if (!rtcpFbTccPacketBuilder2.AddReceivedPacket(seq, timestampUs)) {
                    void $this$buildFeedback_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11;
                    RtcpFbTccPacketBuilder rtcpFbTccPacketBuilder3;
                    tccPackets.add(((RtcpFbTccPacketBuilder)currentTccPacket.element).build());
                    int n2 = this.currTccSeqNum;
                    this.currTccSeqNum = n2 + 1;
                    RtcpFbTccPacketBuilder rtcpFbTccPacketBuilder4 = rtcpFbTccPacketBuilder3 = new RtcpFbTccPacketBuilder(null, mediaSsrc, n2, 1, null);
                    Ref.ObjectRef objectRef = currentTccPacket;
                    boolean bl2 = false;
                    $this$buildFeedback_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.SetBase(seq, timestampUs);
                    $this$buildFeedback_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.AddReceivedPacket(seq, timestampUs);
                    objectRef.element = rtcpFbTccPacketBuilder3;
                }
                nextSequenceNumber = seq + 1;
            }
            tccPackets.add(((RtcpFbTccPacketBuilder)currentTccPacket.element).build());
            if (tccPackets.size() > 1) {
                int n3 = this.numMultipleTccPackets;
                this.numMultipleTccPackets = n3 + 1;
                this.logger.info("Sending TCC feedback in " + tccPackets.size() + " packets (" + feedbackBlockPackets.size() + " media packets)");
            }
            this.windowStartSeq = nextSequenceNumber;
            List list = tccPackets;
            return list;
        }
    }

    private final void sendTcc(RtcpFbTccPacket tccPacket) {
        this.onTccPacketReady.invoke(tccPacket);
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("sent TCC packet with seq num " + tccPacket.getFeedbackSeqNum());
        }
        int n = this.numTccSent;
        this.numTccSent = n + 1;
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
        this.lastTccSentTime = instant;
        this.tccFeedbackBitrate.update(DataSizeKt.getBytes(tccPacket.length), this.clock.millis());
    }

    private final boolean isTccReadyToSend(boolean currentPacketMarked) {
        Instant now = this.clock.instant();
        if (Intrinsics.areEqual(this.lastTccSentTime, ClockUtils.NEVER)) {
            Intrinsics.checkNotNullExpressionValue(now, "now");
            this.lastTccSentTime = now;
            return false;
        }
        Duration timeSinceLastTcc = Duration.between(this.lastTccSentTime, now);
        return timeSinceLastTcc.compareTo(DurationKt.getMs(100)) >= 0 || timeSinceLastTcc.compareTo(DurationKt.getMs(20)) >= 0 && currentPacketMarked;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d15 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d15.addNumber("num_tcc_packets_sent", this.numTccSent);
        $this$getNodeStats_u24lambda_u2d15.addNumber("tcc_feedback_bitrate_bps", this.tccFeedbackBitrate.getRate-rlWvAKk());
        $this$getNodeStats_u24lambda_u2d15.addString("tcc_extension_id", String.valueOf(this.tccExtensionId));
        $this$getNodeStats_u24lambda_u2d15.addNumber("num_multiple_tcc_packets", this.numMultipleTccPackets);
        $this$getNodeStats_u24lambda_u2d15.addBoolean("enabled", this.getEnabled());
        return nodeStatsBlock;
    }

    public static final /* synthetic */ Logger access$getLogger$p(TccGeneratorNode $this) {
        return $this.logger;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(TccGeneratorNode.class, "enabled", "getEnabled()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

