/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.IcmpV6Type;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class IcmpV6Code
extends NamedNumber<Byte, IcmpV6Code> {
    private static final long serialVersionUID = 1442278011840551830L;
    public static final IcmpV6Code NO_CODE = new IcmpV6Code((byte)0, "No Code");
    public static final IcmpV6Code NO_ROUTE_TO_DST = new IcmpV6Code((byte)0, "no route to destination");
    public static final IcmpV6Code COMMUNICATION_WITH_DST_PROHIBITED = new IcmpV6Code((byte)1, "communication with destination administratively prohibited");
    public static final IcmpV6Code BEYOND_SCOPE_OF_SRC_ADDR = new IcmpV6Code((byte)2, "beyond scope of source address");
    public static final IcmpV6Code ADDR_UNREACHABLE = new IcmpV6Code((byte)3, "address unreachable");
    public static final IcmpV6Code PORT_UNREACHABLE = new IcmpV6Code((byte)4, "port unreachable");
    public static final IcmpV6Code SRC_ADDR_FAILED_POLICY = new IcmpV6Code((byte)5, "source address failed ingress/egress policy");
    public static final IcmpV6Code REJECT_ROUTE_TO_DST = new IcmpV6Code((byte)6, "reject route to destination");
    public static final IcmpV6Code ERROR_IN_SRC_ROUTING_HEADER = new IcmpV6Code((byte)7, "Error in Source Routing Header");
    public static final IcmpV6Code HOP_LIMIT_EXCEEDED = new IcmpV6Code((byte)0, "hop limit exceeded in transit");
    public static final IcmpV6Code FRAGMENT_REASSEMBLY_TIME_EXCEEDED = new IcmpV6Code((byte)1, "fragment reassembly time exceeded");
    public static final IcmpV6Code ERRONEOUS_HEADER_FIELD = new IcmpV6Code((byte)0, "erroneous header field encountered");
    public static final IcmpV6Code UNRECOGNIZED_NEXT_HEADER_TYPE = new IcmpV6Code((byte)1, "unrecognized Next Header type encountered");
    public static final IcmpV6Code UNRECOGNIZED_IP_V6_OPT = new IcmpV6Code((byte)2, "unrecognized IPv6 option encountered");
    public static final IcmpV6Code FIRST_FRAGMENT_HAS_INCOMPLETE_IP_V6_HEADER_CHAIN = new IcmpV6Code((byte)3, "IPv6 First Fragment has incomplete IPv6 Header Chain");
    public static final IcmpV6Code ROUTER_RENUMBERING_COMMAND = new IcmpV6Code((byte)0, "Router Renumbering Command");
    public static final IcmpV6Code ROUTER_RENUMBERING_RESULT = new IcmpV6Code((byte)1, "Router Renumbering Result");
    public static final IcmpV6Code SEQUENCE_NUMBER_RESET = new IcmpV6Code((byte)-1, "Sequence Number Reset");
    public static final IcmpV6Code SUBJECT_IP_V6_ADDRESS = new IcmpV6Code((byte)0, "Subject IPv6 address");
    public static final IcmpV6Code SUBJECT_NAME = new IcmpV6Code((byte)1, "Subject name");
    public static final IcmpV6Code SUBJECT_IP_V4_ADDRESS = new IcmpV6Code((byte)2, "Subject IPv4 address");
    public static final IcmpV6Code SUCCESSFUL_REPLY = new IcmpV6Code((byte)0, "Successful reply");
    public static final IcmpV6Code REFUSE = new IcmpV6Code((byte)1, "Refuse");
    public static final IcmpV6Code UNKNOWN_QTYPE = new IcmpV6Code((byte)2, "Unknown Qtype");
    private static final Map<Byte, Map<Byte, IcmpV6Code>> registry = new HashMap<Byte, Map<Byte, IcmpV6Code>>();

    public IcmpV6Code(Byte value2, String name) {
        super(value2, name);
    }

    public static IcmpV6Code getInstance(Byte type2, Byte value2) {
        if (registry.containsKey(type2) && registry.get(type2).containsKey(value2)) {
            return registry.get(type2).get(value2);
        }
        return new IcmpV6Code(value2, "unknown");
    }

    public static IcmpV6Code register(IcmpV6Type type2, IcmpV6Code code) {
        if (registry.containsKey(type2.value())) {
            return registry.get(type2.value()).put((Byte)code.value(), code);
        }
        HashMap map = new HashMap();
        map.put(code.value(), code);
        registry.put((Byte)type2.value(), map);
        return null;
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    @Override
    public int compareTo(IcmpV6Code o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    static {
        HashMap map = new HashMap();
        map.put(NO_ROUTE_TO_DST.value(), NO_ROUTE_TO_DST);
        map.put(COMMUNICATION_WITH_DST_PROHIBITED.value(), COMMUNICATION_WITH_DST_PROHIBITED);
        map.put(BEYOND_SCOPE_OF_SRC_ADDR.value(), BEYOND_SCOPE_OF_SRC_ADDR);
        map.put(ADDR_UNREACHABLE.value(), ADDR_UNREACHABLE);
        map.put(PORT_UNREACHABLE.value(), PORT_UNREACHABLE);
        map.put(SRC_ADDR_FAILED_POLICY.value(), SRC_ADDR_FAILED_POLICY);
        map.put(REJECT_ROUTE_TO_DST.value(), REJECT_ROUTE_TO_DST);
        map.put(ERROR_IN_SRC_ROUTING_HEADER.value(), ERROR_IN_SRC_ROUTING_HEADER);
        registry.put((Byte)IcmpV6Type.DESTINATION_UNREACHABLE.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.PACKET_TOO_BIG.value(), map);
        map = new HashMap();
        map.put(HOP_LIMIT_EXCEEDED.value(), HOP_LIMIT_EXCEEDED);
        map.put(FRAGMENT_REASSEMBLY_TIME_EXCEEDED.value(), FRAGMENT_REASSEMBLY_TIME_EXCEEDED);
        registry.put((Byte)IcmpV6Type.TIME_EXCEEDED.value(), map);
        map = new HashMap();
        map.put(ERRONEOUS_HEADER_FIELD.value(), ERRONEOUS_HEADER_FIELD);
        map.put(UNRECOGNIZED_NEXT_HEADER_TYPE.value(), UNRECOGNIZED_NEXT_HEADER_TYPE);
        map.put(UNRECOGNIZED_IP_V6_OPT.value(), UNRECOGNIZED_IP_V6_OPT);
        map.put(FIRST_FRAGMENT_HAS_INCOMPLETE_IP_V6_HEADER_CHAIN.value(), FIRST_FRAGMENT_HAS_INCOMPLETE_IP_V6_HEADER_CHAIN);
        registry.put((Byte)IcmpV6Type.PARAMETER_PROBLEM.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.ECHO_REQUEST.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.ECHO_REPLY.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.MULTICAST_LISTENER_QUERY.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.MULTICAST_LISTENER_REPORT.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.MULTICAST_LISTENER_DONE.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.ROUTER_SOLICITATION.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.ROUTER_ADVERTISEMENT.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.NEIGHBOR_SOLICITATION.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.NEIGHBOR_ADVERTISEMENT.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.REDIRECT.value(), map);
        map = new HashMap();
        map.put(ROUTER_RENUMBERING_COMMAND.value(), ROUTER_RENUMBERING_COMMAND);
        map.put(ROUTER_RENUMBERING_RESULT.value(), ROUTER_RENUMBERING_RESULT);
        map.put(SEQUENCE_NUMBER_RESET.value(), SEQUENCE_NUMBER_RESET);
        registry.put((Byte)IcmpV6Type.ROUTER_RENUMBERING.value(), map);
        map = new HashMap();
        map.put(SUBJECT_IP_V6_ADDRESS.value(), SUBJECT_IP_V6_ADDRESS);
        map.put(SUBJECT_NAME.value(), SUBJECT_NAME);
        map.put(SUBJECT_IP_V4_ADDRESS.value(), SUBJECT_IP_V4_ADDRESS);
        registry.put((Byte)IcmpV6Type.ICMP_NODE_INFORMATION_QUERY.value(), map);
        map = new HashMap();
        map.put(SUCCESSFUL_REPLY.value(), SUCCESSFUL_REPLY);
        map.put(REFUSE.value(), REFUSE);
        map.put(UNKNOWN_QTYPE.value(), UNKNOWN_QTYPE);
        registry.put((Byte)IcmpV6Type.ICMP_NODE_INFORMATION_RESPONSE.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.INVERSE_NEIGHBOR_DISCOVERY_SOLICITATION.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.INVERSE_NEIGHBOR_DISCOVERY_ADVERTISEMENT.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.HOME_AGENT_ADDRESS_DISCOVERY_REQUEST.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.HOME_AGENT_ADDRESS_DISCOVERY_REPLY.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.MOBILE_PREFIX_SOLICITATION.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV6Type.MOBILE_PREFIX_ADVERTISEMENT.value(), map);
    }
}

