/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.user;

import java.util.function.BiFunction;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;

public class UserPolicyProvider
implements PolicyProvider {
    private final BiFunction<Policy, AuthorizationProvider, UserPolicyRepresentation> representationFunction;

    public UserPolicyProvider(BiFunction<Policy, AuthorizationProvider, UserPolicyRepresentation> representationFunction) {
        this.representationFunction = representationFunction;
    }

    public void evaluate(Evaluation evaluation) {
        EvaluationContext context = evaluation.getContext();
        UserPolicyRepresentation representation = this.representationFunction.apply(evaluation.getPolicy(), evaluation.getAuthorizationProvider());
        for (String userId : representation.getUsers()) {
            if (!context.getIdentity().getId().equals(userId)) continue;
            evaluation.grant();
            break;
        }
    }

    public void close() {
    }
}

