/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;

abstract class ByteCopyingBinder
extends Binder {
    ByteCopyingBinder() {
    }

    @Override
    Binder copyingBinder() {
        return this;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        if (bindUseDBA) {
            return OraclePreparedStatement.theStaticDBACopyingBinder.bind(stmt, bindPosition, rankInBuffer, rank, bindBytes, bindChars, bindIndicators, bytePitch, charPitch, byteoffset, charoffset, lenoffset, indoffset, clearPriorBindValues, localCheckSum, bindData, bindDataOffsets, bindDataLengths, bindDataIndex, bindUseDBA, formOfUse);
        }
        byte[] fromBytes = null;
        int fromByteOffset = 0;
        int len = stmt.lastBoundByteLens[bindPosition];
        if (rankInBuffer == 0) {
            fromBytes = stmt.lastBoundBytes;
            fromByteOffset = stmt.lastBoundByteOffsets[bindPosition];
            bindIndicators[indoffset] = stmt.lastBoundInds[bindPosition];
            bindIndicators[lenoffset] = stmt.lastBoundLens[bindPosition];
            if (fromBytes == bindBytes && fromByteOffset == byteoffset) {
                if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
                    if (bindIndicators[indoffset] == -1) {
                        localCheckSum = CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
                    } else {
                        len = stmt.lastBoundByteLens[bindPosition];
                        localCheckSum = CRC64.updateChecksum(localCheckSum, fromBytes, fromByteOffset, len);
                    }
                }
                return localCheckSum;
            }
            len = stmt.lastBoundByteLens[bindPosition];
            if (len > bytePitch) {
                len = bytePitch;
            }
        } else {
            fromBytes = bindBytes;
            fromByteOffset = byteoffset - bytePitch;
            bindIndicators[indoffset] = bindIndicators[indoffset - 1];
            bindIndicators[lenoffset] = bindIndicators[lenoffset - 1];
            len = bytePitch;
        }
        System.arraycopy(fromBytes, fromByteOffset, bindBytes, byteoffset, len);
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, fromBytes, fromByteOffset, len);
        }
        return localCheckSum;
    }
}

