/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;

class OracleBlobInputStream
extends OracleBufferedStream {
    long lobOffset;
    OracleBlob blob;
    OracleBfile bfile;
    boolean isStreamForBlob;
    long markedByte;
    boolean endOfStream = false;
    long maxPosition = Long.MAX_VALUE;
    boolean internalBlob = false;

    public OracleBlobInputStream(OracleBlob blob, int chunkSize) throws SQLException {
        this(blob, chunkSize, 1L, false);
    }

    public OracleBlobInputStream(OracleBlob blob, int chunkSize, long beginOffset) throws SQLException {
        this(blob, chunkSize, beginOffset, false);
    }

    public OracleBlobInputStream(OracleBlob blob, int chunkSize, boolean isInternal) throws SQLException {
        this(blob, chunkSize, 1L, isInternal);
    }

    public OracleBlobInputStream(OracleBlob blob, int chunkSize, long beginOffset, boolean isInternal) throws SQLException {
        super(chunkSize, ((PhysicalConnection)blob.getInternalConnection())::getByteBufferSync, ((PhysicalConnection)blob.getInternalConnection())::cacheBufferSync);
        if (blob == null || chunkSize <= 0 || beginOffset < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.isStreamForBlob = true;
        this.blob = blob;
        this.bfile = null;
        this.markedByte = -1L;
        this.lobOffset = beginOffset;
        this.internalBlob = isInternal;
    }

    public OracleBlobInputStream(OracleBlob blob, int chunkSize, long beginOffset, long length, boolean isInternal) throws SQLException {
        this(blob, chunkSize, beginOffset, isInternal);
        this.maxPosition = beginOffset + length;
    }

    public OracleBlobInputStream(OracleBlob blob, int chunkSize, long beginOffset, long length) throws SQLException {
        this(blob, chunkSize, beginOffset, false);
        this.maxPosition = beginOffset + length;
    }

    public OracleBlobInputStream(OracleBfile bfile, int chunkSize) throws SQLException {
        this(bfile, chunkSize, 1L);
    }

    public OracleBlobInputStream(OracleBfile bfile, int chunkSize, long beginOffset) throws SQLException {
        super(chunkSize, ((PhysicalConnection)bfile.getInternalConnection())::getByteBufferSync, ((PhysicalConnection)bfile.getInternalConnection())::cacheBufferSync);
        if (bfile == null || chunkSize <= 0 || beginOffset < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.isStreamForBlob = false;
        this.blob = null;
        this.bfile = bfile;
        this.markedByte = -1L;
        this.lobOffset = beginOffset;
    }

    @Override
    public boolean needBytes(int howMany) throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                if (howMany > this.currentBufferSize || howMany == 0) {
                    this.currentBufferSize = Math.max(howMany, this.initialBufferSize);
                }
                byte[] buffer = this.getBuffer(this.currentBufferSize);
                try {
                    int size = (long)this.currentBufferSize < this.maxPosition - this.lobOffset ? this.currentBufferSize : (int)(this.maxPosition - this.lobOffset);
                    this.count = this.isStreamForBlob ? this.blob.getBytes(this.lobOffset, size, buffer) : this.bfile.getBytes(this.lobOffset, size, buffer);
                    if (this.count < this.currentBufferSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lobOffset += (long)this.count;
                        if (this.lobOffset > this.maxPosition) {
                            this.endOfStream = true;
                        }
                        return true;
                    }
                }
                catch (SQLException e) {
                    throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        if (readLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
    }

    public void markInternal(int readLimit) {
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedByte < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lobOffset = this.markedByte;
        this.pos = this.count;
        this.endOfStream = false;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.blob != null && this.internalBlob) {
                this.blob.free();
                this.internalBlob = false;
            }
        }
        catch (SQLException se) {
            throw (IOException)DatabaseError.createIOException(se).fillInStackTrace();
        }
        finally {
            super.close();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        long start = 0L;
        if ((long)(this.count - this.pos) >= n) {
            this.pos = (int)((long)this.pos + n);
            start += n;
        } else {
            start += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long remainLen = 0L;
                remainLen = this.isStreamForBlob ? this.blob.length() - this.lobOffset + 1L : this.bfile.length() - this.lobOffset + 1L;
                if (remainLen >= n - start) {
                    this.lobOffset += n - start;
                    start += n - start;
                } else {
                    this.lobOffset += remainLen;
                    start += remainLen;
                }
            }
            catch (SQLException e) {
                throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
            }
        }
        return start;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.isStreamForBlob) {
            int prefetchSize;
            OracleLargeObject.PrefetchData prefetchData = this.blob.getPrefetchData();
            if (this.blob.isActivePrefetch() && prefetchData != null && (prefetchSize = prefetchData.length()) > 0) {
                if (this.lobOffset == 1L) {
                    return prefetchSize;
                }
                if (this.lobOffset - 1L < (long)prefetchSize) {
                    return prefetchSize - this.pos;
                }
            }
        }
        return super.available();
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection _conn = null;
        try {
            if (this.isStreamForBlob && this.blob != null) {
                _conn = this.blob.getInternalConnection();
            } else if (!this.isStreamForBlob && this.bfile != null) {
                _conn = this.bfile.getInternalConnection();
            }
        }
        catch (Exception exc) {
            _conn = null;
        }
        return _conn;
    }
}

