/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.ide;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.ide.Ide;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.runtime.ide.IdeJsonRPCService;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class IdeProcessor {
    private static final Logger log = Logger.getLogger(IdeProcessor.class);
    private static final Map<String, String> LANG_TO_EXT = Map.of("java", "java", "kotlin", "kt");

    @BuildStep(onlyIf={IsDevelopment.class})
    void createJsonRPCService(BuildProducer<JsonRPCProvidersBuildItem> JsonRPCProvidersProducer, Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem) {
        if (effectiveIdeBuildItem.isPresent()) {
            Ide ide = effectiveIdeBuildItem.get().getIde();
            if (ide != null) {
                DevConsoleManager.register((String)"dev-ui-ide-open", map -> {
                    String fileName = (String)map.get("fileName");
                    String lang = (String)map.get("lang");
                    String lineNumber = (String)map.get("lineNumber");
                    return this.typicalProcessLaunch(fileName, lang, lineNumber, ide);
                });
            }
            JsonRPCProvidersProducer.produce((BuildItem)new JsonRPCProvidersBuildItem("devui-ide-interaction", IdeJsonRPCService.class));
        }
    }

    private boolean typicalProcessLaunch(String className, String lang, String line, Ide ide) {
        String fileName = this.toFileName(className, lang);
        if (fileName == null) {
            return false;
        }
        List args = ide.createFileOpeningArgs(fileName, line);
        return this.launchInIDE(ide, args);
    }

    private String toFileName(String className, String lang) {
        String fileName;
        Path sourceFile;
        String effectiveClassName = className;
        int dollarIndex = className.indexOf("$");
        if (dollarIndex > -1) {
            effectiveClassName = className.substring(0, dollarIndex);
        }
        if ((sourceFile = Ide.findSourceFile((String)(fileName = effectiveClassName.replace('.', File.separatorChar) + "." + LANG_TO_EXT.get(lang)))) == null) {
            return null;
        }
        return sourceFile.toAbsolutePath().toString();
    }

    protected boolean launchInIDE(Ide ide, final List<String> args) {
        final String effectiveCommand = ide.getEffectiveCommand();
        if (this.isNullOrEmpty(effectiveCommand)) {
            return false;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(effectiveCommand);
                    command.addAll(args);
                    new ProcessBuilder(command).inheritIO().start().waitFor(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    log.error((Object)"Could not launch IDE", (Throwable)e);
                }
            }
        }, "Launch in IDE Action").start();
        return true;
    }

    private boolean isNullOrEmpty(String arg) {
        return arg == null || arg.isBlank();
    }
}

