/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern;

import biz.paluch.logging.gelf.intern.OutputAccessor;
import biz.paluch.logging.gelf.intern.ReusableGzipOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

abstract class PoolHolder {
    PoolHolder() {
    }

    public static PoolHolder noop() {
        return NoOpPoolHolder.noop();
    }

    public static PoolHolder threadLocal() {
        return new ThreadLocalPoolHolder();
    }

    public abstract OutputAccessor.OutputAccessorPoolHolder getOutputAccessorPoolHolder();

    public abstract ReusableGzipOutputStream getReusableGzipOutputStream();

    public abstract ByteBuffer[] getSingleBuffer();

    public abstract byte[] getByteArray();

    private static class ThreadLocalPoolHolder
    extends PoolHolder {
        private final OutputAccessor.OutputAccessorPoolHolder outputAccessorPoolHolder;
        private final ThreadLocal<ReusableGzipOutputStream> streamPool = new ThreadLocal<ReusableGzipOutputStream>(){

            @Override
            protected ReusableGzipOutputStream initialValue() {
                try {
                    return new ReusableGzipOutputStream(OutputAccessor.pooledStream(ThreadLocalPoolHolder.this.outputAccessorPoolHolder));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        private final ThreadLocal<ByteBuffer[]> singleBufferPool = new ThreadLocal<ByteBuffer[]>(){

            @Override
            protected ByteBuffer[] initialValue() {
                return new ByteBuffer[1];
            }
        };
        private final ThreadLocal<byte[]> byteArrayPool = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[16384];
            }
        };

        public ThreadLocalPoolHolder() {
            this(new OutputAccessor.OutputAccessorPoolHolder());
        }

        private ThreadLocalPoolHolder(OutputAccessor.OutputAccessorPoolHolder outputAccessorPoolHolder) {
            this.outputAccessorPoolHolder = outputAccessorPoolHolder;
        }

        @Override
        public OutputAccessor.OutputAccessorPoolHolder getOutputAccessorPoolHolder() {
            return this.outputAccessorPoolHolder;
        }

        @Override
        public ReusableGzipOutputStream getReusableGzipOutputStream() {
            return this.streamPool.get();
        }

        @Override
        public ByteBuffer[] getSingleBuffer() {
            return this.singleBufferPool.get();
        }

        @Override
        public byte[] getByteArray() {
            return this.byteArrayPool.get();
        }
    }

    private static class NoOpPoolHolder
    extends PoolHolder {
        private static final NoOpPoolHolder instance = new NoOpPoolHolder();

        private NoOpPoolHolder() {
        }

        public static PoolHolder noop() {
            return instance;
        }

        @Override
        public OutputAccessor.OutputAccessorPoolHolder getOutputAccessorPoolHolder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReusableGzipOutputStream getReusableGzipOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer[] getSingleBuffer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getByteArray() {
            throw new UnsupportedOperationException();
        }
    }
}

