/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.sender.BackOff;
import biz.paluch.logging.gelf.intern.sender.BackOffExecution;
import java.util.concurrent.TimeUnit;

class BoundedBackOff
implements BackOff {
    private final BackOff delegate;
    private final long capMs;

    public BoundedBackOff(BackOff delegate, long timeout, TimeUnit timeUnit) {
        this.delegate = delegate;
        this.capMs = timeUnit.toMillis(timeout);
    }

    @Override
    public BackOffExecution start() {
        return new BoundedBackOffExecution(this.delegate.start(), this.capMs);
    }

    static class BoundedBackOffExecution
    implements BackOffExecution {
        private final BackOffExecution delegate;
        private final long capMs;
        private long pastBackOff;

        public BoundedBackOffExecution(BackOffExecution delegate, long capMs) {
            this.delegate = delegate;
            this.capMs = capMs;
        }

        @Override
        public long nextBackOff() {
            if (this.pastBackOff >= this.capMs) {
                return -1L;
            }
            long backOff = this.delegate.nextBackOff();
            this.pastBackOff += backOff;
            return backOff;
        }
    }
}

