/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

class SessionUpdatesList<S extends SessionEntity> {
    private final RealmModel realm;
    private final ClientModel client;
    private final SessionEntityWrapper<S> entityWrapper;
    private List<SessionUpdateTask<S>> updateTasks = new LinkedList<SessionUpdateTask<S>>();
    private final UserSessionModel.SessionPersistenceState persistenceState;

    public SessionUpdatesList(RealmModel realm, SessionEntityWrapper<S> entityWrapper) {
        this(realm, entityWrapper, UserSessionModel.SessionPersistenceState.PERSISTENT);
    }

    public SessionUpdatesList(RealmModel realm, SessionEntityWrapper<S> entityWrapper, UserSessionModel.SessionPersistenceState persistenceState) {
        this.realm = realm;
        this.entityWrapper = entityWrapper;
        this.persistenceState = persistenceState;
        this.client = entityWrapper.getClientIfNeeded(realm);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public SessionEntityWrapper<S> getEntityWrapper() {
        return this.entityWrapper;
    }

    public void add(SessionUpdateTask<S> task) {
        this.updateTasks.add(task);
    }

    public List<SessionUpdateTask<S>> getUpdateTasks() {
        return this.updateTasks;
    }

    public void setUpdateTasks(List<SessionUpdateTask<S>> updateTasks) {
        this.updateTasks = updateTasks;
    }

    public UserSessionModel.SessionPersistenceState getPersistenceState() {
        return this.persistenceState;
    }
}

