/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Function;

public class DeferredUniWithContext<T>
extends AbstractUni<T> {
    private final Function<Context, Uni<? extends T>> mapper;

    public DeferredUniWithContext(Function<Context, Uni<? extends T>> mapper) {
        this.mapper = mapper;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        Uni<? extends T> uni;
        try {
            uni = this.mapper.apply(subscriber.context());
            if (uni == null) {
                subscriber.onSubscribe(EmptyUniSubscription.DONE);
                subscriber.onFailure(new NullPointerException("The mapper returned `null`"));
                return;
            }
        }
        catch (Throwable failure) {
            subscriber.onSubscribe(EmptyUniSubscription.DONE);
            subscriber.onFailure(failure);
            return;
        }
        AbstractUni.subscribe(uni, subscriber);
    }
}

