/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.ErrorInitializer;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.ExpressionNode;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LineSeparatorNode;
import io.quarkus.qute.ParameterDeclaration;
import io.quarkus.qute.Parser;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.TextNode;
import io.quarkus.qute.WithOrigin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class SectionBlock
implements WithOrigin,
ErrorInitializer {
    public final TemplateNode.Origin origin;
    public final String id;
    public final String label;
    public final Map<String, String> parameters;
    public final Map<String, Expression> expressions;
    List<TemplateNode> nodes;

    public SectionBlock(TemplateNode.Origin origin, String id, String label, Map<String, String> parameters, Map<String, Expression> expressions, List<TemplateNode> nodes) {
        this.origin = origin;
        this.id = id;
        this.label = label;
        this.parameters = parameters;
        this.expressions = expressions;
        this.nodes = ImmutableList.copyOf(nodes);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    List<Expression> getExpressions() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.addAll(this.expressions.values());
        for (TemplateNode node : this.nodes) {
            expressions.addAll(node.getExpressions());
        }
        return expressions;
    }

    Expression findExpression(Predicate<Expression> predicate) {
        for (Expression e : this.expressions.values()) {
            if (!predicate.test(e)) continue;
            return e;
        }
        for (TemplateNode node : this.nodes) {
            Expression found;
            if (node instanceof ExpressionNode) {
                ExpressionImpl e = ((ExpressionNode)node).expression;
                if (!predicate.test(e)) continue;
                return e;
            }
            if (!(node instanceof SectionNode) || (found = ((SectionNode)node).findExpression(predicate)) == null) continue;
            return found;
        }
        return null;
    }

    List<ParameterDeclaration> getParamDeclarations() {
        List<ParameterDeclaration> declarations = null;
        for (TemplateNode node : this.nodes) {
            List<ParameterDeclaration> nodeDeclarations = node.getParameterDeclarations();
            if (nodeDeclarations.isEmpty()) continue;
            if (declarations == null) {
                declarations = new ArrayList<ParameterDeclaration>();
            }
            declarations.addAll(nodeDeclarations);
        }
        return declarations != null ? declarations : Collections.emptyList();
    }

    TemplateNode findNode(Predicate<TemplateNode> predicate) {
        for (TemplateNode node : this.nodes) {
            SectionNode sectionNode;
            TemplateNode found;
            if (predicate.test(node)) {
                return node;
            }
            if (!node.isSection() || (found = (sectionNode = (SectionNode)node).findNode(predicate)) == null) continue;
            return found;
        }
        return null;
    }

    List<TemplateNode> findNodes(Predicate<TemplateNode> predicate) {
        ArrayList<TemplateNode> ret = null;
        for (TemplateNode node : this.nodes) {
            SectionNode sectionNode;
            List<TemplateNode> found;
            if (predicate.test(node)) {
                if (ret == null) {
                    ret = new ArrayList<TemplateNode>();
                }
                ret.add(node);
            }
            if (!node.isSection() || (found = (sectionNode = (SectionNode)node).findNodes(predicate)).isEmpty()) continue;
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.addAll(found);
        }
        return ret == null ? Collections.emptyList() : ret;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SectionBlock [origin=").append(this.origin).append(", id=").append(this.id).append(", label=").append(this.label).append("]");
        return builder.toString();
    }

    @Override
    public TemplateNode.Origin getOrigin() {
        return this.origin;
    }

    void optimizeNodes(Set<TemplateNode> nodesToRemove) {
        ArrayList<TemplateNode> effectiveNodes = new ArrayList<TemplateNode>();
        boolean hasLineSeparator = false;
        boolean nodeIgnored = false;
        for (TemplateNode node : this.nodes) {
            if (node instanceof SectionNode) {
                effectiveNodes.add(node);
                ((SectionNode)node).optimizeNodes(nodesToRemove);
                continue;
            }
            if (node == Parser.COMMENT_NODE || nodesToRemove.contains(node)) {
                nodeIgnored = true;
                continue;
            }
            effectiveNodes.add(node);
            if (!(node instanceof LineSeparatorNode)) continue;
            hasLineSeparator = true;
        }
        if (!hasLineSeparator && !nodeIgnored) {
            return;
        }
        if (hasLineSeparator) {
            ArrayList<TemplateNode> finalNodes = new ArrayList<TemplateNode>();
            ArrayList<TextNode> textGroup = null;
            for (TemplateNode node : effectiveNodes) {
                if (node instanceof TextNode) {
                    if (textGroup == null) {
                        textGroup = new ArrayList<TextNode>();
                    }
                    textGroup.add((TextNode)node);
                    continue;
                }
                if (textGroup != null) {
                    this.collapseGroup(textGroup, finalNodes);
                    textGroup = null;
                }
                finalNodes.add(node);
            }
            if (textGroup != null) {
                this.collapseGroup(textGroup, finalNodes);
            }
            this.nodes = ImmutableList.copyOf(finalNodes);
        } else if (nodeIgnored) {
            this.nodes = ImmutableList.copyOf(effectiveNodes);
        }
    }

    private void collapseGroup(List<TextNode> group, List<TemplateNode> finalNodes) {
        if (group.size() > 1) {
            StringBuilder val = new StringBuilder();
            for (TextNode textNode : group) {
                val.append(textNode.getValue());
            }
            finalNodes.add(new TextNode(val.toString(), group.get(0).getOrigin()));
        } else {
            finalNodes.add(group.get(0));
        }
    }

    static Builder builder(String id, Parser parser, ErrorInitializer errorInitializer) {
        return new Builder(id, parser, errorInitializer).setLabel(id);
    }

    static class Builder
    implements SectionHelperFactory.BlockInfo {
        private final String id;
        private TemplateNode.Origin origin;
        private String label;
        private Map<String, String> parameters;
        private final List<TemplateNode> nodes;
        private Map<String, Expression> expressions;
        private final Parser parser;
        private final ErrorInitializer errorInitializer;

        public Builder(String id, Parser parser, ErrorInitializer errorInitializer) {
            this.id = id;
            this.nodes = new ArrayList<TemplateNode>();
            this.parser = parser;
            this.errorInitializer = errorInitializer;
        }

        Builder setOrigin(TemplateNode.Origin origin) {
            this.origin = origin;
            return this;
        }

        Builder addNode(TemplateNode node) {
            this.nodes.add(node);
            return this;
        }

        Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        Builder addParameter(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, String>();
            }
            this.parameters.put(name, value);
            return this;
        }

        @Override
        public Expression addExpression(String param, String value) {
            ExpressionImpl expression = this.parser.createSectionBlockExpression(this, value);
            if (this.expressions == null) {
                this.expressions = new LinkedHashMap<String, Expression>();
            }
            this.expressions.put(param, expression);
            return expression;
        }

        @Override
        public Map<String, String> getParameters() {
            return this.parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.parameters);
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public TemplateNode.Origin getOrigin() {
            return this.origin;
        }

        @Override
        public TemplateException.Builder error(String message) {
            return this.errorInitializer.error(message);
        }

        SectionBlock build() {
            Map<String, String> parameters = this.parameters;
            parameters = parameters == null ? Collections.emptyMap() : (parameters.size() == 1 ? Map.copyOf(parameters) : Collections.unmodifiableMap(parameters));
            Map<String, Expression> expressions = this.expressions;
            expressions = expressions == null ? Collections.emptyMap() : (expressions.size() == 1 ? Map.copyOf(expressions) : Collections.unmodifiableMap(expressions));
            return new SectionBlock(this.origin, this.id, this.label, parameters, expressions, this.nodes);
        }
    }
}

