/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.util.WaveData;

public class OpenALCreationTest {
    public void alInitialize() {
        try {
            AL.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void alExit() {
        AL.destroy();
    }

    protected IntBuffer createIntBuffer(int size) {
        ByteBuffer temp = ByteBuffer.allocateDirect(4 * size);
        temp.order(ByteOrder.nativeOrder());
        return temp.asIntBuffer();
    }

    protected void exit(int error) {
        System.out.println("OpenAL Error: " + AL10.alGetString((int)error));
        this.alExit();
        System.exit(-1);
    }

    protected void execute(String[] args) {
        System.out.print("initialize...");
        this.alInitialize();
        System.out.println("success");
        this.executeAudioTest();
        System.out.print("shutdown...");
        this.alExit();
        System.out.println("success");
        System.out.print("initialize...");
        this.alInitialize();
        System.out.println("success");
        this.executeAudioTest();
        System.out.print("shutdown...");
        this.alExit();
        System.out.println("success");
    }

    private void executeAudioTest() {
        IntBuffer buffers = this.createIntBuffer(1);
        IntBuffer sources = this.createIntBuffer(1);
        buffers.position(0).limit(1);
        AL10.alGenBuffers((IntBuffer)buffers);
        int lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        sources.position(0).limit(1);
        AL10.alGenSources((IntBuffer)sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        WaveData wavefile = WaveData.create((String)"Footsteps.wav");
        AL10.alBufferData((int)buffers.get(0), (int)wavefile.format, (ByteBuffer)wavefile.data, (int)wavefile.samplerate);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        wavefile.dispose();
        AL10.alSourcei((int)sources.get(0), (int)4105, (int)buffers.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcei((int)sources.get(0), (int)4103, (int)1);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcePlay((int)sources.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        try {
            System.out.print("Playing 'Footsteps.wav' for 2 seconds...");
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("done");
        AL10.alSourceStop((int)sources.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        sources.position(0).limit(1);
        AL10.alDeleteSources((IntBuffer)sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        buffers.position(0).limit(1);
        AL10.alDeleteBuffers((IntBuffer)buffers);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
    }

    public static void main(String[] args) {
        OpenALCreationTest oalCreationTest = new OpenALCreationTest();
        oalCreationTest.execute(args);
        System.exit(0);
    }
}

