/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import processing.app.Preferences;
import processing.app.exec.ProcessRegistry;
import processing.app.exec.StreamPump;
import processing.app.tools.android.AVD;
import processing.app.tools.android.AndroidEnvironment;
import processing.core.PApplet;

class EmulatorController {
    private static final EmulatorController INSTANCE = new EmulatorController();
    private volatile State state = State.NOT_RUNNING;

    EmulatorController() {
    }

    public static EmulatorController getInstance() {
        return INSTANCE;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        System.out.println("Emulator state: " + (Object)((Object)state));
        new Exception().printStackTrace(System.out);
        this.state = state;
    }

    public synchronized void launch() throws IOException {
        if (this.state != State.NOT_RUNNING) {
            String string = "You can't launch an emulator whose state is " + (Object)((Object)this.state);
            throw new IllegalStateException(string);
        }
        String string = Preferences.get("android.emulator.port");
        if (string == null) {
            string = "5566";
            Preferences.set("android.emulator.port", string);
        }
        String[] stringArray = new String[]{"emulator", "-avd", AVD.defaultAVD.name, "-port", string, "-no-boot-anim"};
        final Process process = Runtime.getRuntime().exec(stringArray);
        ProcessRegistry.watch(process);
        this.setState(State.WAITING_FOR_BOOT);
        String string2 = PApplet.join((String[])stringArray, (char)' ');
        new StreamPump(process.getInputStream(), "out: " + string2).addTarget(System.out).start();
        new StreamPump(process.getErrorStream(), "err: " + string2).addTarget(System.err).start();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block6: while (true) {
                    String string;
                    Iterator<String> iterator;
                    try {
                        if (EmulatorController.this.state != State.WAITING_FOR_BOOT) {
                            System.err.println("EmulatorController: Emulator never booted. " + (Object)((Object)EmulatorController.this.state));
                            return;
                        }
                        System.out.println("sleeping for 2 seconds " + new Date().toString());
                        Thread.sleep(2000L);
                        System.out.println("done sleeping");
                        iterator = AndroidEnvironment.listDevices().iterator();
                    }
                    catch (Exception exception) {
                        System.err.println("While waiting for emulator to boot " + exception);
                        process.destroy();
                        return;
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                    do {
                        if (!iterator.hasNext()) continue block6;
                    } while (!(string = iterator.next()).contains("emulator"));
                    break;
                }
                EmulatorController.this.setState(State.RUNNING);
            }
        }, "EmulatorController: Wait for emulator to boot").start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("Emulator was interrupted.");
                    }
                    finally {
                        process.destroy();
                        ProcessRegistry.unwatch(process);
                    }
                }
                finally {
                    EmulatorController.this.setState(State.NOT_RUNNING);
                }
            }
        }, "EmulatorController: Process manager").start();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Interrupted while waiting for emulator to launch.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_RUNNING,
        WAITING_FOR_BOOT,
        RUNNING;

    }
}

