/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.pm.calendar;

import com.projectlibre.core.time.DefaultTimeIntervals;
import com.projectlibre.core.time.TimeInterval;
import com.projectlibre.core.time.TimeIntervals;
import com.projectlibre.pm.calendar.DayType;

public class WorkRange {
    protected DayType type = DayType.DEFAULT;
    protected TimeIntervals intervals = new DefaultTimeIntervals();

    public WorkRange() {
    }

    public WorkRange(DayType dayType) {
        this.type = dayType;
    }

    public TimeIntervals getIntervals() {
        return this.intervals;
    }

    public void setIntervals(TimeIntervals timeIntervals) {
        this.intervals = timeIntervals;
    }

    public DayType getType() {
        return this.type;
    }

    public void setType(DayType dayType) {
        this.type = dayType;
    }

    public boolean isWorking() {
        return this.type == DayType.WORKING;
    }

    public boolean isNonWorking() {
        return this.type == DayType.NON_WORKING;
    }

    public boolean isDefault() {
        return this.type == DayType.DEFAULT;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof WorkRange)) {
            return false;
        }
        WorkRange workRange = (WorkRange)object;
        if (this.type != workRange.getType()) {
            return false;
        }
        return !this.isWorking() || this.intervals.equals(workRange.getIntervals());
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append('\t').append("type=").append((Object)this.type).append('\n');
        stringBuffer.append(string).append("\t").append("intervals=\n");
        for (TimeInterval timeInterval : this.intervals) {
            stringBuffer.append(string).append("\t\t").append(timeInterval).append('\n');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

