/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.go;

import com.fasterxml.jackson.core.type.TypeReference;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.util.GoUtil;
import com.goide.vgo.project.VgoDependency;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.go.UtilsKt;
import com.intellij.packageChecker.model.LibraryDependency;
import com.intellij.packageChecker.model.PreProcessedVulnerablePath;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;
import org.jetbrains.security.problems.vulnerabilities.VulnerablePath;
import org.jetbrains.security.problems.vulnerabilities.VulnerablePaths;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/intellij/packageChecker/go/GoLibraryDependency;", "Lcom/intellij/packageChecker/model/LibraryDependency;", "dep", "Lcom/goide/vgo/project/VgoDependency;", "(Lcom/goide/vgo/project/VgoDependency;)V", "getDep", "()Lcom/goide/vgo/project/VgoDependency;", "component1", "copy", "createPackage", "Lorg/jetbrains/security/package/Package;", "equals", "", "other", "", "extractVulnerablePath", "", "vulnerablePath", "Lorg/jetbrains/security/problems/vulnerabilities/VulnerablePath;", "project", "Lcom/intellij/openapi/project/Project;", "getVulnerableElementQualifiedNames", "", "path", "Lcom/intellij/packageChecker/model/PreProcessedVulnerablePath;", "hashCode", "", "toString", "intellij.packageChecker.go"})
@SourceDebugExtension(value={"SMAP\nGoLibraryDependency.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoLibraryDependency.kt\ncom/intellij/packageChecker/go/GoLibraryDependency\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1446#2,5:50\n1603#2,9:55\n1855#2:64\n1856#2:66\n1612#2:67\n1#3:65\n*S KotlinDebug\n*F\n+ 1 GoLibraryDependency.kt\ncom/intellij/packageChecker/go/GoLibraryDependency\n*L\n28#1:50,5\n29#1:55,9\n29#1:64\n29#1:66\n29#1:67\n29#1:65\n*E\n"})
public final class GoLibraryDependency
implements LibraryDependency {
    @NotNull
    private final VgoDependency dep;

    public GoLibraryDependency(@NotNull VgoDependency dep) {
        Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
        this.dep = dep;
    }

    @NotNull
    public final VgoDependency getDep() {
        return this.dep;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getVulnerableElementQualifiedNames(@NotNull Project project, @NotNull PreProcessedVulnerablePath path) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void destination$iv;
        Iterable $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.getPackageManager() != PackageType.go || StringsKt.isBlank((CharSequence)path.getPathsHolders())) {
            return SetsKt.emptySet();
        }
        List vulnerablePaths2 = (List)LibraryDependency.Companion.getOm().readValue(path.getPathsHolders(), (TypeReference)new TypeReference<List<? extends VulnerablePaths>>(){});
        Intrinsics.checkNotNull((Object)vulnerablePaths2);
        Iterable iterable = vulnerablePaths2;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            VulnerablePaths it = (VulnerablePaths)element$iv;
            boolean bl = false;
            List list = it.getVPath();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv = list;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = (Iterable)destination$iv;
        boolean $i$f$mapNotNull = false;
        void $i$f$flatMapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VulnerablePath vulnerablePath = (VulnerablePath)element$iv$iv;
            boolean bl2 = false;
            if (this.extractVulnerablePath(vulnerablePath, project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final String extractVulnerablePath(VulnerablePath vulnerablePath, Project project) {
        VirtualFile virtualFile = this.dep.getRoot();
        if (virtualFile == null || (virtualFile = virtualFile.findFileByRelativePath(vulnerablePath.getFileName())) == null) {
            return null;
        }
        VirtualFile vulnerableFile = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vulnerableFile);
        GoFile goFile = psiFile instanceof GoFile ? (GoFile)psiFile : null;
        if (goFile == null) {
            return null;
        }
        GoFile goFile2 = goFile;
        String string = GoUtil.getImportPath((PsiElement)((PsiElement)goFile2), (PsiElement)((PsiElement)goFile2));
        if (string == null) {
            return null;
        }
        String importPath = string;
        if (Intrinsics.areEqual((Object)vulnerablePath.getFunctionName(), (Object)"func")) {
            GoFunctionOrMethodDeclaration goFunctionOrMethodDeclaration = GoElementFactory.createFunctionOrMethodDeclaration((Project)project, (String)("func " + vulnerablePath.getFunctionParams() + "{}"), (PsiElement)((PsiElement)goFile2));
            Intrinsics.checkNotNullExpressionValue((Object)goFunctionOrMethodDeclaration, (String)"createFunctionOrMethodDeclaration(...)");
            GoFunctionOrMethodDeclaration declaration = goFunctionOrMethodDeclaration;
            GoMethodDeclaration goMethodDeclaration = declaration instanceof GoMethodDeclaration ? (GoMethodDeclaration)declaration : null;
            if (goMethodDeclaration == null) {
                return null;
            }
            GoMethodDeclaration methodDeclaration = goMethodDeclaration;
            PsiElement psiElement = methodDeclaration.getIdentifier();
            String string2 = psiElement != null ? psiElement.getText() : null;
            if (string2 == null) {
                return null;
            }
            String methodName = string2;
            GoTypeReferenceExpression goTypeReferenceExpression = GoPsiImplUtil.findTypeReference((GoType)methodDeclaration.getReceiverType());
            String receiverTypeName = goTypeReferenceExpression != null ? goTypeReferenceExpression.getText() : null;
            return importPath + "." + receiverTypeName + "." + methodName;
        }
        return importPath + "." + vulnerablePath.getFunctionName();
    }

    @Override
    @Nullable
    public Package createPackage() {
        return UtilsKt.toPackage(this.dep);
    }

    @NotNull
    public final VgoDependency component1() {
        return this.dep;
    }

    @NotNull
    public final GoLibraryDependency copy(@NotNull VgoDependency dep) {
        Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
        return new GoLibraryDependency(dep);
    }

    public static /* synthetic */ GoLibraryDependency copy$default(GoLibraryDependency goLibraryDependency, VgoDependency vgoDependency, int n, Object object) {
        if ((n & 1) != 0) {
            vgoDependency = goLibraryDependency.dep;
        }
        return goLibraryDependency.copy(vgoDependency);
    }

    @NotNull
    public String toString() {
        return "GoLibraryDependency(dep=" + this.dep + ")";
    }

    public int hashCode() {
        return this.dep.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GoLibraryDependency)) {
            return false;
        }
        GoLibraryDependency goLibraryDependency = (GoLibraryDependency)other;
        return Intrinsics.areEqual((Object)this.dep, (Object)goLibraryDependency.dep);
    }
}

