/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.dialog;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.model.DependencyKt;
import com.intellij.packageChecker.model.impl.ProjectDependenciesModelImpl;
import com.intellij.packageChecker.service.IgnorableDependenciesServiceKt;
import com.intellij.packageChecker.service.IgnoreReason;
import com.intellij.packageChecker.toolwindow.dialog.IgnoreVulnerabilitiesDialog;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.TextAreaKt;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0015J\b\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/packageChecker/toolwindow/dialog/IgnoreVulnerabilitiesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "pkg", "Lorg/jetbrains/security/package/Package;", "moduleName", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/security/package/Package;Ljava/lang/String;)V", "reasonIgnoring", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nIgnoreVulnerabilitiesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreVulnerabilitiesDialog.kt\ncom/intellij/packageChecker/toolwindow/dialog/IgnoreVulnerabilitiesDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,73:1\n30#2,3:74\n*S KotlinDebug\n*F\n+ 1 IgnoreVulnerabilitiesDialog.kt\ncom/intellij/packageChecker/toolwindow/dialog/IgnoreVulnerabilitiesDialog\n*L\n37#1:74,3\n*E\n"})
public final class IgnoreVulnerabilitiesDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Package pkg;
    @NotNull
    private final String moduleName;
    @NotNull
    private String reasonIgnoring;

    public IgnoreVulnerabilitiesDialog(@NotNull Project project, @NotNull Package pkg, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        super(project, null, false, DialogWrapper.IdeModalityType.MODELESS, true);
        this.project = project;
        this.pkg = pkg;
        this.moduleName = moduleName;
        this.reasonIgnoring = "";
        this.setTitle(PackageCheckerBundle.message("ignoreVulnerabilities.dialog.title", new Object[0]));
        this.setCancelButtonText(CommonBundle.getCancelButtonText());
        this.setOKButtonText(PackageCheckerBundle.message("ignoreVulnerabilities.dialog.ignore", new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        super.doOKAction();
        if (StringsKt.isBlank((CharSequence)this.reasonIgnoring)) {
            String string = IgnoreReason.NOT_EXPLOITABLE.getTitle().get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            this.reasonIgnoring = string;
        }
        IgnorableDependenciesServiceKt.ignoreVulnerability(this.project, this.pkg, this.moduleName, this.reasonIgnoring);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProjectDependenciesModelImpl> serviceClass$iv = ProjectDependenciesModelImpl.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ((ProjectDependenciesModelImpl)object).refresh(this.project);
    }

    @NlsSafe
    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ IgnoreVulnerabilitiesDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                AtomicBooleanProperty isOtherReason = new AtomicBooleanProperty(false);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ IgnoreVulnerabilitiesDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = PackageCheckerBundle.message("ignoreVulnerabilities.dialog.packageTitle", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$row.label(string);
                        $this$row.label(DependencyKt.simplifiedCoordinates(IgnoreVulnerabilitiesDialog.access$getPkg$p(this.this$0)));
                    }
                }), (int)1, null).layout(RowLayout.PARENT_GRID);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, isOtherReason){
                    final /* synthetic */ IgnoreVulnerabilitiesDialog this$0;
                    final /* synthetic */ AtomicBooleanProperty $isOtherReason;
                    {
                        this.this$0 = $receiver;
                        this.$isOtherReason = $isOtherReason;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = PackageCheckerBundle.message("ignoreVulnerabilities.dialog.reasonTitle", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$row.label(string);
                        Row.comboBox$default((Row)$this$row, (Collection)IgnoreReason.Companion.localizedReasons(), null, (int)2, null).onChanged((Function1)new Function1<ComboBox<String>, Unit>(this.this$0, this.$isOtherReason){
                            final /* synthetic */ IgnoreVulnerabilitiesDialog this$0;
                            final /* synthetic */ AtomicBooleanProperty $isOtherReason;
                            {
                                this.this$0 = $receiver;
                                this.$isOtherReason = $isOtherReason;
                                super(1);
                            }

                            public final void invoke(@NotNull ComboBox<String> it) {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                Object object = it.getItem();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
                                IgnoreVulnerabilitiesDialog.access$setReasonIgnoring$p(this.this$0, (String)object);
                                this.$isOtherReason.set(Intrinsics.areEqual((Object)IgnoreVulnerabilitiesDialog.access$getReasonIgnoring$p(this.this$0), (Object)IgnoreReason.OTHER.getTitle().get()));
                                if (!this.$isOtherReason.get().booleanValue()) {
                                    ApplicationManager.getApplication().invokeLater(() -> createCenterPanel.1.invoke$lambda$0(this.this$0), IgnoreVulnerabilitiesDialog.access$getProject$p(this.this$0).getDisposed());
                                }
                            }

                            private static final void invoke$lambda$0(IgnoreVulnerabilitiesDialog this$0) {
                                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                                this$0.validate();
                                this$0.pack();
                            }
                        });
                    }
                }), (int)1, null).layout(RowLayout.PARENT_GRID);
                Panel.row$default((Panel)$this$panel, null, (Function1)createCenterPanel.3.INSTANCE, (int)1, null).visibleIf((ObservableProperty)isOtherReason).layout(RowLayout.PARENT_GRID);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ IgnoreVulnerabilitiesDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        TextAreaKt.rows((Cell)$this$row.textArea().onChanged((Function1)new Function1<JBTextArea, Unit>(this.this$0){
                            final /* synthetic */ IgnoreVulnerabilitiesDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull JBTextArea it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                String string = it.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                IgnoreVulnerabilitiesDialog.access$setReasonIgnoring$p(this.this$0, string);
                            }
                        }), (int)5).align((Align)AlignX.FILL.INSTANCE);
                    }
                }), (int)1, null).visibleIf((ObservableProperty)isOtherReason);
            }
        }));
    }

    public static final /* synthetic */ Package access$getPkg$p(IgnoreVulnerabilitiesDialog $this) {
        return $this.pkg;
    }

    public static final /* synthetic */ void access$setReasonIgnoring$p(IgnoreVulnerabilitiesDialog $this, String string) {
        $this.reasonIgnoring = string;
    }

    public static final /* synthetic */ String access$getReasonIgnoring$p(IgnoreVulnerabilitiesDialog $this) {
        return $this.reasonIgnoring;
    }

    public static final /* synthetic */ Project access$getProject$p(IgnoreVulnerabilitiesDialog $this) {
        return $this.project;
    }
}

