/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.data.GHComment;
import org.jetbrains.plugins.github.api.data.GithubIssueCommentWithHtml;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRCommentService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHServiceUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCommentServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCommentService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "addComment", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/api/data/GithubIssueCommentWithHtml;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "body", "", "deleteComment", "", "commentId", "updateComment", "Lorg/jetbrains/plugins/github/api/data/GHComment;", "text", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRCommentServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRCommentServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRCommentServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,45:1\n10#2:46\n*S KotlinDebug\n*F\n+ 1 GHPRCommentServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRCommentServiceImpl\n*L\n43#1:46\n*E\n"})
public final class GHPRCommentServiceImpl
implements GHPRCommentService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProgressManager progressManager;
    @NotNull
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private static final Logger LOG;

    public GHPRCommentServiceImpl(@NotNull ProgressManager progressManager, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.progressManager = progressManager;
        this.requestExecutor = requestExecutor;
        this.repository = repository;
    }

    @Override
    @NotNull
    public CompletableFuture<GithubIssueCommentWithHtml> addComment(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String body2) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GithubIssueCommentWithHtml>(this, pullRequestId, body2){
            final /* synthetic */ GHPRCommentServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ String $body;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                this.$body = $body;
                super(1);
            }

            @NotNull
            public final GithubIssueCommentWithHtml invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GithubIssueCommentWithHtml comment = (GithubIssueCommentWithHtml)GHPRCommentServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GithubApiRequests.Repos.Issues.Comments.create(GHPRCommentServiceImpl.access$getRepository$p(this.this$0), this.$pullRequestId.getNumber(), this.$body));
                return comment;
            }
        }), LOG, "Error occurred while adding PR comment");
    }

    @Override
    @NotNull
    public CompletableFuture<GHComment> updateComment(@NotNull ProgressIndicator progressIndicator, @NotNull String commentId, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHComment>(this, commentId, text){
            final /* synthetic */ GHPRCommentServiceImpl this$0;
            final /* synthetic */ String $commentId;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$commentId = $commentId;
                this.$text = $text;
                super(1);
            }

            @NotNull
            public final GHComment invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHComment)GHPRCommentServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.Comment.INSTANCE.updateComment(GHPRCommentServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$commentId, this.$text));
            }
        }), LOG, "Error occurred while updating comment");
    }

    @NotNull
    public CompletableFuture<Object> deleteComment(@NotNull ProgressIndicator progressIndicator, @NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Object>(this, commentId){
            final /* synthetic */ GHPRCommentServiceImpl this$0;
            final /* synthetic */ String $commentId;
            {
                this.this$0 = $receiver;
                this.$commentId = $commentId;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRCommentServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.Comment.INSTANCE.deleteComment(GHPRCommentServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$commentId));
            }
        }), LOG, "Error occurred while deleting comment");
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRCommentServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GHRepositoryCoordinates access$getRepository$p(GHPRCommentServiceImpl $this) {
        return $this.repository;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRCommentService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCommentServiceImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

