/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.collaboration.ui.ComponentListPanelFactory;
import com.intellij.collaboration.ui.SingleValueModel;
import com.intellij.collaboration.ui.codereview.CodeReviewChatItemUIUtil;
import com.intellij.collaboration.ui.codereview.CodeReviewTimelineUIUtil;
import com.intellij.collaboration.ui.codereview.comment.CommentInputActionsComponentFactory;
import com.intellij.collaboration.ui.codereview.timeline.comment.CommentTextFieldFactory;
import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.ListLayout;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineFileEditor;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHCommentTextFieldFactory;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHCommentTextFieldModel;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHCommentTextFieldModelKt;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRCommentsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GHApiLoadingErrorHandler;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRSuggestedChangeHelper;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewsThreadsModelsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewsThreadsModelsProviderImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRSelectInToolWindowHelper;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergingModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTitleComponentFactory;
import org.jetbrains.plugins.github.ui.component.GHHandledErrorPanelModel;
import org.jetbrains.plugins.github.ui.component.GHHtmlErrorPanel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0015J*\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002Jb\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010\r\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRFileEditorComponentFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineFileEditor;", "currentDetails", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineFileEditor;Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;)V", "detailsModel", "Lcom/intellij/collaboration/ui/SingleValueModel;", "errorModel", "Lorg/jetbrains/plugins/github/ui/component/GHHandledErrorPanelModel;", "reviewThreadsModelsProvider", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProviderImpl;", "timelineModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineMergingModel;", "uiDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "create", "Ljavax/swing/JComponent;", "createCommentField", "commentService", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "createItemComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "commentsDataProvider", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;", "htmlImageLoader", "Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "suggestedChangeHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;", "ghostUser", "intellij.vcs.github"})
public final class GHPRFileEditorComponentFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final GHPRTimelineFileEditor editor;
    @NotNull
    private final Disposable uiDisposable;
    @NotNull
    private final SingleValueModel<GHPullRequestShort> detailsModel;
    @NotNull
    private final GHHandledErrorPanelModel errorModel;
    @NotNull
    private final GHPRTimelineMergingModel timelineModel;
    @NotNull
    private final GHPRReviewsThreadsModelsProviderImpl reviewThreadsModelsProvider;

    /*
     * WARNING - void declaration
     */
    public GHPRFileEditorComponentFactory(@NotNull Project project, @NotNull GHPRTimelineFileEditor editor, @NotNull GHPullRequestShort currentDetails) {
        void it;
        Disposable disposable;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)editor), (String)"editor");
        Intrinsics.checkNotNullParameter((Object)currentDetails, (String)"currentDetails");
        this.project = project;
        this.editor = editor;
        Disposable disposable2 = disposable = Disposer.newDisposable();
        GHPRFileEditorComponentFactory gHPRFileEditorComponentFactory = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this.editor), (Disposable)it);
        Disposable disposable3 = disposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"also(...)");
        gHPRFileEditorComponentFactory.uiDisposable = disposable3;
        this.detailsModel = new SingleValueModel((Object)currentDetails);
        String string = GithubBundle.message("pull.request.timeline.cannot.load", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.errorModel = new GHHandledErrorPanelModel(string, new GHApiLoadingErrorHandler(this.project, this.editor.getSecurityService().getAccount(), (Function0<Unit>)((Function0)new Function0<Unit>(this.editor.getTimelineLoader()){

            public final void invoke() {
                ((GHListLoader)this.receiver).reset();
            }
        })));
        this.timelineModel = new GHPRTimelineMergingModel();
        this.reviewThreadsModelsProvider = new GHPRReviewsThreadsModelsProviderImpl(this.editor.getReviewData(), this.uiDisposable);
        this.editor.getDetailsData().loadDetails(this.uiDisposable, (Function1<? super CompletableFuture<GHPullRequest>, Unit>)((Function1)new Function1<CompletableFuture<GHPullRequest>, Unit>(){

            public final void invoke(@NotNull CompletableFuture<GHPullRequest> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                CompletableFutureUtil.INSTANCE.handleOnEdt(it, uiDisposable, (Function2)new Function2<GHPullRequest, Throwable, Unit>(){

                    public final void invoke(@Nullable GHPullRequest pr, @Nullable Throwable throwable) {
                        if (pr != null) {
                            detailsModel.setValue((Object)pr);
                        }
                    }
                });
            }
        }));
        this.editor.getTimelineLoader().addErrorChangeListener(this.uiDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                errorModel.setError(editor.getTimelineLoader().getError());
            }
        }));
        this.errorModel.setError(this.editor.getTimelineLoader().getError());
        this.editor.getTimelineLoader().addDataListener(this.uiDisposable, new GHListLoader.ListDataListener(){

            @Override
            public void onDataAdded(int startIdx) {
                List<GHPRTimelineItem> loadedData = editor.getTimelineLoader().getLoadedData();
                timelineModel.add(loadedData.subList(startIdx, loadedData.size()));
            }

            @Override
            public void onDataUpdated(int idx) {
                List<GHPRTimelineItem> loadedData = editor.getTimelineLoader().getLoadedData();
                GHPRTimelineItem item = loadedData.get(idx);
                timelineModel.update(item);
            }

            @Override
            public void onDataRemoved(@NotNull Object data2) {
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                if (!(data2 instanceof GHPRTimelineItem)) {
                    return;
                }
                timelineModel.remove((GHPRTimelineItem)data2);
            }

            @Override
            public void onAllDataRemoved() {
                timelineModel.removeAll();
            }
        });
        this.timelineModel.add(this.editor.getTimelineLoader().getLoadedData());
    }

    @NotNull
    public final JComponent create() {
        JComponent jComponent;
        JPanel jPanel;
        Wrapper wrapper;
        JComponent jComponent2;
        Wrapper mainPanel2 = new Wrapper();
        DataManager.registerDataProvider((JComponent)((JComponent)mainPanel2), arg_0 -> GHPRFileEditorComponentFactory.create$lambda$1(this, arg_0));
        JComponent it = GHPRTitleComponentFactory.INSTANCE.create(this.project, this.detailsModel);
        boolean bl = false;
        JComponent $this$create_u24lambda_u243 = jComponent2 = CollaborationToolsUIUtil.wrapWithLimitedSize$default((CollaborationToolsUIUtil)CollaborationToolsUIUtil.INSTANCE, (JComponent)it, (Integer)CodeReviewChatItemUIUtil.INSTANCE.getTEXT_CONTENT_WIDTH(), null, (int)4, null);
        boolean bl2 = false;
        $this$create_u24lambda_u243.setBorder((Border)JBUI.Borders.empty((int)20, (int)16));
        JComponent header = jComponent2;
        GHPRSuggestedChangeHelper suggestedChangesHelper = new GHPRSuggestedChangeHelper(this.project, this.uiDisposable, this.editor.getRepositoryDataService().getRemoteCoordinates().getRepository(), this.editor.getReviewData(), this.editor.getDetailsData());
        GHPRTimelineItemComponentFactory itemComponentFactory = this.createItemComponentFactory(this.project, this.editor.getDetailsData(), this.editor.getCommentsData(), this.editor.getReviewData(), this.reviewThreadsModelsProvider, this.editor.getHtmlImageLoader(), this.editor.getAvatarIconsProvider(), suggestedChangesHelper, this.editor.getSecurityService().getGhostUser(), this.editor.getSecurityService().getCurrentUser());
        Wrapper $this$create_u24lambda_u244 = wrapper = new Wrapper();
        boolean bl3 = false;
        $this$create_u24lambda_u244.setOpaque(false);
        Wrapper descriptionWrapper = wrapper;
        this.detailsModel.addAndInvokeListener((Function1)new Function1<GHPullRequestShort, Unit>(descriptionWrapper, itemComponentFactory, this){
            final /* synthetic */ Wrapper $descriptionWrapper;
            final /* synthetic */ GHPRTimelineItemComponentFactory $itemComponentFactory;
            final /* synthetic */ GHPRFileEditorComponentFactory this$0;
            {
                this.$descriptionWrapper = $descriptionWrapper;
                this.$itemComponentFactory = $itemComponentFactory;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull GHPullRequestShort it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$descriptionWrapper.setContent(this.$itemComponentFactory.createComponent((GHPullRequestShort)GHPRFileEditorComponentFactory.access$getDetailsModel$p(this.this$0).getValue()));
            }
        });
        JPanel timeline = ComponentListPanelFactory.createVertical$default((ComponentListPanelFactory)ComponentListPanelFactory.INSTANCE, (ListModel)this.timelineModel, (int)0, (Function1)itemComponentFactory, (int)2, null);
        GHListLoader<GHPRTimelineItem> timelineLoader = this.editor.getTimelineLoader();
        JPanel $this$create_u24lambda_u247 = jPanel = new JPanel((LayoutManager)ListLayout.Companion.vertical$default((ListLayout.Companion)ListLayout.Companion, (int)0, (ListLayout.Alignment)ListLayout.Alignment.CENTER, null, (int)4, null));
        boolean bl4 = false;
        $this$create_u24lambda_u247.setOpaque(false);
        JComponent $this$create_u24lambda_u247_u24lambda_u245 = jComponent = GHHtmlErrorPanel.create$default(GHHtmlErrorPanel.INSTANCE, this.errorModel, 0, 2, null);
        boolean bl5 = false;
        $this$create_u24lambda_u247_u24lambda_u245.setBorder(CodeReviewTimelineUIUtil.INSTANCE.getITEM_BORDER());
        JComponent errorPanel = jComponent;
        JComponent $this$create_u24lambda_u247_u24lambda_u246 = $this$create_u24lambda_u247_u24lambda_u245 = new JLabel((Icon)new AnimatedIcon.Default());
        boolean bl6 = false;
        $this$create_u24lambda_u247_u24lambda_u246.setBorder(CodeReviewTimelineUIUtil.INSTANCE.getITEM_BORDER());
        $this$create_u24lambda_u247_u24lambda_u246.setVisible(timelineLoader.getLoading());
        JComponent loadingIcon = $this$create_u24lambda_u247_u24lambda_u245;
        timelineLoader.addLoadingStateChangeListener(this.uiDisposable, (Function0<Unit>)((Function0)new Function0<Unit>((JLabel)loadingIcon, timelineLoader){
            final /* synthetic */ JLabel $loadingIcon;
            final /* synthetic */ GHListLoader<GHPRTimelineItem> $timelineLoader;
            {
                this.$loadingIcon = $loadingIcon;
                this.$timelineLoader = $timelineLoader;
                super(0);
            }

            public final void invoke() {
                this.$loadingIcon.setVisible(this.$timelineLoader.getLoading());
            }
        }));
        $this$create_u24lambda_u247.add(errorPanel);
        $this$create_u24lambda_u247.add(loadingIcon);
        JPanel it2 = jPanel;
        boolean bl7 = false;
        JComponent progressAndErrorPanel2 = CollaborationToolsUIUtil.wrapWithLimitedSize$default((CollaborationToolsUIUtil)CollaborationToolsUIUtil.INSTANCE, (JComponent)it2, (Integer)(CodeReviewChatItemUIUtil.INSTANCE.getTEXT_CONTENT_WIDTH() + 32), null, (int)4, null);
        JPanel $this$create_u24lambda_u2410 = it2 = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
        boolean bl8 = false;
        $this$create_u24lambda_u2410.setBorder((Border)JBUI.Borders.empty((int)6, (int)0));
        $this$create_u24lambda_u2410.add(header);
        $this$create_u24lambda_u2410.add((Component)descriptionWrapper);
        $this$create_u24lambda_u2410.add(timeline);
        $this$create_u24lambda_u2410.add(progressAndErrorPanel2);
        if (this.editor.getSecurityService().currentUserHasPermissionLevel(GHRepositoryPermissionLevel.READ)) {
            JComponent $this$create_u24lambda_u2410_u24lambda_u249 = $this$create_u24lambda_u247_u24lambda_u245 = this.createCommentField(this.editor.getCommentsData(), this.editor.getAvatarIconsProvider(), this.editor.getSecurityService().getCurrentUser());
            boolean bl9 = false;
            $this$create_u24lambda_u2410_u24lambda_u249.setBorder(JBUI.Borders.empty((Insets)CodeReviewChatItemUIUtil.ComponentType.FULL.getInputPaddingInsets()));
            JComponent commentField = $this$create_u24lambda_u247_u24lambda_u245;
            $this$create_u24lambda_u2410.add(commentField);
        }
        JPanel timelinePanel = it2;
        JScrollPane $this$create_u24lambda_u2411 = bl8 = ScrollPaneFactory.createScrollPane((Component)timelinePanel, (boolean)true);
        boolean bl10 = false;
        $this$create_u24lambda_u2411.setOpaque(false);
        $this$create_u24lambda_u2411.getViewport().setOpaque(false);
        $this$create_u24lambda_u2411.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener($this$create_u24lambda_u2411, timelineLoader){
            private boolean firstScroll;
            final /* synthetic */ JScrollPane $this_apply;
            final /* synthetic */ GHListLoader<GHPRTimelineItem> $timelineLoader;
            {
                this.$this_apply = $receiver;
                this.$timelineLoader = $timelineLoader;
                this.firstScroll = true;
            }

            public void stateChanged(@NotNull ChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.firstScroll && this.$this_apply.getVerticalScrollBar().getValue() > 0) {
                    this.firstScroll = false;
                }
                if (!this.firstScroll && this.$timelineLoader.canLoadMore()) {
                    GHListLoader.loadMore$default(this.$timelineLoader, false, 1, null);
                }
            }
        });
        JScrollPane jScrollPane = bl8;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"apply(...)");
        JScrollPane scrollPane2 = jScrollPane;
        UiNotifyConnector.doWhenFirstShown((JComponent)scrollPane2, () -> GHPRFileEditorComponentFactory.create$lambda$12(timelineLoader));
        timelineLoader.addDataListener(this.uiDisposable, new GHListLoader.ListDataListener(scrollPane2, timelineLoader){
            final /* synthetic */ JScrollPane $scrollPane;
            final /* synthetic */ GHListLoader<GHPRTimelineItem> $timelineLoader;
            {
                this.$scrollPane = $scrollPane;
                this.$timelineLoader = $timelineLoader;
            }

            public void onAllDataRemoved() {
                if (this.$scrollPane.isShowing()) {
                    GHListLoader.loadMore$default(this.$timelineLoader, false, 1, null);
                }
            }
        });
        mainPanel2.setContent((JComponent)scrollPane2);
        ActionManager actionManager = ActionManager.getInstance();
        actionManager.getAction("Github.PullRequest.Timeline.Update").registerCustomShortcutSet((JComponent)scrollPane2, this.uiDisposable);
        String groupId = "Github.PullRequest.Timeline.Popup";
        PopupHandler.installPopupMenu((JComponent)scrollPane2, (String)groupId, (String)"popup");
        return (JComponent)mainPanel2;
    }

    private final JComponent createCommentField(GHPRCommentsDataProvider commentService, IconsProvider<String> avatarIconsProvider, GHUser currentUser) {
        GHCommentTextFieldModel model2 = new GHCommentTextFieldModel(this.project, (Function1)new Function1<String, CompletableFuture<?>>(commentService){
            final /* synthetic */ GHPRCommentsDataProvider $commentService;
            {
                this.$commentService = $commentService;
                super(1);
            }

            @NotNull
            public final CompletableFuture<?> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$commentService.addComment((ProgressIndicator)new EmptyProgressIndicator(), it);
            }
        });
        String submitShortcutText = CommentInputActionsComponentFactory.INSTANCE.getSubmitShortcutText();
        String string = GithubBundle.message("action.comment.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        StateFlow stateFlow = (StateFlow)StateFlowKt.MutableStateFlow((Object)GHCommentTextFieldModelKt.submitAction(model2, string));
        Object[] objectArray = new Object[]{submitShortcutText};
        String string2 = GithubBundle.message("pull.request.comment.hint", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        CommentInputActionsComponentFactory.Config actions = new CommentInputActionsComponentFactory.Config(stateFlow, null, null, null, (StateFlow)StateFlowKt.MutableStateFlow((Object)string2), 14, null);
        CommentTextFieldFactory.IconConfig icon = CommentTextFieldFactory.IconConfig.Companion.of(CodeReviewChatItemUIUtil.ComponentType.FULL, avatarIconsProvider, (Object)currentUser.getAvatarUrl());
        return new GHCommentTextFieldFactory(model2).create(actions, icon);
    }

    private final GHPRTimelineItemComponentFactory createItemComponentFactory(Project project, GHPRDetailsDataProvider detailsDataProvider, GHPRCommentsDataProvider commentsDataProvider, GHPRReviewDataProvider reviewDataProvider, GHPRReviewsThreadsModelsProvider reviewThreadsModelsProvider, AsyncHtmlImageLoader htmlImageLoader, IconsProvider<String> avatarIconsProvider, GHPRSuggestedChangeHelper suggestedChangeHelper, GHUser ghostUser, GHUser currentUser) {
        GHPRSelectInToolWindowHelper selectInToolWindowHelper = new GHPRSelectInToolWindowHelper(project, ((GHPullRequestShort)this.detailsModel.getValue()).getPrId());
        return new GHPRTimelineItemComponentFactory(project, detailsDataProvider, commentsDataProvider, reviewDataProvider, htmlImageLoader, avatarIconsProvider, reviewThreadsModelsProvider, selectInToolWindowHelper, suggestedChangeHelper, ghostUser, ((GHPullRequestShort)this.detailsModel.getValue()).getAuthor(), currentUser);
    }

    private static final Object create$lambda$1(GHPRFileEditorComponentFactory this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PlatformDataKeys.UI_DISPOSABLE.is(it) ? this$0.uiDisposable : null;
    }

    private static final void create$lambda$12(GHListLoader $timelineLoader) {
        Intrinsics.checkNotNullParameter((Object)$timelineLoader, (String)"$timelineLoader");
        GHListLoader.loadMore$default($timelineLoader, false, 1, null);
    }
}

