/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.ide.DataManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/python/console/PyConsoleEnterHandler;", "", "()V", "checkComplete", "", "el", "Lcom/intellij/psi/PsiElement;", "executeEnterHandler", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "findFirstNoneSpaceElement", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "", "getLineAtOffset", "", "doc", "Lcom/intellij/openapi/editor/Document;", "handleEnterPressed", "isCompleteDocString", "str", "isElementInsideDocString", "atElement", "caretOffset", "isMultilineString", "intellij.python.community.impl"})
public final class PyConsoleEnterHandler {
    public final boolean handleEnterPressed(@NotNull EditorEx editor2) {
        LogicalPosition caretPosition;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project = editor2.getProject();
        if (project == null) {
            throw new IllegalArgumentException();
        }
        Project project2 = project;
        int lineCount = editor2.getDocument().getLineCount();
        if (lineCount > 0) {
            editor2.getSelectionModel().removeSelection();
            LogicalPosition logicalPosition = editor2.getCaretModel().getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            caretPosition = logicalPosition;
            if (caretPosition.line != lineCount - 1) {
                this.executeEnterHandler(project2, editor2);
                return false;
            }
        } else {
            return true;
        }
        int lineEndOffset = editor2.getDocument().getLineEndOffset(caretPosition.line);
        editor2.getCaretModel().moveToOffset(lineEndOffset);
        PsiDocumentManager psiMgr = PsiDocumentManager.getInstance((Project)project2);
        psiMgr.commitDocument((Document)editor2.getDocument());
        int caretOffset = editor2.getExpectedCaretOffset();
        PsiFile psiFile = psiMgr.getPsiFile((Document)editor2.getDocument());
        Intrinsics.checkNotNull((Object)psiFile);
        PsiElement atElement = this.findFirstNoneSpaceElement(psiFile, caretOffset);
        if (atElement == null) {
            this.executeEnterHandler(project2, editor2);
            return false;
        }
        DocumentEx documentEx = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        String firstLine = this.getLineAtOffset((Document)documentEx, DocumentUtil.getFirstNonSpaceCharOffset((Document)((Document)editor2.getDocument()), (int)0));
        boolean isCellMagic = StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)firstLine)).toString(), (String)"%%", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)((Object)StringsKt.trimEnd((CharSequence)firstLine)).toString(), (String)"?", (boolean)false, (int)2, null);
        DocumentEx documentEx2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx2, (String)"getDocument(...)");
        String prevLine = this.getLineAtOffset((Document)documentEx2, caretOffset);
        boolean isLineContinuation = StringsKt.endsWith$default((CharSequence)((Object)StringsKt.trim((CharSequence)prevLine)).toString(), (char)'\\', (boolean)false, (int)2, null);
        boolean insideDocString = this.isElementInsideDocString(atElement, caretOffset);
        boolean isMultiLineCommand = PsiTreeUtil.getParentOfType((PsiElement)atElement, PyStatementListContainer.class) != null || isCellMagic;
        boolean isAtTheEndOfCommand = editor2.getDocument().getLineNumber(caretOffset) == editor2.getDocument().getLineCount() - 1;
        boolean hasCompleteStatement = !insideDocString && !isLineContinuation && this.checkComplete(atElement);
        this.executeEnterHandler(project2, editor2);
        return isAtTheEndOfCommand && hasCompleteStatement && (isMultiLineCommand && StringsKt.isBlank((CharSequence)prevLine) || !isMultiLineCommand);
    }

    private final void executeEnterHandler(Project project, EditorEx editor2) {
        EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
        WriteCommandAction.runWriteCommandAction((Project)project, () -> PyConsoleEnterHandler.executeEnterHandler$lambda$0(enterHandler, editor2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isElementInsideDocString(PsiElement atElement, int caretOffset) {
        if (!(atElement.getContext() instanceof PyStringLiteralExpression)) return false;
        if (!PyTokenTypes.TRIPLE_NODES.contains(atElement.getNode().getElementType())) {
            if (atElement.getNode().getElementType() != PyTokenTypes.DOCSTRING) return false;
        }
        String string = atElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!this.isMultilineString(string)) return false;
        if (atElement.getTextRange().getEndOffset() > caretOffset) return true;
        String string2 = atElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        if (this.isCompleteDocString(string2)) return false;
        return true;
    }

    private final boolean checkComplete(PsiElement el) {
        PyStatementListContainer compoundStatement = (PyStatementListContainer)PsiTreeUtil.getParentOfType((PsiElement)el, PyStatementListContainer.class);
        if (compoundStatement != null && !(compoundStatement instanceof PyTryPart)) {
            return compoundStatement.getStatementList().getStatements().length != 0;
        }
        PsiElement topLevel = PyPsiUtils.getParentRightBefore(el, (PsiElement)el.getContainingFile());
        return topLevel != null && !PsiTreeUtil.hasErrorElements((PsiElement)topLevel);
    }

    private final PsiElement findFirstNoneSpaceElement(PsiFile psiFile, int offset) {
        for (int i = offset; -1 < i; --i) {
            PsiElement el = psiFile.findElementAt(i);
            if (el == null || el instanceof PsiWhiteSpace) continue;
            return el;
        }
        return null;
    }

    private final String getLineAtOffset(Document doc, int offset) {
        int line2 = doc.getLineNumber(offset);
        int start = doc.getLineStartOffset(line2);
        int end = doc.getLineEndOffset(line2);
        String string = doc.getText(new TextRange(start, end));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private final boolean isMultilineString(String str) {
        String string = str.substring(PyStringLiteralUtil.getPrefixLength(str));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String text = string;
        return StringsKt.startsWith$default((String)text, (String)"\"\"\"", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"'''", (boolean)false, (int)2, null);
    }

    private final boolean isCompleteDocString(String str) {
        int prefixLen = PyStringLiteralUtil.getPrefixLength(str);
        String string = str.substring(prefixLen);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String text = string;
        String[] stringArray = new String[]{"\"\"\"", "'''"};
        for (String token : stringArray) {
            if (text.length() < 2 * token.length() || !StringsKt.startsWith$default((String)text, (String)token, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)text, (String)token, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    private static final void executeEnterHandler$lambda$0(EditorActionHandler $enterHandler, EditorEx $editor) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        $enterHandler.execute((Editor)$editor, null, DataManager.getInstance().getDataContext((Component)$editor.getComponent()));
    }
}

