/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebugValueDescriptor;
import com.jetbrains.python.debugger.PyDebugValueGroupsKt;
import com.jetbrains.python.debugger.PyDebuggerEvaluator;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.psi.PyUtil;
import icons.PythonIcons;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStackFrame
extends XStackFrame {
    private static final Logger LOG = Logger.getInstance(PyStackFrame.class);
    private static final Object STACK_FRAME_EQUALITY_OBJECT = new Object();
    @NotNull
    @NonNls
    public static final Set<String> COMPREHENSION_NAMES = Set.of("<genexpr>", "<listcomp>", "<dictcomp>", "<setcomp>");
    private final Project myProject;
    private final PyFrameAccessor myDebugProcess;
    private final PyStackFrameInfo myFrameInfo;
    private final XSourcePosition myPosition;
    private volatile boolean isExternal;
    @Nullable
    private Map<String, PyDebugValueDescriptor> myChildrenDescriptors;
    @Topic.AppLevel
    public static final Topic<PyStackFrameRefreshedListener> TOPIC = new Topic(PyStackFrameRefreshedListener.class);

    public PyStackFrame(@NotNull Project project, @NotNull PyFrameAccessor debugProcess, @NotNull PyStackFrameInfo frameInfo, XSourcePosition position) {
        if (project == null) {
            PyStackFrame.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            PyStackFrame.$$$reportNull$$$0(1);
        }
        if (frameInfo == null) {
            PyStackFrame.$$$reportNull$$$0(2);
        }
        this.isExternal = true;
        this.myProject = project;
        this.myDebugProcess = debugProcess;
        this.myFrameInfo = frameInfo;
        this.myPosition = position;
        this.computeIsExternal();
    }

    private void computeIsExternal() {
        if (this.myPosition != null) {
            VirtualFile file = this.myPosition.getFile();
            PyUtil.runWithProgress(this.myProject, PyBundle.message("debugger.progress.title.stackframe.processing", new Object[0]), false, true, (Consumer<? super ProgressIndicator>)((Consumer)indicator -> {
                this.isExternal = (Boolean)ReadAction.compute(() -> {
                    Document document = FileDocumentManager.getInstance().getDocument(file);
                    if (document != null && this.myProject != null) {
                        return !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(file);
                    }
                    return true;
                });
            }));
        }
    }

    public Object getEqualityObject() {
        return STACK_FRAME_EQUALITY_OBJECT;
    }

    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    public XDebuggerEvaluator getEvaluator() {
        return new PyDebuggerEvaluator(this.myProject, this.myDebugProcess);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component2) {
        if (component2 == null) {
            PyStackFrame.$$$reportNull$$$0(3);
        }
        component2.setIcon(AllIcons.Debugger.Frame);
        if (this.myPosition == null) {
            component2.append(PyBundle.message("debugger.stack.frame.frame.not.available", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
            return;
        }
        component2.append(this.myFrameInfo.getName(), PyStackFrame.gray(this.isExternal));
        component2.append(", ", PyStackFrame.gray(this.isExternal));
        component2.append(this.myPosition.getFile().getName(), PyStackFrame.gray(this.isExternal));
        component2.append(":", PyStackFrame.gray(this.isExternal));
        component2.append(Integer.toString(this.myPosition.getLine() + 1), PyStackFrame.gray(this.isExternal));
    }

    protected static SimpleTextAttributes gray(boolean gray) {
        return gray ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            PyStackFrame.$$$reportNull$$$0(4);
        }
        if (node.isObsolete()) {
            return;
        }
        this.myDebugProcess.setCurrentRootNode(node);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                boolean cached = this.myDebugProcess.isFrameCached(this);
                XValueChildrenList values = this.myDebugProcess.loadFrame(this);
                if (!node.isObsolete()) {
                    this.addChildren(node, values);
                }
                if (values != null && !cached) {
                    PyDebugValue.getAsyncValues(this, this.myDebugProcess, values);
                }
            }
            catch (PyDebuggerException e) {
                if (!node.isObsolete()) {
                    node.setErrorMessage(PyBundle.message("debugger.stack.frame.unable.to.display.frame.variables", new Object[0]));
                }
                LOG.warn((Throwable)e);
            }
        });
    }

    protected void addChildren(@NotNull XCompositeNode node, @Nullable XValueChildrenList children2) {
        if (node == null) {
            PyStackFrame.$$$reportNull$$$0(5);
        }
        if (children2 == null) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        PyDebuggerSettings debuggerSettings = PyDebuggerSettings.getInstance();
        XValueChildrenList filteredChildren = new XValueChildrenList();
        boolean isReturnEmpty = true;
        boolean isSpecialEmpty = true;
        for (int i = 0; i < children2.size(); ++i) {
            XValue value = children2.getValue(i);
            String name2 = children2.getName(i);
            if (!(value instanceof PyDebugValue)) continue;
            PyDebugValue pyValue = (PyDebugValue)value;
            this.restoreValueDescriptor(pyValue);
            if (name2.equals("_dummy_ret_val") && debuggerSettings.isWatchReturnValues()) {
                isReturnEmpty = false;
                continue;
            }
            if (!debuggerSettings.isSimplifiedView()) {
                if (ProtocolParser.HIDDEN_TYPES.contains(name2)) continue;
                filteredChildren.add(name2, value);
                continue;
            }
            if (name2.equals("_dummy_special_var") || name2.equals("_dummy_ipython_val")) {
                isSpecialEmpty = false;
                continue;
            }
            filteredChildren.add(name2, value);
        }
        node.addChildren(filteredChildren, isReturnEmpty && isSpecialEmpty);
        if (!isReturnEmpty) {
            PyDebugValueGroupsKt.addGroupValues(PyBundle.message("debugger.stack.frame.return.values", new Object[0]), AllIcons.Debugger.WatchLastReturnValue, node, null, this.myDebugProcess, ProcessDebugger.GROUP_TYPE.RETURN, "()");
        }
        if (!isSpecialEmpty) {
            PyDebugValueGroupsKt.addGroupValues(PyBundle.message("debugger.stack.frame.special.variables", new Object[0]), PythonIcons.Python.Debug.SpecialVar, node, null, this.myDebugProcess, ProcessDebugger.GROUP_TYPE.SPECIAL, null);
        }
        ((PyStackFrameRefreshedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).stackFrameRefreshed();
    }

    public String getThreadId() {
        return this.myFrameInfo.getThreadId();
    }

    public String getFrameId() {
        return this.myFrameInfo.getId();
    }

    public String getThreadFrameId() {
        return this.myFrameInfo.getThreadId() + ":" + this.myFrameInfo.getId();
    }

    protected XSourcePosition getPosition() {
        return this.myPosition;
    }

    @NotNull
    public String getName() {
        String string = this.myFrameInfo.getName();
        if (string == null) {
            PyStackFrame.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isComprehension() {
        return COMPREHENSION_NAMES.contains(this.getName());
    }

    public void setChildrenDescriptors(@Nullable Map<String, PyDebugValueDescriptor> childrenDescriptors) {
        this.myChildrenDescriptors = childrenDescriptors;
    }

    public void restoreChildrenDescriptors(@NotNull Map<String, Map<String, PyDebugValueDescriptor>> descriptorsCache) {
        if (descriptorsCache == null) {
            PyStackFrame.$$$reportNull$$$0(7);
        }
        String threadFrameId = this.getThreadFrameId();
        Map<String, PyDebugValueDescriptor> childrenDescriptors = descriptorsCache.getOrDefault(threadFrameId, Maps.newHashMap());
        this.setChildrenDescriptors(childrenDescriptors);
        descriptorsCache.put(threadFrameId, childrenDescriptors);
    }

    private void restoreValueDescriptor(PyDebugValue value) {
        if (this.myChildrenDescriptors != null) {
            PyDebugValueDescriptor descriptor2 = this.myChildrenDescriptors.getOrDefault(value.getName(), null);
            if (descriptor2 == null) {
                descriptor2 = new PyDebugValueDescriptor();
                this.myChildrenDescriptors.put(value.getName(), descriptor2);
            }
            value.setDescriptor(descriptor2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyStackFrame";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyStackFrame";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restoreChildrenDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static interface PyStackFrameRefreshedListener {
        public void stackFrameRefreshed();
    }
}

