/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyMandatoryEncodingInspection;
import com.jetbrains.python.inspections.quickfix.AddEncodingQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class PyNonAsciiCharInspection
extends PyInspection {
    @NlsSafe
    public String myDefaultEncoding = "utf-8";
    public int myEncodingFormatIndex = 0;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyNonAsciiCharInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyNonAsciiCharInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{PyMandatoryEncodingInspection.defaultEncodingDropDown(), PyMandatoryEncodingInspection.encodingFormatDropDown()});
        if (optPane == null) {
            PyNonAsciiCharInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyNonAsciiCharInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyNonAsciiCharInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        public void visitComment(@NotNull PsiComment node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.checkString((PsiElement)node, node.getText());
        }

        private void checkString(PsiElement node, String value) {
            if (LanguageLevel.forElement(node).isPython2()) {
                PsiFile file = node.getContainingFile();
                if (file == null) {
                    return;
                }
                String charsetString = PythonFileType.getCharsetFromEncodingDeclaration(file);
                boolean hasNonAscii = false;
                CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
                int length = value.length();
                char c = '\u0000';
                for (int i = 0; i < length; ++i) {
                    c = value.charAt(i);
                    if (asciiEncoder.canEncode(c)) continue;
                    hasNonAscii = true;
                    break;
                }
                if (hasNonAscii && charsetString == null) {
                    this.registerProblem(node, PyPsiBundle.message("INSP.non.ascii.char.non.ascii.character.in.file.but.no.encoding.declared", Character.valueOf(c)), new AddEncodingQuickFix(PyNonAsciiCharInspection.this.myDefaultEncoding, PyNonAsciiCharInspection.this.myEncodingFormatIndex));
                }
            }
        }

        @Override
        public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            this.checkString(node, node.getText());
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            this.checkString((PsiElement)node, node.getText());
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            this.checkString(node, node.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyNonAsciiCharInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyStringLiteralExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyReferenceExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

