/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.flake8;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Flake8InspectionSuppressor
implements InspectionSuppressor {
    @NonNls
    public static final String NOQA = "noqa";
    private static final Pattern NOQA_COMMENT_PATTERN = Pattern.compile("# noqa(?::\\s?(?<codes>([A-Z]+[0-9]+(?:[,\\s]+)?)+))?.*", 2);
    private static final ImmutableSetMultimap<String, String> ourInspectionToFlake8Code = ImmutableSetMultimap.builder().put((Object)"F401", (Object)"PyUnresolvedReferences").put((Object)"F402", (Object)"PyShadowingNames").put((Object)"F404", (Object)"PyFromFutureImport").put((Object)"F407", (Object)"PyUnresolvedReferences").put((Object)"F601", (Object)"PyDictDuplicateKeys").put((Object)"F602", (Object)"PyDictDuplicateKeys").put((Object)"F622", (Object)"PyTupleAssignmentBalance").put((Object)"F811", (Object)"PyRedeclaration").put((Object)"F812", (Object)"PyRedeclaration").put((Object)"F821", (Object)"PyUnresolvedReferences").put((Object)"F822", (Object)"PyUnresolvedReferences").putAll((Object)"F823", (Object[])new String[]{"PyUnresolvedReferences", "PyUnboundLocalVariable"}).put((Object)"F831", (Object)"PyUnusedLocal").put((Object)"F841", (Object)"PyUnusedLocal").put((Object)"C90", (Object)"PyUnusedLocal").put((Object)"E711", (Object)"PyComparisonWithNone").build().inverse();

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        Set<String> givenCodes;
        if (element == null) {
            Flake8InspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            Flake8InspectionSuppressor.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiFileSystemItem || !(element.getContainingFile() instanceof PyFile)) {
            return false;
        }
        PsiComment comment = PyPsiUtils.findSameLineComment(element);
        if (comment != null && (givenCodes = Flake8InspectionSuppressor.extractNoqaCodes(comment)) != null) {
            ImmutableSet knownCodes = ourInspectionToFlake8Code.get((Object)toolId);
            return givenCodes.isEmpty() || StreamEx.of((Collection)knownCodes).cross(givenCodes).anyMatch((known, given) -> known.startsWith((String)given));
        }
        return false;
    }

    @Nullable
    public static Set<String> extractNoqaCodes(@NotNull PsiComment comment) {
        String commentText;
        if (comment == null) {
            Flake8InspectionSuppressor.$$$reportNull$$$0(2);
        }
        if ((commentText = comment.getText()) == null) {
            return null;
        }
        int noqaOffset = commentText.toLowerCase(Locale.ENGLISH).indexOf("# noqa");
        if (noqaOffset < 0) {
            return null;
        }
        String noqaSuffix = commentText.substring(noqaOffset);
        Matcher matcher = NOQA_COMMENT_PATTERN.matcher(noqaSuffix);
        if (matcher.matches()) {
            String codeList = matcher.group("codes");
            return codeList == null ? Collections.emptySet() : Set.of(codeList.split("[,\\s]+"));
        }
        return null;
    }

    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            Flake8InspectionSuppressor.$$$reportNull$$$0(3);
        }
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            Flake8InspectionSuppressor.$$$reportNull$$$0(4);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/flake8/Flake8InspectionSuppressor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/flake8/Flake8InspectionSuppressor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractNoqaCodes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

