/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.typeignore;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.codeInsight.typing.PyTypingAnnotationInjector;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/typeignore/TypeIgnoreInspectionSuppressor;", "Lcom/intellij/codeInspection/InspectionSuppressor;", "()V", "getSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "toolId", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "isSuppressedFor", "", "Companion", "intellij.python.community.impl"})
public final class TypeIgnoreInspectionSuppressor
implements InspectionSuppressor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> inspectionsToSuppress;

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        if (element instanceof PsiFile) {
            return false;
        }
        if (!(element.getContainingFile() instanceof PyFile)) {
            return false;
        }
        if (!inspectionsToSuppress.contains(toolId)) {
            return false;
        }
        PsiComment psiComment = PyPsiUtils.findSameLineComment(element);
        if (psiComment == null) {
            return false;
        }
        PsiComment comment = psiComment;
        return PyTypingAnnotationInjector.isTypeIgnoreComment((PsiElement)comment);
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        Intrinsics.checkNotNullExpressionValue((Object)SuppressQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    static {
        Object[] objectArray = new String[]{"PyUnresolvedReferences", "PyTypeHints", "PyTypeChecker", "PyRedeclaration", "PyArgumentList", "PyFinal", "PyProtocol", "PyTypedDict"};
        inspectionsToSuppress = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/inspections/typeignore/TypeIgnoreInspectionSuppressor$Companion;", "", "()V", "inspectionsToSuppress", "", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

