/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackagesNotificationPanel;
import com.jetbrains.python.packaging.ui.PyInstalledPackagesPanel;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PyManagePackagesDialog
extends DialogWrapper {
    private final JPanel myMainPanel;

    public PyManagePackagesDialog(final @NotNull Project project, @NotNull Sdk sdk2) {
        if (project == null) {
            PyManagePackagesDialog.$$$reportNull$$$0(0);
        }
        if (sdk2 == null) {
            PyManagePackagesDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.setTitle(PyBundle.message("manage.python.packages", new Object[0]));
        List sdks2 = ContainerUtil.sorted(PythonSdkUtil.getAllSdks(), (Comparator)new PreferredSdkComparator());
        final JComboBox sdkComboBox = new JComboBox(new CollectionComboBoxModel(sdks2, (Object)sdk2));
        sdkComboBox.setRenderer(new PySdkListCellRenderer());
        PyPackagesNotificationPanel notificationPanel = new PyPackagesNotificationPanel();
        final PyInstalledPackagesPanel packagesPanel = new PyInstalledPackagesPanel(project, notificationPanel);
        packagesPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        packagesPanel.updatePackages(PyPackageManagers.getInstance().getManagementService(project, sdk2));
        packagesPanel.updateNotifications(sdk2);
        this.myMainPanel = new JPanel(new BorderLayout());
        LabeledComponent sdkLabeledComponent = LabeledComponent.create(sdkComboBox, (String)PySdkBundle.message("python.interpreter.label", new Object[0]));
        sdkLabeledComponent.setLabelLocation("West");
        this.myMainPanel.add((Component)sdkLabeledComponent, "North");
        this.myMainPanel.add((Component)((Object)packagesPanel), "Center");
        this.myMainPanel.add((Component)notificationPanel.getComponent(), "South");
        sdkComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sdk sdk2 = (Sdk)sdkComboBox.getSelectedItem();
                packagesPanel.updatePackages(PyPackageManagers.getInstance().getManagementService(project, sdk2));
                packagesPanel.updateNotifications(sdk2);
            }
        });
        this.init();
        this.myMainPanel.setPreferredSize(new Dimension(JBUIScale.scale((int)900), JBUIScale.scale((int)700)));
        this.myMainPanel.setMinimumSize(new Dimension(JBUIScale.scale((int)900), JBUIScale.scale((int)700)));
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected String getDimensionServiceKey() {
        return "PyManagePackagesDialog";
    }

    protected Action @NotNull [] createActions() {
        return new Action[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sdk";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/packaging/PyManagePackagesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

