/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.stubs.PyTypeParameterElementType;
import com.jetbrains.python.psi.stubs.PyTypeParameterStub;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeParameterImpl
extends PyBaseElementImpl<PyTypeParameterStub>
implements PyTypeParameter {
    public PyTypeParameterImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyTypeParameterImpl(PyTypeParameterStub stub) {
        this(stub, PyElementTypes.TYPE_PARAMETER);
    }

    public PyTypeParameterImpl(PyTypeParameterStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyTypeParameter(this);
    }

    @Nullable
    public String getName() {
        PyTypeParameterStub stub = (PyTypeParameterStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    @Override
    @Nullable
    public PyExpression getBoundExpression() {
        return (PyExpression)PsiTreeUtil.getChildOfType((PsiElement)this, PyExpression.class);
    }

    @Override
    @Nullable
    public String getBoundExpressionText() {
        PyTypeParameterStub stub = (PyTypeParameterStub)this.getStub();
        if (stub != null) {
            return stub.getBoundExpressionText();
        }
        PyExpression boundExpression = this.getBoundExpression();
        if (boundExpression != null) {
            return boundExpression.getText();
        }
        return null;
    }

    @Override
    @NotNull
    public PyTypeParameter.Kind getKind() {
        PyTypeParameterStub stub = (PyTypeParameterStub)this.getStub();
        if (stub != null) {
            PyTypeParameter.Kind kind = stub.getKind();
            if (kind == null) {
                PyTypeParameterImpl.$$$reportNull$$$0(0);
            }
            return kind;
        }
        PyTypeParameter.Kind kind = PyTypeParameterElementType.getTypeParameterKindFromPsi(this);
        if (kind == null) {
            PyTypeParameterImpl.$$$reportNull$$$0(1);
        }
        return kind;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode nameNode = this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
        return nameNode != null ? nameNode.getPsi() : null;
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        PsiElement identifier;
        if (name2 == null) {
            PyTypeParameterImpl.$$$reportNull$$$0(2);
        }
        if ((identifier = this.getNameIdentifier()) != null) {
            ASTNode newName = PyUtil.createNewName(this, name2);
            ASTNode nameNode = identifier.getNode();
            this.getNode().replaceChild(nameNode, newName);
        }
        return this;
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PyClass pyClass;
        if (context == null) {
            PyTypeParameterImpl.$$$reportNull$$$0(3);
        }
        if (key == null) {
            PyTypeParameterImpl.$$$reportNull$$$0(4);
        }
        PyPsiFacade facade = PyPsiFacade.getInstance(this.getProject());
        PyTypeParameter.Kind kind = this.getKind();
        switch (kind) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TypeVar: {
                PyClass pyClass2 = facade.createClassByQName("typing.TypeVar", (PsiElement)this);
                break;
            }
            case TypeVarTuple: {
                PyClass pyClass2 = facade.createClassByQName("typing.TypeVarTuple", (PsiElement)this);
                break;
            }
            case ParamSpec: {
                PyClass pyClass2 = pyClass = facade.createClassByQName("typing.ParamSpec", (PsiElement)this);
            }
        }
        if (pyClass != null) {
            return new PyClassTypeImpl(pyClass, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyTypeParameterImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyTypeParameterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

