/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.PythonConsoleScripts;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.ScriptBuilder;
import com.jetbrains.python.run.StringLiteralTargetFunctionWrapper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a&\u0010\u0000\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0003`\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001ak\u0010\u0000\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00070\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00070\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\u00070\fH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0003\u001a8\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0003`\u0004*\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0003`\u0004H\u0007\u001a\f\u0010\u000e\u001a\u00020\u0003*\u00020\u0003H\u0007\u00a8\u0006\u0013"}, d2={"buildScriptFunctionWithConsoleRun", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "config", "Lcom/jetbrains/python/run/PythonRunConfiguration;", "T", "stringBuilderConstructor", "Lkotlin/Function0;", "Lcom/jetbrains/python/run/ScriptBuilder;", "t", "Lkotlin/Function1;", "toTargetPath", "toStringLiteral", "(Lcom/jetbrains/python/run/PythonRunConfiguration;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "buildScriptWithConsoleRun", "escape", "s", "intellij.python.community.impl"})
@JvmName(name="PythonConsoleScripts")
public final class PythonConsoleScripts {
    @NotNull
    public static final String buildScriptWithConsoleRun(@NotNull PythonRunConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Project project = config.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Sdk sdk2 = config.getSdk();
        PyConsoleOptions.PyConsoleSettings pyConsoleSettings = PyConsoleOptions.getInstance(project2).getPythonConsoleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleSettings, (String)"getPythonConsoleSettings(...)");
        PyRemotePathMapper pathMapper = PydevConsoleRunnerUtil.getPathMapper(project2, sdk2, pyConsoleSettings);
        return (String)PythonConsoleScripts.buildScriptFunctionWithConsoleRun(config, buildScriptWithConsoleRun.1.INSTANCE, buildScriptWithConsoleRun.2.INSTANCE, (Function1)new Function1<String, String>(pathMapper){
            final /* synthetic */ PyRemotePathMapper $pathMapper;
            {
                this.$pathMapper = $pathMapper;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = this.$pathMapper;
                if (object == null || (object = ((PyRemotePathMapper)object).convertToRemote(it)) == null) {
                    object = it;
                }
                return object;
            }
        }, buildScriptWithConsoleRun.4.INSTANCE);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final Function<TargetEnvironment, String> buildScriptFunctionWithConsoleRun(@NotNull PythonRunConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return (Function)PythonConsoleScripts.buildScriptFunctionWithConsoleRun(config, buildScriptFunctionWithConsoleRun.1.INSTANCE, buildScriptFunctionWithConsoleRun.2.INSTANCE, buildScriptFunctionWithConsoleRun.3.INSTANCE, buildScriptFunctionWithConsoleRun.4.INSTANCE);
    }

    private static final <T> T buildScriptFunctionWithConsoleRun(PythonRunConfiguration config, Function0<? extends ScriptBuilder<T>> stringBuilderConstructor, Function1<? super String, ? extends T> t, Function1<? super String, ? extends T> toTargetPath, Function1<? super T, ? extends T> toStringLiteral) {
        ScriptBuilder scriptBuilder = (ScriptBuilder)stringBuilderConstructor.invoke();
        Map map = config.getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvs(...)");
        Map configEnvs = map;
        configEnvs.remove("PYTHONUNBUFFERED");
        if (!configEnvs.isEmpty()) {
            scriptBuilder.append(t.invoke((Object)"import os\n"));
            for (Map.Entry entry : configEnvs.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Intrinsics.checkNotNull((Object)key);
                String string = PythonConsoleScripts.toStringLiteral(key);
                Intrinsics.checkNotNull((Object)value);
                scriptBuilder.append(t.invoke((Object)("os.environ[" + string + "] = " + PythonConsoleScripts.toStringLiteral(value) + "\n")));
            }
        }
        String string = PythonScriptCommandLineState.getExpandedScriptName(config);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpandedScriptName(...)");
        String scriptPath = string;
        String workingDir = config.getWorkingDirectory();
        scriptBuilder.append(t.invoke((Object)"runfile("));
        scriptBuilder.append(toStringLiteral.invoke(toTargetPath.invoke((Object)scriptPath)));
        List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)config.getScriptParameters());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
        List scriptParameters = list;
        if (scriptParameters.size() != 0) {
            scriptBuilder.append(t.invoke((Object)(", args=[" + CollectionsKt.joinToString$default((Iterable)scriptParameters, (CharSequence)", ", null, null, (int)0, null, (Function1)buildScriptFunctionWithConsoleRun.5.INSTANCE, (int)30, null) + "]")));
        }
        Intrinsics.checkNotNull((Object)workingDir);
        if (!(((CharSequence)workingDir).length() == 0)) {
            scriptBuilder.append(t.invoke((Object)", wdir="));
            String string2 = PythonScriptCommandLineState.getExpandedWorkingDir(config);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExpandedWorkingDir(...)");
            scriptBuilder.append(toStringLiteral.invoke(toTargetPath.invoke((Object)string2)));
        }
        if (config.isModuleMode()) {
            scriptBuilder.append(t.invoke((Object)", is_module=True"));
        }
        scriptBuilder.append(t.invoke((Object)")"));
        return scriptBuilder.build();
    }

    @Contract(pure=true)
    private static final String escape(String s) {
        String string = StringUtil.escapeCharCharacters((String)s);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeCharCharacters(...)");
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static final String toStringLiteral(@NotNull String $this$toStringLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringLiteral, (String)"<this>");
        return "'" + PythonConsoleScripts.escape($this$toStringLiteral) + "'";
    }

    @Contract(pure=true)
    @NotNull
    public static final Function<TargetEnvironment, String> toStringLiteral(@NotNull Function<TargetEnvironment, String> $this$toStringLiteral) {
        Intrinsics.checkNotNullParameter($this$toStringLiteral, (String)"<this>");
        return (Function)((Object)new StringLiteralTargetFunctionWrapper($this$toStringLiteral));
    }
}

