/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.actions.RenameElementAction;
import com.jetbrains.extensions.python.VirtualFileExtKt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.PyImportErrorsMapsKt;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/python/run/PythonImportErrorFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "shouldHandle", "", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "computeLine", "createFilterResult", "name", "createInlayProvider", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createOpenFileAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "createRenameAction", "getFileByName", "getModuleName", "input", "Companion", "CreateImportExceptionResult", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPythonImportErrorFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonImportErrorFilter.kt\ncom/jetbrains/python/run/PythonImportErrorFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class PythonImportErrorFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private boolean shouldHandle;
    @NotNull
    private static final String TRACEBACK_STRING = "Traceback (most recent call last):\n";
    @NotNull
    private static final String ERROR_IN_SITECUSTOMIZE_STRING = "Error in sitecustomize; set PYTHONVERBOSE for traceback:\n";
    @NotNull
    private static final String FATAL_ERROR_STRING = "Fatal Python error:";
    @NotNull
    private static final String TRIM_PATTERN = "(";
    @NotNull
    private static final Set<String> ERRORS_STRINGS;

    public PythonImportErrorFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line2, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        return this.shouldHandle(line2) ? this.computeLine(line2, entireLength) : null;
    }

    private final boolean shouldHandle(String input) {
        if (!this.shouldHandle) {
            this.shouldHandle = Intrinsics.areEqual((Object)TRACEBACK_STRING, (Object)input) || Intrinsics.areEqual((Object)ERROR_IN_SITECUSTOMIZE_STRING, (Object)input) || StringsKt.indexOf$default((CharSequence)input, (String)FATAL_ERROR_STRING, (int)0, (boolean)false, (int)6, null) != -1;
        }
        return this.shouldHandle;
    }

    private final Filter.Result computeLine(String line2, int entireLength) {
        for (String error : ERRORS_STRINGS) {
            String string;
            if (StringsKt.indexOf$default((CharSequence)line2, (String)error, (int)0, (boolean)false, (int)6, null) == -1 || (string = this.getModuleName(line2)) == null) continue;
            String it = string;
            boolean bl = false;
            return this.createFilterResult(it, entireLength);
        }
        return null;
    }

    private final String getModuleName(String line2) {
        String string;
        int index = StringsKt.indexOf$default((CharSequence)line2, (String)TRIM_PATTERN, (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string2 = line2.substring(0, index);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = line2;
        }
        String key = StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (CharSequence)"\n");
        if (PyImportErrorsMapsKt.getIMPORT_ERRORS_FILTER_MAP().containsKey(key)) {
            return PyImportErrorsMapsKt.getIMPORT_ERRORS_FILTER_MAP().get(key);
        }
        return null;
    }

    private final Filter.Result createFilterResult(String name2, int entireLength) {
        Filter.Result result2;
        VirtualFile virtualFile = this.getFileByName(name2);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            result2 = this.createInlayProvider(it, entireLength);
        } else {
            result2 = null;
        }
        return result2;
    }

    private final Filter.Result createInlayProvider(VirtualFile virtualFile, int entireLength) {
        Object[] objectArray = new Filter.ResultItem[]{new CreateImportExceptionResult(0, entireLength - 1, virtualFile), new Filter.ResultItem(0, 0, null)};
        return new Filter.Result(CollectionsKt.listOf((Object[])objectArray));
    }

    private final VirtualFile getFileByName(String name2) {
        Collection collection = FilenameIndex.getVirtualFilesByName((String)name2, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.project));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
        Collection virtualFiles = collection;
        return (VirtualFile)CollectionsKt.firstOrNull((Iterable)virtualFiles);
    }

    private final AnAction createRenameAction(VirtualFile virtualFile) {
        Object[] objectArray = new Object[]{virtualFile.getName()};
        String string = PyBundle.message("run.debug.shadowing.name.import.error.rename", objectArray);
        return (AnAction)new DumbAwareAction(virtualFile, this, string){
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ PythonImportErrorFilter this$0;
            {
                this.$virtualFile = $virtualFile;
                this.this$0 = $receiver;
                super($super_call_param$1);
                this.setShortcutSet(ActionUtil.getShortcutSet((String)"RenameElement"));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RenameElementAction action = new RenameElementAction();
                PsiFileSystemItem psiFileSystemItem = VirtualFileExtKt.toPsi(this.$virtualFile, this.this$0.getProject());
                PsiFile targetPsiFile = psiFileSystemItem != null ? psiFileSystemItem.getContainingFile() : null;
                DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PSI_FILE, (Object)targetPsiFile).add(CommonDataKeys.PSI_ELEMENT, (Object)targetPsiFile).add(CommonDataKeys.PROJECT, (Object)this.this$0.getProject()).build();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
                DataContext simpleContext = dataContext;
                ActionUtil.invokeAction((AnAction)((AnAction)action), (DataContext)simpleContext, (String)"unknown", null, null);
            }
        };
    }

    private final AnAction createOpenFileAction(VirtualFile virtualFile) {
        Object[] objectArray = new Object[]{virtualFile.getName()};
        String string = PyBundle.message("run.debug.shadowing.name.import.error.open.file", objectArray);
        return (AnAction)new DumbAwareAction(virtualFile, this, string){
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ PythonImportErrorFilter this$0;
            {
                this.$virtualFile = $virtualFile;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                OpenFileAction.Companion.openFile(this.$virtualFile, this.this$0.getProject());
            }
        };
    }

    static {
        Object[] objectArray = new String[]{"ImportError:", "AttributeError:", "ModuleNotFoundError:", "NameError:"};
        ERRORS_STRINGS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/run/PythonImportErrorFilter$Companion;", "", "()V", "ERRORS_STRINGS", "", "", "ERROR_IN_SITECUSTOMIZE_STRING", "FATAL_ERROR_STRING", "TRACEBACK_STRING", "TRIM_PATTERN", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/run/PythonImportErrorFilter$CreateImportExceptionResult;", "Lcom/intellij/execution/filters/Filter$Result;", "Lcom/intellij/execution/impl/InlayProvider;", "highlightStartOffset", "", "highlightEndOffset", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/jetbrains/python/run/PythonImportErrorFilter;IILcom/intellij/openapi/vfs/VirtualFile;)V", "createInlayRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.python.community.impl"})
    private final class CreateImportExceptionResult
    extends Filter.Result
    implements InlayProvider {
        @NotNull
        private final VirtualFile virtualFile;

        public CreateImportExceptionResult(int highlightStartOffset, @NotNull int highlightEndOffset, VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            super(highlightStartOffset, highlightEndOffset, null);
            this.virtualFile = virtualFile;
        }

        @NotNull
        public EditorCustomElementRenderer createInlayRenderer(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            PresentationFactory factory = new PresentationFactory((Editor)((EditorImpl)editor2));
            Object[] objectArray = new Object[]{this.virtualFile.getName()};
            String string = PyBundle.message("run.debug.shadowing.name.import.error.title", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String inlayText = string;
            InlayPresentation presentation = factory.referenceOnHover(factory.roundWithBackground((InlayPresentation)factory.withReferenceAttributes(factory.text(inlayText))), (arg_0, arg_1) -> CreateImportExceptionResult.createInlayRenderer$lambda$0(PythonImportErrorFilter.this, this, arg_0, arg_1));
            return (EditorCustomElementRenderer)new PresentationRenderer(presentation);
        }

        private static final void createInlayRenderer$lambda$0(PythonImportErrorFilter this$0, CreateImportExceptionResult this$1, MouseEvent event, Point point) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
            if (event == null) {
                return;
            }
            Object[] objectArray = new AnAction[]{this$0.createOpenFileAction(this$1.virtualFile), this$0.createRenameAction(this$1.virtualFile)};
            List actions = CollectionsKt.listOf((Object[])objectArray);
            JBPopupMenu.showByEvent((MouseEvent)event, (String)"InlayMenu", (ActionGroup)((ActionGroup)new DefaultActionGroup(actions)));
        }
    }
}

