/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run.runAnything;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.EnvironmentUtil;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\r*\u00020\u0015H\u0000\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00062\u0006\u0010\u0000\u001a\u00020\u0001H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/actionSystem/DataContext;", "getProject", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/vfs/VirtualFile;", "createPythonConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "dataContext", "pattern", "", "configurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "isProjectOrModuleContext", "", "findExecutableInPath", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "findPythonSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.python.community.impl"})
public final class PyRunAnythingUtilKt {
    @NotNull
    public static final Project getProject(@NotNull DataContext $this$project) {
        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"<this>");
        Project project = RunAnythingUtil.fetchProject((DataContext)$this$project);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"fetchProject(...)");
        return project;
    }

    @Nullable
    public static final VirtualFile getVirtualFile(@NotNull DataContext $this$virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$virtualFile, (String)"<this>");
        return (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData($this$virtualFile);
    }

    @Nullable
    public static final Sdk findPythonSdk(@NotNull VirtualFile $this$findPythonSdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$findPythonSdk, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Module module = ModuleUtil.findModuleForFile((VirtualFile)$this$findPythonSdk, (Project)project);
        return PythonSdkUtil.findPythonSdk(module);
    }

    @Nullable
    public static final String findExecutableInPath(@NotNull GeneralCommandLine $this$findExecutableInPath) {
        Intrinsics.checkNotNullParameter((Object)$this$findExecutableInPath, (String)"<this>");
        String string = $this$findExecutableInPath.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
        String executable = string;
        if (StringsKt.contains$default((CharSequence)executable, (CharSequence)"/", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)executable, (CharSequence)"\\", (boolean)false, (int)2, null)) {
            return executable;
        }
        Object[] objectArray = new String[]{$this$findExecutableInPath.getEffectiveEnvironment().get("PATH"), System.getenv("PATH"), EnvironmentUtil.getValue((String)"PATH")};
        List paths = CollectionsKt.listOfNotNull((Object[])objectArray);
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)paths), (Function1)((Function1)new Function1<String, String>(executable){
            final /* synthetic */ String $executable;
            {
                this.$executable = $executable;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final String invoke(@NotNull String path2) {
                String string;
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                if (SystemInfo.isWindows) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    List list = PathEnvironmentVariableUtil.getWindowsExecutableFileExtensions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWindowsExecutableFileExtensions(...)");
                    Iterable iterable = list;
                    String string2 = this.$executable;
                    boolean $i$f$mapNotNull = false;
                    void var5_5 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String ext = (String)element$iv$iv;
                        boolean bl2 = false;
                        File file = PathEnvironmentVariableUtil.findInPath((String)(string2 + ext), (String)path2, null);
                        if ((file != null ? file.getPath() : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                } else {
                    File file = PathEnvironmentVariableUtil.findInPath((String)this.$executable, (String)path2, null);
                    string = file != null ? file.getPath() : null;
                }
                return string;
            }
        })));
    }

    @NotNull
    public static final RunnerAndConfigurationSettings createPythonConfiguration(@NotNull DataContext dataContext, @NotNull String pattern, @NotNull ConfigurationFactory configurationFactory) {
        PythonRunConfiguration configuration;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)configurationFactory, (String)"configurationFactory");
        RunManager runManager = RunManager.Companion.getInstance(PyRunAnythingUtilKt.getProject(dataContext));
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(pattern, configurationFactory);
        Object[] objectArray = ParametersList.parse((String)pattern);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"parse(...)");
        Object[] commandLine = objectArray;
        List arguments = ArraysKt.drop((Object[])commandLine, (int)1);
        Object object = settings.getConfiguration();
        PythonRunConfiguration pythonRunConfiguration = configuration = object instanceof PythonRunConfiguration ? (PythonRunConfiguration)object : null;
        if (pythonRunConfiguration != null) {
            Object $this$createPythonConfiguration_u24lambda_u244 = object = pythonRunConfiguration;
            boolean bl = false;
            String first = (String)CollectionsKt.getOrNull((List)arguments, (int)0);
            if (Intrinsics.areEqual((Object)first, (Object)"-m")) {
                ((PythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setScriptName((String)CollectionsKt.getOrNull((List)arguments, (int)1));
                ((PythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setScriptParameters(ParametersList.join((List)CollectionsKt.drop((Iterable)arguments, (int)2)));
                ((PythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setModuleMode(true);
            } else {
                String string = first;
                boolean bl2 = string != null ? StringsKt.startsWith$default((String)string, (String)"-m", (boolean)false, (int)2, null) : false;
                if (bl2) {
                    String string2 = first.substring(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    ((PythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setScriptName(string2);
                    ((PythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setScriptParameters(ParametersList.join((List)CollectionsKt.drop((Iterable)arguments, (int)1)));
                    ((PythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setModuleMode(true);
                } else {
                    ((PythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setScriptName(first);
                    ((PythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setScriptParameters(ParametersList.join((List)CollectionsKt.drop((Iterable)arguments, (int)1)));
                }
            }
            VirtualFile workingDir = null;
            workingDir = PyRunAnythingUtilKt.getVirtualFile(dataContext);
            RunAnythingContext executingContext = (RunAnythingContext)dataContext.getData(RunAnythingProviderBase.EXECUTING_CONTEXT);
            if (executingContext instanceof RunAnythingContext.ProjectContext ? true : executingContext instanceof RunAnythingContext.ModuleContext) {
                String it;
                String string;
                String string3 = string = ((PythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).getScriptName();
                if (string3 != null) {
                    Intrinsics.checkNotNull((Object)string3);
                    it = string;
                    boolean bl3 = false;
                    Collection collection = FilenameIndex.getVirtualFilesByName((String)it, (GlobalSearchScope)PyRunAnythingUtilKt.getSearchScope(dataContext));
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
                    VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((Iterable)collection);
                    if (virtualFile != null) {
                        VirtualFile it2 = virtualFile;
                        boolean bl4 = false;
                        workingDir = it2.getParent();
                    }
                }
                VirtualFile virtualFile = workingDir;
                if (virtualFile != null) {
                    it = virtualFile;
                    boolean bl5 = false;
                    ((AbstractPythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setWorkingDirectory(it.getCanonicalPath());
                }
            } else if (executingContext instanceof RunAnythingContext.RecentDirectoryContext) {
                ((AbstractPythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setWorkingDirectory(((RunAnythingContext.RecentDirectoryContext)executingContext).getPath());
            }
            VirtualFile virtualFile = workingDir;
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl6 = false;
                $this$createPythonConfiguration_u24lambda_u244.setModule(ModuleUtil.findModuleForFile((VirtualFile)it, (Project)$this$createPythonConfiguration_u24lambda_u244.getProject()));
                ((AbstractPythonRunConfiguration)$this$createPythonConfiguration_u24lambda_u244).setUseModuleSdk(true);
            }
        }
        settings.setTemporary(true);
        return settings;
    }

    public static final boolean isProjectOrModuleContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        RunAnythingContext executingContext = (RunAnythingContext)dataContext.getData(RunAnythingProviderBase.EXECUTING_CONTEXT);
        return executingContext instanceof RunAnythingContext.ProjectContext || executingContext instanceof RunAnythingContext.ModuleContext;
    }

    @NotNull
    public static final GlobalSearchScope getSearchScope(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        RunAnythingContext executingContext = (RunAnythingContext)dataContext.getData(RunAnythingProviderBase.EXECUTING_CONTEXT);
        if (executingContext instanceof RunAnythingContext.ProjectContext) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)((RunAnythingContext.ProjectContext)executingContext).getProject());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            return globalSearchScope;
        }
        if (executingContext instanceof RunAnythingContext.ModuleContext) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)((RunAnythingContext.ModuleContext)executingContext).getModule());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleScope(...)");
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)PyRunAnythingUtilKt.getProject(dataContext));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return globalSearchScope;
    }
}

