/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.jetbrains.python.sdk.Resource;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u001a\u0010\u0019\u001a\u00020\u00152\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/sdk/Binary;", "", "os", "Lcom/intellij/util/system/OS;", "cpuArch", "Lcom/intellij/util/system/CpuArch;", "resources", "", "Lcom/jetbrains/python/sdk/Resource;", "(Lcom/intellij/util/system/OS;Lcom/intellij/util/system/CpuArch;Ljava/util/List;)V", "getCpuArch", "()Lcom/intellij/util/system/CpuArch;", "getOs", "()Lcom/intellij/util/system/OS;", "getResources", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "isCompatible", "toString", "", "intellij.python.sdk"})
public final class Binary {
    @NotNull
    private final OS os;
    @Nullable
    private final CpuArch cpuArch;
    @NotNull
    private final List<Resource> resources;

    public Binary(@NotNull OS os, @Nullable CpuArch cpuArch, @NotNull List<Resource> resources) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.os = os;
        this.cpuArch = cpuArch;
        this.resources = resources;
    }

    @NotNull
    public final OS getOs() {
        return this.os;
    }

    @Nullable
    public final CpuArch getCpuArch() {
        return this.cpuArch;
    }

    @NotNull
    public final List<Resource> getResources() {
        return this.resources;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCompatible(@NotNull OS os, @NotNull CpuArch cpuArch) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)cpuArch, (String)"cpuArch");
        if (this.os != os) return false;
        CpuArch cpuArch2 = this.cpuArch;
        if (cpuArch2 == null) return true;
        boolean bl = cpuArch2.equals((Object)cpuArch);
        if (!bl) return false;
        return true;
    }

    public static /* synthetic */ boolean isCompatible$default(Binary binary, OS oS, CpuArch cpuArch, int n, Object object) {
        if ((n & 1) != 0) {
            OS oS2 = OS.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)oS2, (String)"CURRENT");
            oS = oS2;
        }
        if ((n & 2) != 0) {
            CpuArch cpuArch2 = CpuArch.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)cpuArch2, (String)"CURRENT");
            cpuArch = cpuArch2;
        }
        return binary.isCompatible(oS, cpuArch);
    }

    @NotNull
    public final OS component1() {
        return this.os;
    }

    @Nullable
    public final CpuArch component2() {
        return this.cpuArch;
    }

    @NotNull
    public final List<Resource> component3() {
        return this.resources;
    }

    @NotNull
    public final Binary copy(@NotNull OS os, @Nullable CpuArch cpuArch, @NotNull List<Resource> resources) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        return new Binary(os, cpuArch, resources);
    }

    public static /* synthetic */ Binary copy$default(Binary binary, OS oS, CpuArch cpuArch, List list, int n, Object object) {
        if ((n & 1) != 0) {
            oS = binary.os;
        }
        if ((n & 2) != 0) {
            cpuArch = binary.cpuArch;
        }
        if ((n & 4) != 0) {
            list = binary.resources;
        }
        return binary.copy(oS, cpuArch, list);
    }

    @NotNull
    public String toString() {
        return "Binary(os=" + this.os + ", cpuArch=" + this.cpuArch + ", resources=" + this.resources + ")";
    }

    public int hashCode() {
        int result2 = this.os.hashCode();
        result2 = result2 * 31 + (this.cpuArch == null ? 0 : this.cpuArch.hashCode());
        result2 = result2 * 31 + ((Object)this.resources).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Binary)) {
            return false;
        }
        Binary binary = (Binary)other;
        if (this.os != binary.os) {
            return false;
        }
        if (this.cpuArch != binary.cpuArch) {
            return false;
        }
        return Intrinsics.areEqual(this.resources, binary.resources);
    }
}

