/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.run.PyRunnerUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PyFlavorAndData;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.conda.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.conda.PyCondaEnv;
import com.jetbrains.python.sdk.flavors.conda.PyCondaEnvIdentity;
import com.jetbrains.python.sdk.flavors.conda.PyCondaFlavorData;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a/\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0015\b\u0002\u0010\u0006\u001a\u000f\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\u0002\b\tH\u0001\u00a8\u0006\n"}, d2={"fixPythonCondaSdk", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "additionalData", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "suggestedCondaPath", "", "Lcom/intellij/execution/target/FullPathOnTarget;", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.python.community.impl"})
public final class PyCondaSdkFixKt {
    @JvmOverloads
    public static final void fixPythonCondaSdk(@NotNull Sdk sdk2, @NotNull SdkAdditionalData additionalData, @Nullable String suggestedCondaPath) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)additionalData, (String)"additionalData");
        if (!(additionalData instanceof PythonSdkAdditionalData)) {
            return;
        }
        if (PyRunnerUtil.isTargetBased(sdk2)) {
            return;
        }
        if (((PythonSdkAdditionalData)additionalData).getFlavor() instanceof CondaEnvSdkFlavor) {
            return;
        }
        String string = suggestedCondaPath;
        if (string == null && (string = PyCondaPackageService.Companion.getCondaExecutable(sdk2.getHomePath())) == null) {
            return;
        }
        String condaPath = string;
        Object object = PythonSdkUtil.findCondaMeta(sdk2.getHomePath());
        if (object == null || (object = object.getParent()) == null || (object = object.toNioPath()) == null || (object = object.toString()) == null) {
            return;
        }
        Object envPath = object;
        PyCondaEnv env = new PyCondaEnv(new PyCondaEnvIdentity.UnnamedEnv((String)envPath, StringsKt.startsWith$default((String)condaPath, (String)envPath, (boolean)false, (int)2, null)), condaPath);
        ((PythonSdkAdditionalData)additionalData).changeFlavorAndData(new PyFlavorAndData<PyFlavorData, PythonSdkFlavor>(new PyCondaFlavorData(env), CondaEnvSdkFlavor.getInstance()));
    }

    public static /* synthetic */ void fixPythonCondaSdk$default(Sdk sdk2, SdkAdditionalData sdkAdditionalData, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        PyCondaSdkFixKt.fixPythonCondaSdk(sdk2, sdkAdditionalData, string);
    }

    @JvmOverloads
    public static final void fixPythonCondaSdk(@NotNull Sdk sdk2, @NotNull SdkAdditionalData additionalData) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)additionalData, (String)"additionalData");
        PyCondaSdkFixKt.fixPythonCondaSdk$default(sdk2, additionalData, null, 4, null);
    }
}

