/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.google.common.io.Resources;
import com.intellij.openapi.util.Version;
import com.intellij.util.Url;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.Release;
import com.jetbrains.python.sdk.Sdks;
import com.jetbrains.python.sdk.SdksKeeper;
import com.jetbrains.python.sdk.SdksKt;
import com.jetbrains.python.sdk.UrlDeserializer;
import com.jetbrains.python.sdk.UrlSerializer;
import com.jetbrains.python.sdk.VersionDeserializer;
import com.jetbrains.python.sdk.VersionSerializer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/sdk/SdksKeeper;", "", "()V", "configUrl", "Ljava/net/URL;", "sdks", "Lcom/jetbrains/python/sdk/Sdks;", "getSdks", "()Lcom/jetbrains/python/sdk/Sdks;", "sdks$delegate", "Lkotlin/Lazy;", "deserialize", "content", "", "load", "pythonReleasesByLanguageLevel", "", "Lcom/jetbrains/python/psi/LanguageLevel;", "", "Lcom/jetbrains/python/sdk/Release;", "serialize", "intellij.python.sdk"})
@SourceDebugExtension(value={"SMAP\nSdks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sdks.kt\ncom/jetbrains/python/sdk/SdksKeeper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n766#2:184\n857#2,2:185\n1477#2:187\n1502#2,3:188\n1505#2,3:198\n372#3,7:191\n1#4:201\n*S KotlinDebug\n*F\n+ 1 Sdks.kt\ncom/jetbrains/python/sdk/SdksKeeper\n*L\n153#1:184\n153#1:185,2\n153#1:187\n153#1:188,3\n153#1:198,3\n153#1:191,7\n*E\n"})
public final class SdksKeeper {
    @NotNull
    public static final SdksKeeper INSTANCE = new SdksKeeper();
    @Nullable
    private static final URL configUrl = Sdks.class.getResource("/sdks.json");
    @NotNull
    private static final Lazy sdks$delegate = LazyKt.lazy((Function0)sdks.2.INSTANCE);

    private SdksKeeper() {
    }

    @NotNull
    public final Sdks getSdks() {
        Lazy lazy = sdks$delegate;
        return (Sdks)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<LanguageLevel, List<Release>> pythonReleasesByLanguageLevel() {
        void $this$groupByTo$iv$iv;
        Release it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getSdks().getPython();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Release)element$iv$iv;
            boolean bl = false;
            if (!(SdksKt.toLanguageLevel(it.getVersion()) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            LanguageLevel key$iv$iv;
            it = (Release)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)((Object)SdksKt.toLanguageLevel(it.getVersion())));
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final Sdks deserialize(String content2) {
        Object object;
        try {
            object = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new SimpleModule().addDeserializer(Version.class, (JsonDeserializer)new VersionDeserializer()).addDeserializer(Url.class, (JsonDeserializer)new UrlDeserializer())).readValue(content2, Sdks.class);
            Intrinsics.checkNotNull((Object)object);
            object = (Sdks)object;
        }
        catch (Exception ex) {
            SdksKt.access$getLOG$p().error("Json syntax error in the " + configUrl, (Throwable)ex);
            object = new Sdks(null, 1, null);
        }
        return object;
    }

    @NotNull
    public final String serialize(@NotNull Sdks sdks2) {
        Intrinsics.checkNotNullParameter((Object)sdks2, (String)"sdks");
        String string = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new SimpleModule().addSerializer(Version.class, (JsonSerializer)new VersionSerializer()).addSerializer(Url.class, (JsonSerializer)new UrlSerializer())).setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString((Object)sdks2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    private final String load() {
        String string;
        URL uRL = configUrl;
        if (uRL != null) {
            URL it = uRL;
            boolean bl = false;
            string = Resources.toString((URL)it, (Charset)StandardCharsets.UTF_8);
        } else {
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ Sdks access$deserialize(SdksKeeper $this, String content2) {
        return $this.deserialize(content2);
    }

    public static final /* synthetic */ String access$load(SdksKeeper $this) {
        return $this.load();
    }
}

