/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PushLogTreeUtil {
    @NonNls
    public static final String EDIT_MODE_PROP = "tree.edit.mode";

    @Nullable
    public static Object getTagAtForRenderer(CheckboxTree.CheckboxTreeCellRenderer renderer2, MouseEvent e) {
        JTree tree2 = (JTree)e.getSource();
        Object tag = null;
        TreePath path2 = tree2.getPathForLocation(e.getX(), e.getY());
        if (path2 != null) {
            Rectangle rectangle = tree2.getPathBounds(path2);
            assert (rectangle != null);
            int dx = e.getX() - rectangle.x;
            TreeNode treeNode = (TreeNode)path2.getLastPathComponent();
            int row2 = tree2.getRowForLocation(e.getX(), e.getY());
            tree2.getCellRenderer().getTreeCellRendererComponent(tree2, treeNode, false, false, true, row2, true);
            if (treeNode instanceof RepositoryNode) {
                RepositoryNode repositoryNode = (RepositoryNode)((Object)treeNode);
                int checkBoxWidth = repositoryNode.isCheckboxVisible() ? renderer2.getCheckbox().getWidth() : 0;
                tag = renderer2.getTextRenderer().getFragmentTagAt(dx - checkBoxWidth);
            } else {
                tag = renderer2.getTextRenderer().getFragmentTagAt(dx);
            }
        }
        return tag;
    }

    public static SimpleTextAttributes addTransparencyIfNeeded(@NotNull SimpleColoredComponent component2, @NotNull SimpleTextAttributes baseStyle, boolean isActive) {
        if (component2 == null) {
            PushLogTreeUtil.$$$reportNull$$$0(0);
        }
        if (baseStyle == null) {
            PushLogTreeUtil.$$$reportNull$$$0(1);
        }
        if (isActive) {
            return baseStyle;
        }
        Color color = (Color)ObjectUtils.chooseNotNull((Object)baseStyle.getFgColor(), (Object)component2.getForeground());
        return new SimpleTextAttributes(baseStyle.getStyle(), ColorUtil.toAlpha((Color)color, (int)85));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "baseStyle";
                break;
            }
        }
        objectArray[1] = "com/intellij/dvcs/push/ui/PushLogTreeUtil";
        objectArray[2] = "addTransparencyIfNeeded";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

