/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor.folding;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonFoldingBuilder
implements FoldingBuilder,
DumbAware {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document2) {
        if (node == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document2 == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        JsonFoldingBuilder.collectDescriptorsRecursively(node, document2, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY_ARRAY);
        if (foldingDescriptorArray == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    private static void collectDescriptorsRecursively(@NotNull ASTNode node, @NotNull Document document2, @NotNull List<FoldingDescriptor> descriptors) {
        IElementType type2;
        if (node == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (document2 == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (descriptors == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (((type2 = node.getElementType()) == JsonElementTypes.OBJECT || type2 == JsonElementTypes.ARRAY) && JsonFoldingBuilder.spanMultipleLines(node, document2)) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        } else if (type2 == JsonElementTypes.BLOCK_COMMENT) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        } else if (type2 == JsonElementTypes.LINE_COMMENT) {
            Couple<PsiElement> commentRange = JsonFoldingBuilder.expandLineCommentsRange(node.getPsi());
            int startOffset = ((PsiElement)commentRange.getFirst()).getTextRange().getStartOffset();
            int endOffset = ((PsiElement)commentRange.getSecond()).getTextRange().getEndOffset();
            if (document2.getLineNumber(startOffset) != document2.getLineNumber(endOffset)) {
                descriptors.add(new FoldingDescriptor(node, new TextRange(startOffset, endOffset)));
            }
        }
        for (ASTNode child : node.getChildren(null)) {
            JsonFoldingBuilder.collectDescriptorsRecursively(child, document2, descriptors);
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        IElementType type2;
        if (node == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(6);
        }
        if ((type2 = node.getElementType()) == JsonElementTypes.OBJECT) {
            JsonObject object = (JsonObject)node.getPsi(JsonObject.class);
            List<JsonProperty> properties2 = object.getPropertyList();
            JsonProperty candidate = null;
            for (JsonProperty property2 : properties2) {
                String name = property2.getName();
                JsonValue value2 = property2.getValue();
                if (!(value2 instanceof JsonLiteral)) continue;
                if ("id".equals(name) || "name".equals(name)) {
                    candidate = property2;
                    break;
                }
                if (candidate != null) continue;
                candidate = property2;
            }
            if (candidate != null) {
                return "{\"" + candidate.getName() + "\": " + candidate.getValue().getText() + "...}";
            }
            return "{...}";
        }
        if (type2 == JsonElementTypes.ARRAY) {
            return "[...]";
        }
        if (type2 == JsonElementTypes.LINE_COMMENT) {
            return "//...";
        }
        if (type2 == JsonElementTypes.BLOCK_COMMENT) {
            return "/*...*/";
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(7);
        }
        return false;
    }

    @NotNull
    public static Couple<PsiElement> expandLineCommentsRange(@NotNull PsiElement anchor) {
        if (anchor == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(8);
        }
        Couple couple = Couple.of((Object)JsonPsiUtil.findFurthestSiblingOfSameType(anchor, false), (Object)JsonPsiUtil.findFurthestSiblingOfSameType(anchor, true));
        if (couple == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(9);
        }
        return couple;
    }

    private static boolean spanMultipleLines(@NotNull ASTNode node, @NotNull Document document2) {
        if (node == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(10);
        }
        if (document2 == null) {
            JsonFoldingBuilder.$$$reportNull$$$0(11);
        }
        TextRange range = node.getTextRange();
        int endOffset = range.getEndOffset();
        return document2.getLineNumber(range.getStartOffset()) < (endOffset < document2.getTextLength() ? document2.getLineNumber(endOffset) : document2.getLineCount() - 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/editor/folding/JsonFoldingBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/editor/folding/JsonFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "expandLineCommentsRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptorsRecursively";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandLineCommentsRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "spanMultipleLines";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 9 -> new IllegalStateException(string2);
        };
    }
}

