/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.CommonBundle;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListAvailabilityListener;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewEx;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.Modifier;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.Scheduler;
import com.intellij.openapi.vcs.changes.UpdateRequestsQueue;
import com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsConfirmationDialog;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.actions.VcsStatisticsCollector;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDeltaListener;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcs.commit.LocalChangesCommitter;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandler;
import com.intellij.vcs.commit.SingleChangeListCommitter;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@State(name="ChangeListManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ChangeListManagerImpl
extends ChangeListManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ChangeListManagerImpl.class);
    @Topic.ProjectLevel
    public static final Topic<LocalChangeListsLoadedListener> LISTS_LOADED = new Topic(LocalChangeListsLoadedListener.class, Topic.BroadcastDirection.NONE);
    private final Project myProject;
    private final ChangelistConflictTracker myConflictTracker;
    private final Scheduler myScheduler;
    private final EventDispatcher<ChangeListListener> myListeners;
    private final DelayedNotificator myDelayedNotificator;
    private final Object myDataLock;
    private final UpdateRequestsQueue myUpdater;
    private final Modifier myModifier;
    private FileHolderComposite myComposite;
    private final ChangeListWorker myWorker;
    @Nullable
    private List<LocalChangeListImpl> myDisabledWorkerState;
    private boolean myInitialUpdate;
    private VcsException myUpdateException;
    private @NotNull List<Supplier<@Nullable JComponent>> myAdditionalInfo;
    private volatile boolean myShowLocalChangesInvalidated;
    @Nls
    private volatile String myFreezeName;
    @NotNull
    private final Set<String> myListsToBeDeletedSilently;
    @NotNull
    private final Set<String> myListsToBeDeleted;
    private boolean myEmptyListDeletionScheduled;
    private boolean myModalNotificationsBlocked;
    private final List<CommitExecutor> myRegisteredCommitExecutors;
    private static final IgnoredFileBean[] EMPTY_ARRAY = new IgnoredFileBean[0];

    public static ChangeListManagerImpl getInstanceImpl(@NotNull Project project2) {
        if (project2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(0);
        }
        return (ChangeListManagerImpl)ChangeListManagerImpl.getInstance(project2);
    }

    public ChangeListManagerImpl(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        if (project2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(1);
        }
        if (coroutineScope == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(2);
        }
        this.myListeners = EventDispatcher.create(ChangeListListener.class);
        this.myDataLock = new Object();
        this.myInitialUpdate = true;
        this.myAdditionalInfo = Collections.emptyList();
        this.myListsToBeDeletedSilently = new HashSet<String>();
        this.myListsToBeDeleted = new HashSet<String>();
        this.myRegisteredCommitExecutors = new ArrayList<CommitExecutor>();
        this.myProject = project2;
        this.myConflictTracker = new ChangelistConflictTracker(project2, this);
        this.myComposite = FileHolderComposite.create(project2);
        this.myScheduler = new Scheduler(coroutineScope);
        this.myDelayedNotificator = new DelayedNotificator(this.myProject, this, this.myScheduler);
        this.myWorker = new ChangeListWorker(this.myProject, this.myDelayedNotificator);
        this.myUpdater = new UpdateRequestsQueue(this.myProject, this.myScheduler, this::updateImmediately, this::hasNothingToUpdate);
        this.myModifier = new Modifier(this.myWorker, this.myDelayedNotificator);
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(ChangeListListener.TOPIC, (Object)((ChangeListListener)this.myListeners.getMulticaster()));
        this.myListeners.addListener((EventListener)new ChangeListAdapter(){

            @Override
            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
                LocalChangeList oldList = (LocalChangeList)oldDefaultList;
                if (automatic || oldDefaultList == null || oldDefaultList.equals(newDefaultList)) {
                    return;
                }
                ChangeListManagerImpl.this.scheduleAutomaticEmptyChangeListDeletion(oldList);
            }
        });
        VcsManagedFilesHolder.VCS_IGNORED_FILES_HOLDER_EP.addChangeListener((AreaInstance)this.myProject, () -> VcsDirtyScopeManager.getInstance(this.myProject).markEverythingDirty(), (Disposable)this);
        VcsEP.EP_NAME.addChangeListener(() -> {
            this.resetChangedFiles();
            VcsDirtyScopeManager.getInstance(this.myProject).markEverythingDirty();
        }, (Disposable)this);
        CommitModeManager.subscribeOnCommitModeChange((SimpleMessageBusConnection)busConnection, () -> this.updateChangeListAvailability());
        Registry.get((String)"vcs.disable.changelists").addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value2) {
                if (value2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                ChangeListManagerImpl.this.updateChangeListAvailability();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$2", "afterValueChanged"));
            }
        }, (Disposable)this);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            busConnection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

                public void projectClosing(@NotNull Project project2) {
                    if (project2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (project2 == ChangeListManagerImpl.this.myProject) {
                        ChangeListManagerImpl.this.waitEverythingDoneInTestMode();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$3", "projectClosing"));
                }
            });
        }
    }

    public void dispose() {
        this.myUpdater.stop();
    }

    @Override
    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(3);
        }
        this.scheduleAutomaticEmptyChangeListDeletion(list2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList oldList, boolean silently) {
        if (oldList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(4);
        }
        if (!silently && oldList.hasDefaultName()) {
            return;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Schedule empty changelist deletion: %s, silently = %s", oldList.getName(), silently));
            }
            if (silently) {
                this.myListsToBeDeletedSilently.add(oldList.getId());
            } else {
                this.myListsToBeDeleted.add(oldList.getId());
            }
            if (!this.myEmptyListDeletionScheduled) {
                this.myEmptyListDeletionScheduled = true;
                this.invokeAfterUpdate(true, this::deleteEmptyChangeLists);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private void deleteEmptyChangeLists() {
        List listsToBeDeleted;
        List listsToBeDeletedSilently;
        ApplicationManager.getApplication().assertIsDispatchThread();
        VcsConfiguration config = VcsConfiguration.getInstance(this.myProject);
        Function toDeleteMapping = id -> {
            LocalChangeList list2 = this.getChangeList((String)id);
            if (list2 == null || list2.isDefault() || list2.isReadOnly() || !list2.getChanges().isEmpty()) {
                return null;
            }
            return list2;
        };
        Object object = this.myDataLock;
        synchronized (object) {
            boolean askLater;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Empty changelist deletion, scheduled:\nsilently: %s\nasking: %s", this.myListsToBeDeletedSilently, this.myListsToBeDeleted));
            }
            this.myListsToBeDeleted.removeAll(this.myListsToBeDeletedSilently);
            listsToBeDeletedSilently = ContainerUtil.mapNotNull(this.myListsToBeDeletedSilently, (Function)toDeleteMapping);
            this.myListsToBeDeletedSilently.clear();
            boolean bl = askLater = this.myModalNotificationsBlocked && config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
            if (!askLater) {
                listsToBeDeleted = ContainerUtil.mapNotNull(this.myListsToBeDeleted, (Function)toDeleteMapping);
                this.myListsToBeDeleted.clear();
            } else {
                listsToBeDeleted = Collections.emptyList();
            }
            this.myEmptyListDeletionScheduled = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Empty changelist deletion, to be deleted:\nsilently: %s\nasking: %s", listsToBeDeletedSilently, listsToBeDeleted));
            }
        }
        if (config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY || config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION && ApplicationManager.getApplication().isUnitTestMode()) {
            listsToBeDeleted = Collections.emptyList();
        }
        ChangeListRemoveConfirmation.deleteEmptyInactiveLists(this.myProject, listsToBeDeletedSilently, (Function1<? super List<? extends LocalChangeList>, Boolean>)((Function1)toAsk -> true));
        ChangeListRemoveConfirmation.deleteEmptyInactiveLists(this.myProject, listsToBeDeleted, (Function1<? super List<? extends LocalChangeList>, Boolean>)((Function1)toAsk -> config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || ChangeListManagerImpl.showRemoveEmptyChangeListsProposal(this.myProject, config, toAsk)));
    }

    private static boolean showRemoveEmptyChangeListsProposal(@NotNull Project project2, final @NotNull VcsConfiguration config, @NotNull Collection<? extends ChangeList> lists) {
        if (project2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(5);
        }
        if (config == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(6);
        }
        if (lists == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(7);
        }
        if (lists.isEmpty()) {
            return false;
        }
        String changeListName = lists.size() == 1 ? StringUtil.first((String)lists.iterator().next().getName(), (int)30, (boolean)true) : StringUtil.join(lists, list2 -> StringUtil.first((String)list2.getName(), (int)30, (boolean)true), (String)"<br/>");
        String question = VcsBundle.message("changes.empty.changelists.no.longer.active", lists.size(), changeListName);
        VcsConfirmationDialog dialog = new VcsConfirmationDialog(project2, VcsBundle.message("dialog.title.remove.empty.changelist", new Object[0]), VcsBundle.message("button.remove", new Object[0]), CommonBundle.getCancelButtonText(), new VcsShowConfirmationOption(){

            @Override
            public VcsShowConfirmationOption.Value getValue() {
                return config.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
            }

            @Override
            public void setValue(VcsShowConfirmationOption.Value value2) {
                config.REMOVE_EMPTY_INACTIVE_CHANGELISTS = value2;
            }

            @Override
            public boolean isPersistent() {
                return true;
            }
        }, XmlStringUtil.wrapInHtml((CharSequence)question), VcsBundle.message("checkbox.remember.my.choice", new Object[0]));
        return dialog.showAndGet();
    }

    @Override
    @RequiresEdt
    public void blockModalNotifications() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myModalNotificationsBlocked = true;
    }

    @Override
    @RequiresEdt
    public void unblockModalNotifications() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myModalNotificationsBlocked = false;
        this.deleteEmptyChangeLists();
    }

    private void startUpdater() {
        this.myUpdater.initialized();
        ((LocalChangeListsLoadedListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, LISTS_LOADED)).processLoadedLists(this.getChangeLists());
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> VcsDirtyScopeManager.getInstance(this.myProject).markEverythingDirty());
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myConflictTracker.startTracking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void registerChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        if (filePath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(8);
        }
        if (tracker == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(9);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.registerChangeTracker(filePath, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void unregisterChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        if (filePath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(10);
        }
        if (tracker == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(11);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.unregisterChangeTracker(filePath, tracker);
        }
    }

    @Override
    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title2, @Nullable ModalityState state) {
        if (afterUpdate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(12);
        }
        if (mode == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(13);
        }
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title2);
    }

    @Override
    public void freeze(@NotNull String reason) {
        if (reason == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(14);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        this.myUpdater.setIgnoreBackgroundOperation(true);
        Semaphore sem = new Semaphore(1);
        this.invokeAfterUpdate(false, () -> {
            this.myUpdater.setIgnoreBackgroundOperation(false);
            this.myUpdater.pause();
            this.myFreezeName = reason;
            sem.up();
        });
        ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)sem, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
    }

    @Override
    public void unfreeze() {
        this.myUpdater.go();
        this.myFreezeName = null;
    }

    @Override
    public void waitForUpdate() {
        assert (!ApplicationManager.getApplication().isReadAccessAllowed());
        CountDownLatch waiter = new CountDownLatch(1);
        this.invokeAfterUpdate(false, waiter::countDown);
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)waiter);
    }

    @Override
    @NotNull
    public Promise<?> promiseWaitForUpdate() {
        AsyncPromise promise = new AsyncPromise();
        this.invokeAfterUpdate(false, () -> promise.setResult((Object)true));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(15);
        }
        return asyncPromise;
    }

    @Override
    public String isFreezed() {
        return this.myFreezeName;
    }

    public void executeOnUpdaterThread(@NotNull Runnable r) {
        if (r == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(16);
        }
        this.myScheduler.submit(r);
    }

    public void executeUnderDataLock(@NotNull Runnable r) {
        if (r == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                r.run();
            }
        });
    }

    @Override
    public void scheduleUpdate() {
        this.scheduleUpdateImpl();
    }

    @ApiStatus.Internal
    public void scheduleUpdateImpl() {
        this.myUpdater.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetChangedFiles() {
        try {
            Object object = this.myDataLock;
            synchronized (object) {
                DataHolder dataHolder = new DataHolder(this.myComposite.copy(), new ChangeListWorker.ChangeListUpdater(this.myWorker), true);
                dataHolder.notifyStart();
                dataHolder.notifyEnd();
                dataHolder.finish();
                this.myWorker.applyChangesFromUpdate(dataHolder.getUpdatedWorker(), new MyChangesDeltaForwarder(this.myProject, this.myScheduler));
                this.myComposite = dataHolder.getComposite();
                this.myUpdateException = null;
                this.myAdditionalInfo = Collections.emptyList();
            }
            this.myDelayedNotificator.changedFileStatusChanged(true);
            this.myDelayedNotificator.unchangedFileStatusChanged(true);
            this.myDelayedNotificator.changeListUpdateDone();
            ChangesViewManager.getInstanceEx(this.myProject).resetViewImmediatelyAndRefreshLater();
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    private boolean hasNothingToUpdate() {
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(this.myProject);
        if (!vcsManager2.hasActiveVcss()) {
            return true;
        }
        VcsDirtyScopeManagerImpl dirtyScopeManager = VcsDirtyScopeManagerImpl.getInstanceImpl(this.myProject);
        return !dirtyScopeManager.hasDirtyScopes();
    }

    private boolean updateImmediately() {
        return (Boolean)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, () -> {
            block19: {
                Boolean bl;
                ChangesViewEx changesView;
                List<VcsModifiableDirtyScope> scopes;
                boolean wasEverythingDirty;
                VcsInvalidated invalidated;
                VcsDirtyScopeManagerImpl dirtyScopeManager;
                block18: {
                    ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(this.myProject);
                    if (!vcsManager2.hasActiveVcss()) {
                        return true;
                    }
                    dirtyScopeManager = VcsDirtyScopeManagerImpl.getInstanceImpl(this.myProject);
                    invalidated = dirtyScopeManager.retrieveScopes();
                    if (ChangeListManagerImpl.checkScopeIsEmpty(invalidated)) {
                        LOG.debug("[update] - dirty scope is empty");
                        dirtyScopeManager.changesProcessed();
                        return true;
                    }
                    wasEverythingDirty = invalidated.isEverythingDirty();
                    scopes = invalidated.getScopes();
                    changesView = ChangesViewManager.getInstanceEx(this.myProject);
                    if (!this.myUpdater.isStopped()) break block18;
                    Boolean bl2 = true;
                    dirtyScopeManager.changesProcessed();
                    this.myDelayedNotificator.changedFileStatusChanged(!this.isInUpdate());
                    this.myDelayedNotificator.changeListUpdateDone();
                    changesView.scheduleRefresh();
                    return bl2;
                }
                try {
                    boolean isInitialUpdate;
                    DataHolder dataHolder;
                    Object object = this.myDataLock;
                    synchronized (object) {
                        dataHolder = new DataHolder(this.myComposite.copy(), new ChangeListWorker.ChangeListUpdater(this.myWorker), wasEverythingDirty);
                        this.myModifier.enterUpdate();
                        if (wasEverythingDirty) {
                            this.myUpdateException = null;
                            this.myAdditionalInfo = Collections.emptyList();
                        }
                        if (LOG.isDebugEnabled()) {
                            String scopeInString = StringUtil.join(scopes, Object::toString, (String)"->\n");
                            LOG.debug("refresh procedure started, everything: " + wasEverythingDirty + " dirty scope: " + scopeInString + "\nignored: " + this.myComposite.getIgnoredFileHolder().getFiles().size() + "\nunversioned: " + this.myComposite.getUnversionedFileHolder().getFiles().size() + "\ncurrent changes: " + this.myWorker);
                        }
                        isInitialUpdate = this.myInitialUpdate;
                        this.myInitialUpdate = false;
                    }
                    changesView.setBusy(true);
                    changesView.scheduleRefresh();
                    SensitiveProgressWrapper vcsIndicator = new SensitiveProgressWrapper(ProgressManager.getInstance().getProgressIndicator());
                    if (!isInitialUpdate) {
                        invalidated.doWhenCanceled(() -> vcsIndicator.cancel());
                    }
                    try {
                        ProgressManager.getInstance().executeProcessUnderProgress(() -> this.iterateScopes(dataHolder, scopes, (ProgressIndicator)vcsIndicator), (ProgressIndicator)vcsIndicator);
                    }
                    catch (ProcessCanceledException scopeInString) {
                        // empty catch block
                    }
                    boolean wasCancelled = vcsIndicator.isCanceled();
                    ApplicationManager.getApplication().runReadAction(() -> {
                        if (this.myProject.isDisposed()) {
                            return;
                        }
                        Object object = this.myDataLock;
                        synchronized (object) {
                            boolean takeChanges;
                            ChangeListWorker updatedWorker = dataHolder.getUpdatedWorker();
                            boolean bl = takeChanges = this.myUpdateException == null && !wasCancelled && updatedWorker.areChangeListsEnabled() == this.myWorker.areChangeListsEnabled();
                            if (takeChanges) {
                                dataHolder.finish();
                                this.myModifier.finishUpdate(updatedWorker);
                                this.myWorker.applyChangesFromUpdate(updatedWorker, new MyChangesDeltaForwarder(this.myProject, this.myScheduler));
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("refresh procedure finished, unversioned size: " + dataHolder.getComposite().getUnversionedFileHolder().getFiles().size() + "\nchanges: " + this.myWorker);
                                }
                                boolean statusChanged = !this.myComposite.equals(dataHolder.getComposite());
                                this.myComposite = dataHolder.getComposite();
                                if (statusChanged) {
                                    boolean isUnchangedUpdating = this.isInUpdate() || this.isUnversionedInUpdateMode() || this.isIgnoredInUpdateMode();
                                    this.myDelayedNotificator.unchangedFileStatusChanged(!isUnchangedUpdating);
                                }
                                LOG.debug("[update] - success");
                            } else {
                                this.myModifier.finishUpdate(null);
                                LOG.debug(String.format("[update] - aborted, wasCancelled: %s", wasCancelled));
                            }
                            this.myShowLocalChangesInvalidated = false;
                        }
                    });
                    for (VcsDirtyScope scope2 : scopes) {
                        if (!scope2.getVcs().isTrackingUnchangedContent()) continue;
                        VcsRootIterator.iterateExistingInsideScope(scope2, (Processor<? super VirtualFile>)((Processor)file -> {
                            LastUnchangedContentTracker.markUntouched(file);
                            return true;
                        }));
                    }
                    bl = !wasCancelled;
                    dirtyScopeManager.changesProcessed();
                    this.myDelayedNotificator.changedFileStatusChanged(!this.isInUpdate());
                    this.myDelayedNotificator.changeListUpdateDone();
                }
                catch (ProcessCanceledException dataHolder) {
                    dirtyScopeManager.changesProcessed();
                    this.myDelayedNotificator.changedFileStatusChanged(!this.isInUpdate());
                    this.myDelayedNotificator.changeListUpdateDone();
                    changesView.scheduleRefresh();
                    break block19;
                }
                catch (AssertionError | Exception ex) {
                    LOG.error((Throwable)ex);
                    dirtyScopeManager.changesProcessed();
                    this.myDelayedNotificator.changedFileStatusChanged(!this.isInUpdate());
                    this.myDelayedNotificator.changeListUpdateDone();
                    {
                        catch (Throwable throwable) {
                            dirtyScopeManager.changesProcessed();
                            this.myDelayedNotificator.changedFileStatusChanged(!this.isInUpdate());
                            this.myDelayedNotificator.changeListUpdateDone();
                            changesView.scheduleRefresh();
                            throw throwable;
                        }
                    }
                    changesView.scheduleRefresh();
                }
                changesView.scheduleRefresh();
                return bl;
            }
            return true;
        });
    }

    private static boolean checkScopeIsEmpty(VcsInvalidated invalidated) {
        if (invalidated == null) {
            return true;
        }
        if (invalidated.isEverythingDirty()) {
            return false;
        }
        return invalidated.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void iterateScopes(@NotNull DataHolder dataHolder, @NotNull List<? extends VcsModifiableDirtyScope> scopes, @NotNull ProgressIndicator indicator) {
        if (scopes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(19);
        }
        if (dataHolder == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(20);
        }
        ChangeListWorker.ChangeListUpdater updater2 = dataHolder.getChangeListUpdater();
        FileHolderComposite composite = dataHolder.getComposite();
        Supplier<Boolean> disposedGetter = () -> this.myProject.isDisposed() || this.myUpdater.isStopped();
        ArrayList<Supplier<@Nullable JComponent>> additionalInfos = new ArrayList<Supplier<JComponent>>();
        dataHolder.notifyStart();
        try {
            for (VcsModifiableDirtyScope vcsModifiableDirtyScope : scopes) {
                indicator.checkCanceled();
                UpdatingChangeListBuilder builder2 = new UpdatingChangeListBuilder(vcsModifiableDirtyScope, updater2, composite, disposedGetter);
                this.actualUpdate(builder2, vcsModifiableDirtyScope, dataHolder, updater2, indicator);
                additionalInfos.addAll(builder2.getAdditionalInfo());
                Object object = this.myDataLock;
                synchronized (object) {
                    if (this.myUpdateException != null) {
                        break;
                    }
                }
            }
        }
        finally {
            dataHolder.notifyEnd();
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myAdditionalInfo = additionalInfos;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualUpdate(@NotNull UpdatingChangeListBuilder builder2, @NotNull VcsModifiableDirtyScope scope2, @NotNull DataHolder dataHolder, @NotNull ChangeListManagerGate gate, @NotNull ProgressIndicator indicator) {
        if (builder2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(21);
        }
        if (scope2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(22);
        }
        if (gate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(23);
        }
        if (indicator == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(24);
        }
        if (dataHolder == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(25);
        }
        dataHolder.notifyStartProcessingChanges(scope2);
        try {
            AbstractVcs vcs = scope2.getVcs();
            ChangeProvider changeProvider = vcs.getChangeProvider();
            if (changeProvider != null) {
                StructuredIdeActivity activity2 = VcsStatisticsCollector.logClmRefresh(this.myProject, vcs, scope2.wasEveryThingDirty());
                changeProvider.getChanges(scope2, builder2, indicator, gate);
                activity2.finished();
            }
        }
        catch (VcsException e) {
            this.handleUpdateException(e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.debug(t);
            ExceptionUtil.rethrow((Throwable)t);
        }
        finally {
            if (!this.myUpdater.isStopped()) {
                dataHolder.notifyDoneProcessingChanges(scope2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateException(VcsException e) {
        LOG.info((Throwable)e);
        if (e instanceof VcsConnectionProblem) {
            ApplicationManager.getApplication().invokeLater(() -> ((VcsConnectionProblem)e).attemptQuickFix(false));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance(this.myProject);
            if (helper instanceof AbstractVcsHelperImpl && ((AbstractVcsHelperImpl)helper).handleCustom(e)) {
                return;
            }
            e.printStackTrace();
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateException = e;
        }
    }

    public static boolean isUnder(@NotNull Change change, @NotNull VcsDirtyScope scope2) {
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(26);
        }
        if (scope2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(27);
        }
        ContentRevision before2 = change.getBeforeRevision();
        ContentRevision after = change.getAfterRevision();
        return before2 != null && scope2.belongsTo(before2.getFile()) || after != null && scope2.belongsTo(after.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<LocalChangeList> getChangeLists() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list2 = this.myWorker.getChangeLists();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(28);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<File> getAffectedPaths() {
        List<FilePath> filePaths;
        Object object = this.myDataLock;
        synchronized (object) {
            filePaths = this.myWorker.getAffectedPaths();
        }
        List list2 = ContainerUtil.mapNotNull(filePaths, FilePath::getIOFile);
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(29);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        List<FilePath> filePaths;
        Object object = this.myDataLock;
        synchronized (object) {
            filePaths = this.myWorker.getAffectedPaths();
        }
        List list2 = ContainerUtil.mapNotNull(filePaths, FilePath::getVirtualFile);
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(30);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<Change> getAllChanges() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<Change> collection = this.myWorker.getAllChanges();
        // MONITOREXIT : object
        if (collection != null) return collection;
        ChangeListManagerImpl.$$$reportNull$$$0(31);
        return collection;
    }

    public boolean isUnversionedInUpdateMode() {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getUnversionedFileHolder().isInUpdatingMode();
            }
        });
    }

    @Deprecated
    @NotNull
    public List<VirtualFile> getUnversionedFiles() {
        List list2 = ContainerUtil.mapNotNull(this.getUnversionedFilesPaths(), FilePath::getVirtualFile);
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(32);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FilePath> getUnversionedFilesPaths() {
        List list2 = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new ArrayList<FilePath>(this.myComposite.getUnversionedFileHolder().getFiles());
            }
        });
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(33);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<VirtualFile> getModifiedWithoutEditing() {
        List list2 = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getModifiedWithoutEditingFileHolder().getFiles();
            }
        });
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(34);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FilePath> getIgnoredFilePaths() {
        List list2 = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new ArrayList<FilePath>(this.myComposite.getIgnoredFileHolder().getFiles());
            }
        });
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(35);
        }
        return list2;
    }

    public boolean isIgnoredInUpdateMode() {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getIgnoredFileHolder().isInUpdatingMode();
            }
        });
    }

    public List<VirtualFile> getLockedFolders() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getLockedFileHolder().getFiles();
            }
        });
    }

    public Map<VirtualFile, LogicalLock> getLogicallyLockedFolders() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new HashMap<VirtualFile, LogicalLock>(this.myComposite.getLogicallyLockedFileHolder().getMap());
            }
        });
    }

    public boolean isLogicallyLocked(VirtualFile file) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getLogicallyLockedFileHolder().containsKey(file);
            }
        });
    }

    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().isContainedInLocallyDeleted(filePath);
            }
        });
    }

    public List<LocallyDeletedChange> getDeletedFiles() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().getFiles();
            }
        });
    }

    public MultiMap<String, VirtualFile> getSwitchedFilesMap() {
        return (MultiMap)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchToFileMap();
            }
        });
    }

    @Nullable
    public Map<VirtualFile, String> getSwitchedRoots() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getRootSwitchFileHolder().getFilesMapCopy();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsException getUpdateException() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myUpdateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public @NotNull List<Supplier<@Nullable JComponent>> getAdditionalUpdateInfo() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        ArrayList<Supplier<JComponent>> updateInfo = new ArrayList<Supplier<JComponent>>();
        if (this.myUpdateException != null) {
            String errorMessage = VcsBundle.message("error.updating.changes", this.myUpdateException.getMessage());
            updateInfo.add((Supplier<JComponent>)ChangesViewManager.createTextStatusFactory(errorMessage, true));
        }
        updateInfo.addAll(this.myAdditionalInfo);
        ArrayList<Supplier<JComponent>> arrayList = updateInfo;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        ChangeListManagerImpl.$$$reportNull$$$0(36);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFileAffected(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(37);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getStatus(file) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LocalChangeList findChangeList(String name) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LocalChangeList getChangeList(@Nullable String id) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListById(id);
        }
    }

    private void scheduleChangesViewRefresh() {
        if (!this.myProject.isDisposed()) {
            ChangesViewManager.getInstance(this.myProject).scheduleRefresh();
        }
    }

    @Override
    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(38);
        }
        LocalChangeList localChangeList = this.addChangeList(name, comment, null);
        if (localChangeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(39);
        }
        return localChangeList;
    }

    @Override
    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data2) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(40);
        }
        LocalChangeList localChangeList = (LocalChangeList)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                LocalChangeList changeList = this.myModifier.addChangeList(name, comment, data2);
                this.scheduleChangesViewRefresh();
                return changeList;
            }
        });
        if (localChangeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(41);
        }
        return localChangeList;
    }

    @Override
    public void removeChangeList(@NotNull String name) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(42);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.removeChangeList(name);
                this.scheduleChangesViewRefresh();
            }
        });
    }

    @Override
    public void removeChangeList(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(43);
        }
        this.removeChangeList(list2.getName());
    }

    public void setDefaultChangeList(@NotNull String name, boolean automatic) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(44);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.setDefault(name, automatic);
                this.scheduleChangesViewRefresh();
            }
        });
    }

    @Override
    public void setDefaultChangeList(@NotNull String name) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(45);
        }
        this.setDefaultChangeList(name, false);
    }

    @Override
    public void setDefaultChangeList(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(46);
        }
        this.setDefaultChangeList(list2, false);
    }

    @Override
    public void setDefaultChangeList(@NotNull LocalChangeList list2, boolean automatic) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(47);
        }
        this.setDefaultChangeList(list2.getName(), automatic);
    }

    @Override
    public boolean setReadOnly(@NotNull String name, boolean value2) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(48);
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.setReadOnly(name, value2);
                this.scheduleChangesViewRefresh();
                return result2;
            }
        });
    }

    @Override
    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(49);
        }
        if (toName == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(50);
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editName(fromName, toName);
                this.scheduleChangesViewRefresh();
                return result2;
            }
        });
    }

    @Override
    public String editComment(@NotNull String name, String newComment) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(51);
        }
        return (String)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                String oldComment = this.myModifier.editComment(name, StringUtil.notNullize((String)newComment));
                this.scheduleChangesViewRefresh();
                return oldComment;
            }
        });
    }

    @Override
    public boolean editChangeListData(@NotNull String name, @Nullable ChangeListData newData) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(52);
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editData(name, newData);
                this.scheduleChangesViewRefresh();
                return result2;
            }
        });
    }

    @Override
    public void moveChangesTo(@NotNull LocalChangeList list2, Change ... changes) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(53);
        }
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(54);
        }
        this.moveChangesTo(list2, ContainerUtil.skipNulls(Arrays.asList(changes)));
    }

    @Override
    public void moveChangesTo(@NotNull LocalChangeList list2, @NotNull @NotNull List<@NotNull Change> changes) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(55);
        }
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(56);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.moveChangesTo(list2.getName(), changes);
                this.scheduleChangesViewRefresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public LocalChangeList getDefaultChangeList() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        LocalChangeList localChangeList = this.myWorker.getDefaultList();
        // MONITOREXIT : object
        if (localChangeList != null) return localChangeList;
        ChangeListManagerImpl.$$$reportNull$$$0(57);
        return localChangeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getDefaultListName() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        String string2 = this.myWorker.getDefaultList().getName();
        // MONITOREXIT : object
        if (string2 != null) return string2;
        ChangeListManagerImpl.$$$reportNull$$$0(58);
        return string2;
    }

    @ApiStatus.Internal
    public void notifyChangelistsChanged(@NotNull FilePath path2, @NotNull List<String> beforeChangeListsIds, @NotNull List<String> afterChangeListsIds) {
        if (path2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(59);
        }
        if (beforeChangeListsIds == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(60);
        }
        if (afterChangeListsIds == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(61);
        }
        this.myWorker.notifyChangelistsChanged(path2, beforeChangeListsIds, afterChangeListsIds);
    }

    public void notifyUnchangedFileStatusChanged() {
        boolean isUnchangedUpdating = this.isInUpdate() || this.isUnversionedInUpdateMode() || this.isIgnoredInUpdateMode();
        this.myDelayedNotificator.unchangedFileStatusChanged(!isUnchangedUpdating);
        this.myDelayedNotificator.changeListUpdateDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChangeListNameIfOnlyOne(Change[] changes) {
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getAffectedLists(Arrays.asList(changes));
            return lists.size() == 1 ? lists.get(0).getName() : null;
        }
    }

    @Override
    public boolean isInUpdate() {
        return this.myModifier.isInsideUpdate() || this.myShowLocalChangesInvalidated;
    }

    @Override
    @Nullable
    public Change getChange(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(62);
        }
        return this.getChange(VcsUtil.getFilePath(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getAffectedLists(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(63);
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list2 = this.myWorker.getAffectedLists(changes);
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(64);
        return list2;
    }

    @Override
    @NotNull
    public List<LocalChangeList> getChangeLists(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(65);
        }
        Collection collection = this.getAffectedLists(Collections.singletonList(change));
        if (collection == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(66);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<LocalChangeList> getChangeLists(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(67);
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        Change change = this.myWorker.getChangeForPath(VcsUtil.getFilePath(file));
        if (change == null) {
            List<LocalChangeList> list2 = Collections.emptyList();
            // MONITOREXIT : object
            if (list2 != null) return list2;
            ChangeListManagerImpl.$$$reportNull$$$0(68);
            return list2;
        }
        List<LocalChangeList> list3 = this.getChangeLists(change);
        // MONITOREXIT : object
        if (list3 != null) return list3;
        ChangeListManagerImpl.$$$reportNull$$$0(69);
        return list3;
    }

    @Override
    @Nullable
    public LocalChangeList getChangeList(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(70);
        }
        return (LocalChangeList)ContainerUtil.getFirstItem(this.getChangeLists(change));
    }

    @Override
    @Nullable
    public LocalChangeList getChangeList(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(71);
        }
        return (LocalChangeList)ContainerUtil.getFirstItem(this.getChangeLists(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Change getChange(FilePath file) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeForPath(file);
        }
    }

    @Override
    public boolean isUnversioned(@NotNull VirtualFile file) {
        VcsRoot vcsRoot;
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(72);
        }
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-322445, EA-857508");){
            vcsRoot = ProjectLevelVcsManager.getInstance(this.myProject).getVcsRootObjectFor(file);
            if (vcsRoot == null) {
                boolean bl = false;
                return bl;
            }
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getUnversionedFileHolder().containsFile(VcsUtil.getFilePath(file), vcsRoot);
            }
        });
    }

    @Override
    @NotNull
    public FileStatus getStatus(@NotNull FilePath path2) {
        if (path2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(73);
        }
        return this.getStatus(path2, path2.getVirtualFile());
    }

    @Override
    @NotNull
    public FileStatus getStatus(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(74);
        }
        return this.getStatus(VcsUtil.getFilePath(file), file);
    }

    @NotNull
    private FileStatus getStatus(@NotNull FilePath path2, @Nullable VirtualFile file) {
        VcsRoot vcsRoot;
        if (path2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(75);
        }
        VcsRoot vcsRoot2 = vcsRoot = file != null ? ProjectLevelVcsManager.getInstance(this.myProject).getVcsRootObjectFor(file) : ProjectLevelVcsManager.getInstance(this.myProject).getVcsRootObjectFor(path2);
        if (vcsRoot == null) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            if (fileStatus == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(76);
            }
            return fileStatus;
        }
        FileStatus fileStatus = (FileStatus)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean switched;
                if (this.myComposite.getUnversionedFileHolder().containsFile(path2, vcsRoot)) {
                    return FileStatus.UNKNOWN;
                }
                if (file != null && this.myComposite.getModifiedWithoutEditingFileHolder().containsFile(file)) {
                    return FileStatus.HIJACKED;
                }
                if (this.myComposite.getIgnoredFileHolder().containsFile(path2, vcsRoot)) {
                    return FileStatus.IGNORED;
                }
                FileStatus status = (FileStatus)ObjectUtils.notNull((Object)this.myWorker.getStatus(path2), (Object)FileStatus.NOT_CHANGED);
                if (file != null && FileStatus.NOT_CHANGED.equals(status) && (switched = this.myComposite.getSwitchedFileHolder().containsFile(file))) {
                    return FileStatus.SWITCHED;
                }
                return status;
            }
        });
        if (fileStatus == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(77);
        }
        return fileStatus;
    }

    @Override
    @NotNull
    public Collection<Change> getChangesIn(@NotNull VirtualFile dir) {
        if (dir == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(78);
        }
        Collection<Change> collection = this.getChangesIn(VcsUtil.getFilePath(dir));
        if (collection == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(79);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ThreeState haveChangesUnder(@NotNull VirtualFile vf) {
        if (vf == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(80);
        }
        if (vf.isValid() && vf.isDirectory()) {
            Object object = this.myDataLock;
            // MONITORENTER : object
            ThreeState threeState = this.myWorker.haveChangesUnder(vf);
            // MONITOREXIT : object
            if (threeState != null) return threeState;
            ChangeListManagerImpl.$$$reportNull$$$0(82);
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState != null) return threeState;
        ChangeListManagerImpl.$$$reportNull$$$0(81);
        return threeState;
    }

    @Override
    @NotNull
    public Collection<Change> getChangesIn(@NotNull FilePath dirPath) {
        if (dirPath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(83);
        }
        Collection collection = this.getAllChanges().stream().filter(change -> ChangeListManagerImpl.isChangeUnder(dirPath, change)).collect(Collectors.toSet());
        if (collection == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(84);
        }
        return collection;
    }

    private static boolean isChangeUnder(@NotNull FilePath parent, @NotNull Change change) {
        if (parent == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(85);
        }
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(86);
        }
        FilePath after = ChangesUtil.getAfterPath(change);
        FilePath before2 = ChangesUtil.getBeforePath(change);
        return after != null && after.isUnder(parent, false) || !Comparing.equal((Object)before2, (Object)after) && before2 != null && before2.isUnder(parent, false);
    }

    @Override
    public void addUnversionedFiles(@Nullable LocalChangeList list2, @NotNull List<? extends VirtualFile> files2) {
        if (files2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(87);
        }
        ScheduleForAdditionAction.Manager.addUnversionedFilesToVcs(this.myProject, list2, files2);
    }

    @Override
    public void addChangeListListener(@NotNull ChangeListListener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(88);
        }
        if (disposable == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(89);
        }
        this.myListeners.addListener((EventListener)listener2, disposable);
    }

    @Override
    public void addChangeListListener(@NotNull ChangeListListener listener2) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(90);
        }
        this.myListeners.addListener((EventListener)listener2);
    }

    @Override
    public void removeChangeListListener(@NotNull ChangeListListener listener2) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(91);
        }
        this.myListeners.removeListener((EventListener)listener2);
    }

    @Override
    public void registerCommitExecutor(@NotNull CommitExecutor executor) {
        if (executor == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(92);
        }
        this.myRegisteredCommitExecutors.add(executor);
    }

    @Override
    public void commitChanges(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> changes) {
        if (changeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(93);
        }
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(94);
        }
        this.doCommit(changeList, changes, false);
    }

    private void doCommit(LocalChangeList changeList, List<? extends Change> changes, boolean synchronously) {
        FileDocumentManager.getInstance().saveAllDocuments();
        String commitMessage = StringUtil.isEmpty((String)changeList.getComment()) ? changeList.getName() : changeList.getComment();
        ChangeListCommitState commitState = new ChangeListCommitState(changeList, changes, commitMessage);
        LocalChangesCommitter committer = SingleChangeListCommitter.create(this.myProject, commitState, new CommitContext(), changeList.getName());
        committer.addResultHandler(new ShowNotificationCommitResultHandler(committer));
        committer.runCommit(changeList.getName(), synchronously);
    }

    @TestOnly
    public void commitChangesSynchronouslyWithResult(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> changes) {
        if (changeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(95);
        }
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(96);
        }
        this.doCommit(changeList, changes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        if (element == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(97);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (!this.myInitialUpdate) {
                LOG.warn("Local changes overwritten");
                VcsDirtyScopeManager.getInstance(this.myProject).markEverythingDirty();
            }
            boolean areChangeListsEnabled = this.shouldEnableChangeLists();
            this.myWorker.setChangeListsEnabled(areChangeListsEnabled);
            List<LocalChangeListImpl> changeLists = ChangeListManagerSerialization.readExternal(element, this.myProject);
            if (areChangeListsEnabled) {
                this.myWorker.setChangeLists(changeLists);
            } else {
                this.myDisabledWorkerState = changeLists;
            }
        }
        this.myConflictTracker.loadState(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Element getState() {
        Element element = new Element("state");
        Object object = this.myDataLock;
        synchronized (object) {
            boolean areChangeListsEnabled = this.myWorker.areChangeListsEnabled();
            List<LocalChangeList> changesToSave = areChangeListsEnabled ? this.myWorker.getChangeLists() : this.myDisabledWorkerState;
            ChangeListManagerSerialization.writeExternal(element, changesToSave, areChangeListsEnabled);
        }
        this.myConflictTracker.saveState(element);
        Element element2 = element;
        if (element2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(98);
        }
        return element2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reopenFiles(@NotNull List<? extends FilePath> paths) {
        if (paths == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(99);
        }
        ReadonlyStatusHandlerImpl readonlyStatusHandler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
        boolean savedOption = readonlyStatusHandler.getState().SHOW_DIALOG;
        readonlyStatusHandler.getState().SHOW_DIALOG = false;
        try {
            readonlyStatusHandler.ensureFilesWritable((Collection)ContainerUtil.mapNotNull(paths, FilePath::getVirtualFile));
        }
        finally {
            readonlyStatusHandler.getState().SHOW_DIALOG = savedOption;
        }
    }

    @Override
    @NotNull
    public List<CommitExecutor> getRegisteredExecutors() {
        List<CommitExecutor> list2 = Collections.unmodifiableList(this.myRegisteredCommitExecutors);
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(100);
        }
        return list2;
    }

    @Override
    public void addDirectoryToIgnoreImplicitly(@NotNull String path2) {
        if (path2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(101);
        }
    }

    @Override
    public void setFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        if (filesToIgnore == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(102);
        }
    }

    @Override
    public IgnoredFileBean @NotNull [] getFilesToIgnore() {
        if (EMPTY_ARRAY == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(103);
        }
        return EMPTY_ARRAY;
    }

    @Override
    public boolean isIgnoredFile(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(104);
        }
        return this.isIgnoredFile(VcsUtil.getFilePath(file));
    }

    @Override
    public boolean isIgnoredFile(@NotNull FilePath file) {
        VcsRoot vcsRoot;
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(105);
        }
        if ((vcsRoot = ProjectLevelVcsManager.getInstance(this.myProject).getVcsRootObjectFor(file)) == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getIgnoredFileHolder().containsFile(file, vcsRoot);
            }
        });
    }

    @Override
    @Nullable
    public String getSwitchedBranch(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(106);
        }
        return (String)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchForFile(file);
            }
        });
    }

    @TestOnly
    public void waitUntilRefreshed() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        VcsDirtyScopeVfsListener.getInstance(this.myProject).waitForAsyncTaskCompletion();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
    }

    @TestOnly
    private void waitUpdateAlarm() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.myScheduler.submit(() -> ((Semaphore)semaphore).up());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            while (!semaphore.waitFor(100L)) {
                UIUtil.dispatchAllInvocationEvents();
            }
        } else {
            semaphore.waitFor();
        }
    }

    @TestOnly
    public void stopEveryThingIfInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.cancelAll();
    }

    @TestOnly
    public void waitEverythingDoneAndStopInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.awaitAllAndStop();
        this.myUpdater.stop();
    }

    @TestOnly
    public void waitEverythingDoneInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.awaitAll();
    }

    @TestOnly
    public void forceStopInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.stop();
    }

    @TestOnly
    public void forceGoInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.forceGo();
    }

    @TestOnly
    public void ensureUpToDate() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.waitUntilRefreshed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private void updateChangeListAvailability() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        boolean enabled = this.shouldEnableChangeLists();
        Object object = this.myDataLock;
        synchronized (object) {
            if (enabled == this.myWorker.areChangeListsEnabled()) {
                return;
            }
        }
        ((ChangeListAvailabilityListener)this.myProject.getMessageBus().syncPublisher(ChangeListAvailabilityListener.TOPIC)).onBefore();
        object = this.myDataLock;
        synchronized (object) {
            assert (enabled != this.myWorker.areChangeListsEnabled());
            if (!enabled) {
                this.myDisabledWorkerState = this.myWorker.getChangeListsImpl();
            }
            this.myWorker.setChangeListsEnabled(enabled);
            if (enabled) {
                if (this.myDisabledWorkerState != null) {
                    this.myWorker.setChangeLists(this.myDisabledWorkerState);
                }
                VcsDirtyScopeManager.getInstance(this.myProject).markEverythingDirty();
                ChangesViewManager.getInstance(this.myProject).scheduleRefresh();
            }
        }
        ((ChangeListAvailabilityListener)this.myProject.getMessageBus().syncPublisher(ChangeListAvailabilityListener.TOPIC)).onAfter();
    }

    private boolean shouldEnableChangeLists() {
        boolean forceDisable = CommitModeManager.getInstance(this.myProject).getCurrentCommitMode().hideLocalChangesTab() || Registry.is((String)"vcs.disable.changelists", (boolean)false);
        return !forceDisable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areChangeListsEnabled() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.areChangeListsEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChangeListsNumber() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListsNumber();
        }
    }

    public void showLocalChangesInvalidated() {
        this.myShowLocalChangesInvalidated = true;
    }

    public ChangelistConflictTracker getConflictTracker() {
        return this.myConflictTracker;
    }

    @Override
    public boolean isFreezedWithNotification(@Nls @Nullable String modalTitle) {
        String freezeReason = this.isFreezed();
        if (freezeReason == null) {
            return false;
        }
        if (modalTitle != null) {
            Messages.showErrorDialog((Project)this.myProject, (String)freezeReason, (String)modalTitle);
        } else {
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, freezeReason, MessageType.WARNING, new NamedRunnable[0]);
        }
        return true;
    }

    public void replaceCommitMessage(@NotNull String oldMessage, @NotNull String newMessage) {
        if (oldMessage == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(107);
        }
        if (newMessage == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(108);
        }
        VcsConfiguration.getInstance(this.myProject).replaceMessage(oldMessage, newMessage);
        if (this.areChangeListsEnabled()) {
            for (LocalChangeList changeList : this.getChangeLists()) {
                if (!oldMessage.equals(changeList.getComment())) continue;
                this.editComment(changeList.getName(), newMessage);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 28, 29, 30, 31, 32, 33, 34, 35, 36, 39, 41, 57, 58, 64, 66, 68, 69, 76, 77, 79, 81, 82, 84, 98, 100, 103 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 3: 
            case 43: 
            case 46: 
            case 47: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterUpdate";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 15: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 57: 
            case 58: 
            case 64: 
            case 66: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 98: 
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gate";
                break;
            }
            case 26: 
            case 65: 
            case 70: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 37: 
            case 62: 
            case 67: 
            case 71: 
            case 72: 
            case 74: 
            case 104: 
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 54: 
            case 56: 
            case 63: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 59: 
            case 73: 
            case 75: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeChangeListsIds";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterChangeListsIds";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 88: 
            case 90: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToIgnore";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMessage";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseWaitForUpdate";
                break;
            }
            case 28: 
            case 66: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPaths";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFilesPaths";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedWithoutEditing";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilePaths";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUpdateInfo";
                break;
            }
            case 39: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "addChangeList";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultChangeList";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultListName";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedLists";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 79: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesIn";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "haveChangesUnder";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredExecutors";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToIgnore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAutomaticEmptyChangeListDeletion";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showRemoveEmptyChangeListsProposal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeTracker";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unregisterChangeTracker";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invokeAfterUpdate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "freeze";
                break;
            }
            case 15: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 57: 
            case 58: 
            case 64: 
            case 66: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 98: 
            case 100: 
            case 103: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeOnUpdaterThread";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "executeUnderDataLock";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "iterateScopes";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "actualUpdate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isFileAffected";
                break;
            }
            case 38: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addChangeList";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeList";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultChangeList";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "editComment";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "editChangeListData";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "moveChangesTo";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "notifyChangelistsChanged";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedLists";
                break;
            }
            case 65: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getChangeLists";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getChangeList";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isUnversioned";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 78: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getChangesIn";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "haveChangesUnder";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isChangeUnder";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "addUnversionedFiles";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListListener";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListListener";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "registerCommitExecutor";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "commitChanges";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "commitChangesSynchronouslyWithResult";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "reopenFiles";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "addDirectoryToIgnoreImplicitly";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "setFilesToIgnore";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFile";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchedBranch";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "replaceCommitMessage";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 15, 28, 29, 30, 31, 32, 33, 34, 35, 36, 39, 41, 57, 58, 64, 66, 68, 69, 76, 77, 79, 81, 82, 84, 98, 100, 103 -> new IllegalStateException(string2);
        };
    }

    private final class DataHolder {
        private final boolean myWasEverythingDirty;
        private final FileHolderComposite myComposite;
        private final ChangeListWorker.ChangeListUpdater myChangeListUpdater;

        private DataHolder(FileHolderComposite composite, ChangeListWorker.ChangeListUpdater changeListUpdater, boolean wasEverythingDirty) {
            this.myComposite = composite;
            this.myChangeListUpdater = changeListUpdater;
            this.myWasEverythingDirty = wasEverythingDirty;
        }

        private void notifyStart() {
            if (this.myWasEverythingDirty) {
                this.myComposite.cleanAll();
                this.myChangeListUpdater.notifyStartProcessingChanges(null);
            }
        }

        private void notifyStartProcessingChanges(@NotNull VcsModifiableDirtyScope scope2) {
            if (scope2 == null) {
                DataHolder.$$$reportNull$$$0(0);
            }
            if (!this.myWasEverythingDirty) {
                this.myComposite.cleanUnderScope(scope2);
                this.myChangeListUpdater.notifyStartProcessingChanges(scope2);
            }
            this.myComposite.notifyVcsStarted(scope2.getVcs());
        }

        private void notifyDoneProcessingChanges(@NotNull VcsDirtyScope scope2) {
            if (scope2 == null) {
                DataHolder.$$$reportNull$$$0(1);
            }
            if (!this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator, scope2);
            }
        }

        void notifyEnd() {
            if (this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator, null);
            }
        }

        public void finish() {
            this.myChangeListUpdater.finish();
        }

        @NotNull
        public FileHolderComposite getComposite() {
            FileHolderComposite fileHolderComposite = this.myComposite;
            if (fileHolderComposite == null) {
                DataHolder.$$$reportNull$$$0(2);
            }
            return fileHolderComposite;
        }

        @NotNull
        public ChangeListWorker.ChangeListUpdater getChangeListUpdater() {
            ChangeListWorker.ChangeListUpdater changeListUpdater = this.myChangeListUpdater;
            if (changeListUpdater == null) {
                DataHolder.$$$reportNull$$$0(3);
            }
            return changeListUpdater;
        }

        @NotNull
        public ChangeListWorker getUpdatedWorker() {
            ChangeListWorker changeListWorker = this.myChangeListUpdater.getUpdatedWorker();
            if (changeListWorker == null) {
                DataHolder.$$$reportNull$$$0(4);
            }
            return changeListWorker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DataHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DataHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComposite";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangeListUpdater";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUpdatedWorker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyStartProcessingChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyDoneProcessingChanges";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3, 4 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class MyChangesDeltaForwarder
    implements ChangeListDeltaListener {
        private final RemoteRevisionsCache myRevisionsCache;
        private final ProjectLevelVcsManager myVcsManager;
        private final Project myProject;
        private final Scheduler myScheduler;

        MyChangesDeltaForwarder(Project project2, @NotNull Scheduler scheduler) {
            if (scheduler == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
            this.myScheduler = scheduler;
            this.myRevisionsCache = RemoteRevisionsCache.getInstance(project2);
            this.myVcsManager = ProjectLevelVcsManager.getInstance(project2);
        }

        @Override
        public void modified(@NotNull BaseRevision was, @NotNull BaseRevision become) {
            if (was == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(1);
            }
            if (become == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(2);
            }
            this.doModify(was, become);
        }

        @Override
        public void added(@NotNull BaseRevision baseRevision) {
            if (baseRevision == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(3);
            }
            this.doModify(baseRevision, baseRevision);
        }

        @Override
        public void removed(@NotNull BaseRevision baseRevision) {
            if (baseRevision == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(4);
            }
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(baseRevision);
                if (vcs != null) {
                    this.myRevisionsCache.changeRemoved(baseRevision.getPath(), vcs);
                }
                ((VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(baseRevision.getPath());
            });
        }

        private void doModify(BaseRevision was, BaseRevision become) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(was);
                if (vcs != null) {
                    this.myRevisionsCache.changeUpdated(was.getPath(), vcs);
                }
                ((VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(become);
            });
        }

        @Nullable
        private AbstractVcs getVcs(@NotNull BaseRevision baseRevision) {
            AbstractVcs vcs;
            if (baseRevision == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(5);
            }
            if ((vcs = baseRevision.getVcs()) != null) {
                return vcs;
            }
            return this.myVcsManager.getVcsFor(baseRevision.getFilePath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheduler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "was";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "become";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseRevision";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$MyChangesDeltaForwarder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modified";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "added";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVcs";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class DefaultIgnoredFileProvider
    implements IgnoredFileProvider {
        @Override
        public boolean isIgnoredFile(@NotNull Project project2, @NotNull FilePath filePath) {
            if (project2 == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(1);
            }
            IProjectStore store = ProjectKt.getStateStore((Project)project2);
            if (!ProjectKt.isDirectoryBased((Project)project2) && FileUtilRt.extensionEquals((String)filePath.getPath(), (String)"iws")) {
                return true;
            }
            if (StringsKt.equals((String)filePath.getPath(), (String)FileUtil.toSystemIndependentName((String)store.getWorkspacePath().toString()), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                return true;
            }
            return DefaultIgnoredFileProvider.isShelfDirOrInsideIt(filePath, project2);
        }

        private static boolean isShelfDirOrInsideIt(@NotNull FilePath filePath, @NotNull Project project2) {
            if (filePath == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(2);
            }
            if (project2 == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(3);
            }
            String shelfPath = ShelveChangesManager.getShelfPath(project2);
            return FileUtil.isAncestor((String)shelfPath, (String)filePath.getPath(), (boolean)false);
        }

        @Override
        @NotNull
        public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project2) {
            if (project2 == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(4);
            }
            LinkedHashSet<IgnoredFileBean> ignored = new LinkedHashSet<IgnoredFileBean>();
            String shelfPath = ShelveChangesManager.getShelfPath(project2);
            ignored.add(IgnoredBeanFactory.ignoreUnderDirectory(shelfPath, project2));
            Path workspaceFile = ProjectKt.getStateStore((Project)project2).getWorkspacePath();
            ignored.add(IgnoredBeanFactory.ignoreFile(workspaceFile.toString().replace(File.separatorChar, '/'), project2));
            Set set = ContainerUtil.unmodifiableOrEmptySet(ignored);
            if (set == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(5);
            }
            return set;
        }

        @Override
        @NotNull
        public String getIgnoredGroupDescription() {
            String string2 = VcsBundle.message("changes.text.default.ignored.files", new Object[0]);
            if (string2 == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(6);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DefaultIgnoredFileProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DefaultIgnoredFileProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIgnoredFiles";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIgnoredGroupDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isIgnoredFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isShelfDirOrInsideIt";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getIgnoredFiles";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 6 -> new IllegalStateException(string2);
            };
        }
    }

    static final class MyStartupActivity
    implements VcsStartupActivity {
        MyStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project2) {
            if (project2 == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            ChangeListManagerImpl.getInstanceImpl(project2).startUpdater();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.CHANGE_LIST_MANAGER.getOrder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$MyStartupActivity", "runActivity"));
        }
    }
}

