/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.UniqueNameGenerator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001a=\u0010\u000f\u001a\u00130\u0001\u00a2\u0006\u000e\b\u0004\u0012\n\b\u0010\u0012\u0006\b\n0\u00118\u00122\u0017\u0010\u0013\u001a\u00130\u0001\u00a2\u0006\u000e\b\u0004\u0012\n\b\u0010\u0012\u0006\b\n0\u00118\u00122\u000b\u0010\u0014\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0002\u001a\f0\u0001\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"CHANGELIST_NAME_PATTERN", "", "STASH_MESSAGE_PATTERN", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getSTASH_MESSAGE_PATTERN", "()Ljava/lang/String;", "SYSTEM_CHANGELIST_REGEX", "Lkotlin/text/Regex;", "getSYSTEM_CHANGELIST_REGEX", "()Lkotlin/text/Regex;", "createNameForChangeList", "project", "Lcom/intellij/openapi/project/Project;", "commitMessage", "createSystemShelvedChangeListName", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "systemPrefix", "changelistName", "Lcom/intellij/openapi/util/NlsSafe;", "getChangeListNameForUnshelve", "shelvedList", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChangeList;", "getOriginalName", "shelvedName", "getPredefinedChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "onChangeListAvailabilityChanged", "", "projectConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "callback", "Ljava/lang/Runnable;", "intellij.platform.vcs.impl"})
@JvmName(name="ChangeListUtil")
public final class ChangeListUtil {
    @NotNull
    private static final String CHANGELIST_NAME_PATTERN = "\\s\\[(.*)\\]";

    private static final String getSTASH_MESSAGE_PATTERN() {
        Object[] objectArray = new Object[]{".*"};
        String string2 = VcsBundle.message("stash.changes.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    private static final Regex getSYSTEM_CHANGELIST_REGEX() {
        return new Regex(ChangeListUtil.getSTASH_MESSAGE_PATTERN() + CHANGELIST_NAME_PATTERN);
    }

    @NotNull
    public static final String createSystemShelvedChangeListName(@NotNull String systemPrefix, @NotNull String changelistName) {
        Intrinsics.checkNotNullParameter((Object)systemPrefix, (String)"systemPrefix");
        Intrinsics.checkNotNullParameter((Object)changelistName, (String)"changelistName");
        return systemPrefix + " [" + changelistName + "]";
    }

    private static final String getOriginalName(String shelvedName) {
        Object object = ChangeListUtil.getSYSTEM_CHANGELIST_REGEX().matchEntire((CharSequence)shelvedName);
        if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
            object = shelvedName;
        }
        return object;
    }

    @Nullable
    public static final LocalChangeList getPredefinedChangeList(@NotNull ShelvedChangeList shelvedList, @NotNull ChangeListManager changeListManager) {
        Intrinsics.checkNotNullParameter((Object)shelvedList, (String)"shelvedList");
        Intrinsics.checkNotNullParameter((Object)changeListManager, (String)"changeListManager");
        String defaultName = shelvedList.DESCRIPTION;
        LocalChangeList localChangeList = changeListManager.findChangeList(defaultName);
        if (localChangeList == null) {
            if (shelvedList.isMarkedToDelete()) {
                Intrinsics.checkNotNull((Object)defaultName);
                localChangeList = changeListManager.findChangeList(ChangeListUtil.getOriginalName(defaultName));
            } else {
                localChangeList = null;
            }
        }
        return localChangeList;
    }

    @NotNull
    public static final String getChangeListNameForUnshelve(@NotNull ShelvedChangeList shelvedList) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)shelvedList, (String)"shelvedList");
        String defaultName = shelvedList.DESCRIPTION;
        if (shelvedList.isMarkedToDelete()) {
            Intrinsics.checkNotNull((Object)defaultName);
            string2 = ChangeListUtil.getOriginalName(defaultName);
        } else {
            Intrinsics.checkNotNull((Object)defaultName);
            string2 = defaultName;
        }
        return string2;
    }

    @NotNull
    public static final String createNameForChangeList(@NotNull Project project2, @NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)((Object)StringsKt.trim((CharSequence)commitMessage)).toString(), (char)'\n', null, (int)2, null))).toString();
        Regex regex = new Regex("[ ]{2,}");
        String string2 = " ";
        String proposedName = regex.replace(charSequence, string2);
        String string3 = UniqueNameGenerator.generateUniqueName((String)proposedName, (String)"", (String)"", (String)"-", (String)"", arg_0 -> ChangeListUtil.createNameForChangeList$lambda$0((Function1)new Function1<String, Boolean>(changeListManager2){
            final /* synthetic */ ChangeListManager $changeListManager;
            {
                this.$changeListManager = $changeListManager;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                return this.$changeListManager.findChangeList(it) == null;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"generateUniqueName(...)");
        return string3;
    }

    public static final void onChangeListAvailabilityChanged(@NotNull MessageBusConnection projectConnection, @NotNull Runnable callback2) {
        Intrinsics.checkNotNullParameter((Object)projectConnection, (String)"projectConnection");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Topic<ChangeListListener> topic = ChangeListListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        projectConnection.subscribe(topic, (Object)new ChangeListListener(callback2){
            final /* synthetic */ Runnable $callback;
            {
                this.$callback = $callback;
            }

            public void changeListAvailabilityChanged() {
                this.$callback.run();
            }
        });
    }

    private static final boolean createNameForChangeList$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

