/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewProcessorKt;
import com.intellij.openapi.vcs.changes.ChangesViewUserObjectTag;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0005H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewDiffPreviewProcessor;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;", "changesView", "Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;", "isInEditor", "", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;Z)V", "fireDiffSettingsChanged", "", "iterateAllChanges", "", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "iterateSelectedChanges", "selectChange", "change", "setAllowExcludeFromCommit", "value", "shouldAddToolbarBottomBorder", "toolbarComponents", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "showAllChangesForEmptySelection", "intellij.platform.vcs.impl"})
final class ChangesViewDiffPreviewProcessor
extends ChangeViewDiffRequestProcessor {
    @NotNull
    private final ChangesListView changesView;
    private final boolean isInEditor;

    public ChangesViewDiffPreviewProcessor(@NotNull ChangesListView changesView, boolean isInEditor) {
        Intrinsics.checkNotNullParameter((Object)((Object)changesView), (String)"changesView");
        super(changesView.getProject(), isInEditor ? "Default" : "ChangesView");
        this.changesView = changesView;
        this.isInEditor = isInEditor;
        this.putContextUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        Intrinsics.checkNotNullParameter((Object)toolbarComponents, (String)"toolbarComponents");
        return !this.isInEditor || super.shouldAddToolbarBottomBorder(toolbarComponents);
    }

    @NotNull
    public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateSelectedChanges() {
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        JBIterable<ChangesBrowserNode<?>> jBIterable = this.changesView.getSelectedChangesNodes();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getSelectedChangesNodes(...)");
        Iterable iterable = (Iterable)jBIterable;
        JBIterable<FilePath> jBIterable2 = this.changesView.getSelectedUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"getSelectedUnversionedFiles(...)");
        return ChangesViewDiffPreviewProcessorKt.access$wrap(project2, iterable, (Iterable)jBIterable2);
    }

    @NotNull
    public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateAllChanges() {
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        JBIterable<ChangesBrowserChangeNode> jBIterable = this.changesView.getChangesNodes();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getChangesNodes(...)");
        Iterable iterable = (Iterable)jBIterable;
        JBIterable<FilePath> jBIterable2 = this.changesView.getUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"getUnversionedFiles(...)");
        return ChangesViewDiffPreviewProcessorKt.access$wrap(project2, iterable, (Iterable)jBIterable2);
    }

    @Override
    protected boolean showAllChangesForEmptySelection() {
        return false;
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ChangesBrowserNode.Tag tag = change.getTag();
        ChangesViewUserObjectTag changesViewUserObjectTag = tag instanceof ChangesViewUserObjectTag ? (ChangesViewUserObjectTag)tag : null;
        Object tag2 = changesViewUserObjectTag != null ? changesViewUserObjectTag.getUserObject() : null;
        TreePath treePath = this.changesView.findNodePathInTree(change.getUserObject(), tag2);
        if (treePath == null) {
            return;
        }
        TreePath treePath2 = treePath;
        TreeUtil.selectPath((JTree)((JTree)((Object)this.changesView)), (TreePath)treePath2, (boolean)false);
    }

    public final void setAllowExcludeFromCommit(boolean value2) {
        UserDataHolder[] userDataHolderArray = new UserDataHolder[]{this.getContext()};
        if (DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (UserDataHolder[])userDataHolderArray) == value2) {
            return;
        }
        this.getContext().putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)value2);
        this.fireDiffSettingsChanged();
    }

    public final void fireDiffSettingsChanged() {
        this.dropCaches();
        this.updateRequest(true);
    }
}

