/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommittedChangesFilterDialog
extends DialogWrapper {
    private final ChangesBrowserSettingsEditor myPanel;
    private ChangeBrowserSettings mySettings;
    private final JLabel myErrorLabel;
    private final Alarm myValidateAlarm;
    private final Runnable myValidateRunnable;

    public CommittedChangesFilterDialog(Project project2, @NotNull ChangesBrowserSettingsEditor panel2, @NotNull ChangeBrowserSettings settings) {
        if (panel2 == null) {
            CommittedChangesFilterDialog.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            CommittedChangesFilterDialog.$$$reportNull$$$0(1);
        }
        super(project2, false);
        this.myErrorLabel = new JLabel();
        this.myValidateAlarm = new Alarm();
        this.myValidateRunnable = new Runnable(){

            @Override
            public void run() {
                CommittedChangesFilterDialog.this.validateInput();
                CommittedChangesFilterDialog.this.myValidateAlarm.addRequest(CommittedChangesFilterDialog.this.myValidateRunnable, 500, ModalityState.stateForComponent((Component)CommittedChangesFilterDialog.this.myPanel.getComponent()));
            }
        };
        this.myPanel = panel2;
        this.myPanel.setSettings(settings);
        this.setTitle(VcsBundle.message("browse.changes.filter.title", new Object[0]));
        this.init();
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        this.validateInput();
        this.myValidateAlarm.addRequest(this.myValidateRunnable, 500, ModalityState.stateForComponent((Component)this.myPanel.getComponent()));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myPanel.getComponent(), "Center");
        panel2.add((Component)this.myErrorLabel, "South");
        return panel2;
    }

    private void validateInput() {
        String error = this.myPanel.validateInput();
        this.setOKActionEnabled(error == null);
        this.myErrorLabel.setText(error == null ? " " : error);
    }

    protected void doOKAction() {
        this.validateInput();
        if (this.isOKActionEnabled()) {
            this.myValidateAlarm.cancelAllRequests();
            this.mySettings = this.myPanel.getSettings();
            super.doOKAction();
        }
    }

    public ChangeBrowserSettings getSettings() {
        return this.mySettings;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "AbstractVcsHelper.FilterDialog." + this.myPanel.getDimensionServiceKey();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "panel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/committed/CommittedChangesFilterDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

