/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.webTypes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.webSymbols.webTypes.WebTypesLoadUtilKt;
import com.intellij.webSymbols.webTypes.json.WebTypes;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/webSymbols/webTypes/WebTypesJsonFilesCache;", "", "()V", "Companion", "intellij.platform.webSymbols"})
@ApiStatus.Internal
public final class WebTypesJsonFilesCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String WEB_TYPES_FILE_SUFFIX = ".web-types.json";

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/webSymbols/webTypes/WebTypesJsonFilesCache$Companion;", "", "()V", "WEB_TYPES_FILE_SUFFIX", "", "downloadWebTypesJson", "tarball", "fromUrlNoCache", "Lcom/intellij/webSymbols/webTypes/json/WebTypes;", "url", "getWebTypesJson", "Ljava/io/InputStream;", "intellij.platform.webSymbols"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebTypes fromUrlNoCache(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return WebTypesLoadUtilKt.readWebTypes(this.getWebTypesJson(url));
        }

        @NotNull
        public final InputStream getWebTypesJson(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (StringsKt.endsWith$default((String)url, (String)"json", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)url, (String)"file:", (boolean)false, (int)2, null)) {
                return new FileInputStream(new File(new URI(url)));
            }
            File downloadedJson = new File(PathManager.getSystemPath(), "web-types/" + FilesKt.getNameWithoutExtension((File)new File(url)) + WebTypesJsonFilesCache.WEB_TYPES_FILE_SUFFIX);
            if (!downloadedJson.exists()) {
                downloadedJson.getParentFile().mkdirs();
                String content = this.downloadWebTypesJson(url);
                ObjectMapper mapper = new ObjectMapper();
                JsonNode webTypesJson = mapper.readTree(content);
                mapper.writer().writeValue(downloadedJson, (Object)webTypesJson);
            }
            return new FileInputStream(downloadedJson);
        }

        private final String downloadWebTypesJson(String tarball) {
            byte[] contents = HttpRequests.request((String)tarball).readBytes(null);
            BufferedInputStream bi = new BufferedInputStream(new ByteArrayInputStream(contents));
            GzipCompressorInputStream gzi = new GzipCompressorInputStream((InputStream)bi);
            TarArchiveInputStream input = new TarArchiveInputStream((InputStream)gzi);
            ArchiveEntry e = input.getNextEntry();
            while (e != null) {
                String string2 = e.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string2, (String)WebTypesJsonFilesCache.WEB_TYPES_FILE_SUFFIX, (boolean)false, (int)2, null) && input.canReadEntryData(e)) {
                    return FileUtil.loadTextAndClose((InputStream)((InputStream)input));
                }
                e = input.getNextEntry();
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

