/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.remote;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.UriUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonFileResolver {
    private static final Key<Boolean> DOWNLOAD_STARTED = Key.create((String)"DOWNLOAD_STARTED");

    public static boolean isRemoteEnabled(Project project2) {
        return !ApplicationManager.getApplication().isUnitTestMode() && JsonSchemaCatalogProjectConfiguration.getInstance(project2).isRemoteActivityEnabled();
    }

    @Nullable
    public static VirtualFile urlToFile(@NotNull String urlString) {
        if (urlString == null) {
            JsonFileResolver.$$$reportNull$$$0(0);
        }
        if (urlString.startsWith("temp:///")) {
            return TempFileSystem.getInstance().findFileByPath(urlString.substring("temp:///".length() - 1));
        }
        return VirtualFileManager.getInstance().findFileByUrl(FileUtil.toSystemIndependentName((String)JsonFileResolver.replaceUnsafeSchemaStoreUrls(urlString)));
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String replaceUnsafeSchemaStoreUrls(@Nullable String urlString) {
        if (urlString == null) {
            return null;
        }
        if (urlString.equals("http://schemastore.org/api/json/catalog.json")) {
            return "https://schemastore.org/api/json/catalog.json";
        }
        if (StringUtil.startsWithIgnoreCase((String)urlString, (String)"http://json.schemastore.org")) {
            String newUrl = StringUtil.replace((String)urlString, (String)"http://json.schemastore.org/", (String)"https://schemastore.azurewebsites.net/schemas/json/");
            return newUrl.endsWith(".json") ? newUrl : newUrl + ".json";
        }
        return urlString;
    }

    @Nullable
    public static VirtualFile resolveSchemaByReference(@Nullable VirtualFile currentFile, @Nullable String schemaUrl) {
        if (schemaUrl == null) {
            return null;
        }
        boolean isHttpPath = JsonFileResolver.isHttpPath((String)schemaUrl);
        if (!isHttpPath && currentFile instanceof HttpVirtualFile) {
            String url = StringUtil.trimEnd((String)currentFile.getUrl(), (String)"/");
            int lastSlash = url.lastIndexOf(47);
            assert (lastSlash != -1);
            schemaUrl = url.substring(0, lastSlash) + "/" + (String)schemaUrl;
        } else if (StringUtil.startsWithChar((CharSequence)schemaUrl, (char)'.') || !isHttpPath) {
            VirtualFile parent;
            VirtualFile virtualFile = parent = currentFile == null ? null : currentFile.getParent();
            Object object = parent == null ? null : (schemaUrl = parent.getUrl().startsWith("temp:///") ? "temp:///" + parent.getPath() + "/" + (String)schemaUrl : VfsUtilCore.pathToUrl((String)(parent.getPath() + File.separator + (String)schemaUrl)));
        }
        if (schemaUrl != null) {
            String url;
            Url parse;
            VirtualFile virtualFile = JsonFileResolver.urlToFile((String)schemaUrl);
            if (virtualFile instanceof HttpVirtualFile && ((parse = Urls.parse((String)(url = virtualFile.getUrl()), (boolean)false)) == null || StringUtil.isEmpty((String)parse.getAuthority()) || StringUtil.isEmpty((String)parse.getPath()))) {
                return null;
            }
            if (virtualFile != null) {
                return virtualFile;
            }
        }
        return null;
    }

    public static void startFetchingHttpFileIfNeeded(@Nullable VirtualFile path2, Project project2) {
        if (!(path2 instanceof HttpVirtualFile)) {
            return;
        }
        if (!JsonFileResolver.isRemoteEnabled(project2)) {
            return;
        }
        RemoteFileInfo info = ((HttpVirtualFile)path2).getFileInfo();
        if ((info == null || info.getState() == RemoteFileState.DOWNLOADING_NOT_STARTED) && path2.getUserData(DOWNLOAD_STARTED) != Boolean.TRUE) {
            path2.putUserData(DOWNLOAD_STARTED, (Object)Boolean.TRUE);
            path2.refresh(true, false);
        }
    }

    public static boolean isHttpPath(@NotNull String schemaFieldText) {
        if (schemaFieldText == null) {
            JsonFileResolver.$$$reportNull$$$0(1);
        }
        Couple couple = UriUtil.splitScheme((String)schemaFieldText);
        return ((String)couple.first).startsWith("http");
    }

    public static boolean isAbsoluteUrl(@NotNull String path2) {
        if (path2 == null) {
            JsonFileResolver.$$$reportNull$$$0(2);
        }
        return JsonFileResolver.isHttpPath(path2) || path2.startsWith("temp:///") || FileUtil.toSystemIndependentName((String)path2).startsWith("jar://");
    }

    public static boolean isTempOrMockUrl(@NotNull String path2) {
        if (path2 == null) {
            JsonFileResolver.$$$reportNull$$$0(3);
        }
        return path2.startsWith("temp:///") || path2.startsWith("mock:///");
    }

    public static boolean isSchemaUrl(@Nullable String url) {
        return url != null && url.startsWith("http://json-schema.org/") && (url.endsWith("/schema") || url.endsWith("/schema#"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFieldText";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/remote/JsonFileResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "urlToFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isHttpPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbsoluteUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTempOrMockUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

