/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.MessageManagerBase;
import org.jetbrains.rpc.MessageManagerBaseKt;
import org.jetbrains.rpc.RequestCallback;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u0004\b\u0001\u0010\u0003*\b\b\u0002\u0010\u0004*\u00020\u0005*\u0004\b\u0003\u0010\u00062\u00020\u0007:\u0001\u001dB%\u0012\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00030\r2\u0006\u0010\u0015\u001a\u00020\u0013J\u0013\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00028\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00030\r\u00a2\u0006\u0002\u0010\u001cR$\u0010\u000b\u001a\u0018\u0012\u000f\u0012\r\u0012\u0004\u0012\u00028\u00030\r\u00a2\u0006\u0002\b\u000e0\f\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/rpc/MessageManager;", "REQUEST", "Lorg/jetbrains/jsonProtocol/Request;", "INCOMING", "INCOMING_WITH_SEQ", "", "SUCCESS", "Lorg/jetbrains/rpc/MessageManagerBase;", "handler", "Lorg/jetbrains/rpc/MessageManager$Handler;", "(Lorg/jetbrains/rpc/MessageManager$Handler;)V", "callbackMap", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lorg/jetbrains/rpc/RequestCallback;", "Lorg/jetbrains/annotations/NotNull;", "cancelWaitingRequests", "", "failedToSend", "sequence", "", "getCallbackAndRemove", "id", "processIncoming", "incomingParsed", "(Ljava/lang/Object;)V", "send", "message", "callback", "(Lorg/jetbrains/jsonProtocol/Request;Lorg/jetbrains/rpc/RequestCallback;)V", "Handler", "intellij.platform.scriptDebugger.backend"})
public final class MessageManager<REQUEST extends Request<?>, INCOMING, INCOMING_WITH_SEQ, SUCCESS>
extends MessageManagerBase {
    @NotNull
    private final Handler<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS> handler;
    @NotNull
    private final ConcurrentIntObjectMap<RequestCallback<SUCCESS>> callbackMap;

    public MessageManager(@NotNull Handler<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.handler = handler2;
        ConcurrentIntObjectMap concurrentIntObjectMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentIntObjectMap, (String)"createConcurrentIntObjectMap(...)");
        this.callbackMap = concurrentIntObjectMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(@NotNull REQUEST message2, @NotNull RequestCallback<SUCCESS> callback2) {
        Intrinsics.checkNotNullParameter(message2, (String)"message");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        if (this.rejectIfClosed(callback2)) {
            message2.getBuffer().release();
            return;
        }
        int sequence = this.handler.getUpdatedSequence(message2);
        this.callbackMap.put(sequence, callback2);
        boolean success2 = false;
        try {
            success2 = this.handler.write(message2);
        }
        catch (Throwable e) {
            try {
                this.failedToSend(sequence);
            }
            finally {
                CommandProcessorKt.getLOG().error("Failed to send", e);
            }
            return;
        }
        if (!success2) {
            this.failedToSend(sequence);
        }
    }

    private final void failedToSend(int sequence) {
        block0: {
            RequestCallback requestCallback = (RequestCallback)this.callbackMap.remove(sequence);
            if (requestCallback == null) break block0;
            requestCallback.onError("Failed to send");
        }
    }

    public final void processIncoming(INCOMING incomingParsed) {
        INCOMING_WITH_SEQ commandResponse = this.handler.readIfHasSequence(incomingParsed);
        if (commandResponse == null) {
            if (this.getClosed()) {
                CommandProcessorKt.getLOG().info("Connection closed, ignore incoming");
            } else {
                this.handler.acceptNonSequence(incomingParsed);
            }
            return;
        }
        RequestCallback<SUCCESS> callback2 = this.getCallbackAndRemove(this.handler.getSequence(commandResponse, incomingParsed));
        if (this.rejectIfClosed(callback2)) {
            return;
        }
        try {
            this.handler.call(commandResponse, callback2);
        }
        catch (Throwable e) {
            callback2.onError(e);
            CommandProcessorKt.getLOG().error("Failed to dispatch response to callback", e);
        }
    }

    @NotNull
    public final RequestCallback<SUCCESS> getCallbackAndRemove(int id) {
        RequestCallback requestCallback = (RequestCallback)this.callbackMap.remove(id);
        if (requestCallback == null) {
            throw new IllegalArgumentException("Cannot find callback with id " + id);
        }
        return requestCallback;
    }

    public final void cancelWaitingRequests() {
        ConcurrentIntObjectMap<RequestCallback<SUCCESS>> map2 = this.callbackMap;
        int[] keys = map2.keys();
        Arrays.sort(keys);
        Intrinsics.checkNotNull((Object)keys);
        for (int key2 : keys) {
            RequestCallback requestCallback = (RequestCallback)map2.get(key2);
            if (requestCallback == null) continue;
            MessageManagerBaseKt.reject(requestCallback);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0004\u0010\u0001*\u0004\b\u0005\u0010\u0002*\b\b\u0006\u0010\u0003*\u00020\u0004*\u0004\b\u0007\u0010\u00052\u00020\u0004J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0005H&\u00a2\u0006\u0002\u0010\tJ#\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00028\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00070\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0006H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u00062\u0006\u0010\b\u001a\u00028\u0005H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00028\u0004H&\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0016\u001a\u0004\u0018\u00018\u00062\u0006\u0010\b\u001a\u00028\u0005H&\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00028\u0004H&\u00a2\u0006\u0002\u0010\u001a\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/rpc/MessageManager$Handler;", "OUTGOING", "INCOMING", "INCOMING_WITH_SEQ", "", "SUCCESS", "acceptNonSequence", "", "incoming", "(Ljava/lang/Object;)V", "call", "response", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "(Ljava/lang/Object;Lorg/jetbrains/rpc/RequestCallback;)V", "getSequence", "", "incomingWithSeq", "(Ljava/lang/Object;)I", "(Ljava/lang/Object;Ljava/lang/Object;)I", "getUpdatedSequence", "message", "readIfHasSequence", "(Ljava/lang/Object;)Ljava/lang/Object;", "write", "", "(Ljava/lang/Object;)Z", "intellij.platform.scriptDebugger.backend"})
    public static interface Handler<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS> {
        public int getUpdatedSequence(OUTGOING var1);

        public boolean write(OUTGOING var1) throws IOException;

        @Nullable
        public INCOMING_WITH_SEQ readIfHasSequence(INCOMING var1);

        default public int getSequence(@NotNull INCOMING_WITH_SEQ incomingWithSeq) {
            Intrinsics.checkNotNullParameter(incomingWithSeq, (String)"incomingWithSeq");
            throw new AbstractMethodError();
        }

        default public int getSequence(@NotNull INCOMING_WITH_SEQ incomingWithSeq, INCOMING incoming) {
            Intrinsics.checkNotNullParameter(incomingWithSeq, (String)"incomingWithSeq");
            return this.getSequence(incomingWithSeq);
        }

        public void acceptNonSequence(INCOMING var1);

        public void call(@NotNull INCOMING_WITH_SEQ var1, @NotNull RequestCallback<SUCCESS> var2);
    }
}

