/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigQualifiedKeyDescriptor;
import org.editorconfig.language.util.EditorConfigDescriptorUtil;
import org.editorconfig.language.util.EditorConfigTemplateUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\f0\u0006\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigAddRequiredDeclarationsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "missingDescriptors", "", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigDeclarationDescriptor;", "id", "", "(Ljava/util/List;Ljava/lang/String;)V", "missingKeys", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigQualifiedKeyDescriptor;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigAddRequiredDeclarationsQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigAddRequiredDeclarationsQuickFix.kt\norg/editorconfig/language/codeinsight/quickfixes/EditorConfigAddRequiredDeclarationsQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EditorConfigDescriptorUtil.kt\norg/editorconfig/language/util/EditorConfigDescriptorUtil\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1603#2,9:49\n1855#2:58\n1856#2:61\n1612#2:62\n29#3:59\n1#4:60\n*S KotlinDebug\n*F\n+ 1 EditorConfigAddRequiredDeclarationsQuickFix.kt\norg/editorconfig/language/codeinsight/quickfixes/EditorConfigAddRequiredDeclarationsQuickFix\n*L\n23#1:49,9\n23#1:58\n23#1:61\n23#1:62\n24#1:59\n23#1:60\n*E\n"})
public final class EditorConfigAddRequiredDeclarationsQuickFix
implements LocalQuickFix {
    @NotNull
    private final String id;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final List<EditorConfigQualifiedKeyDescriptor> missingKeys;

    /*
     * WARNING - void declaration
     */
    public EditorConfigAddRequiredDeclarationsQuickFix(@NotNull List<EditorConfigDeclarationDescriptor> missingDescriptors, @NotNull String id) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(missingDescriptors, (String)"missingDescriptors");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        Iterable iterable = missingDescriptors;
        EditorConfigAddRequiredDeclarationsQuickFix editorConfigAddRequiredDeclarationsQuickFix = this;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EditorConfigQualifiedKeyDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            EditorConfigDeclarationDescriptor it = (EditorConfigDeclarationDescriptor)element$iv$iv;
            boolean bl2 = false;
            EditorConfigDescriptorUtil this_$iv = EditorConfigDescriptorUtil.INSTANCE;
            boolean $i$f$getParentOfType = false;
            if ((EditorConfigQualifiedKeyDescriptor)this_$iv.getParentOfType(it, Reflection.getOrCreateKotlinClass(EditorConfigQualifiedKeyDescriptor.class)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        editorConfigAddRequiredDeclarationsQuickFix.missingKeys = (List)destination$iv$iv;
    }

    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.declaration.add-required.description");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
        PsiElement psiElement = problemDescriptor.getPsiElement();
        EditorConfigDescribableElement editorConfigDescribableElement = psiElement instanceof EditorConfigDescribableElement ? (EditorConfigDescribableElement)psiElement : null;
        if (editorConfigDescribableElement == null) {
            return;
        }
        EditorConfigDescribableElement element = editorConfigDescribableElement;
        EditorConfigSection section = element.getSection();
        EditorConfigOption option = element.getOption();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        TemplateImpl template = EditorConfigTemplateUtil.buildFullTemplate$default(EditorConfigTemplateUtil.INSTANCE, this.id, this.missingKeys, section, MapsKt.mapOf((Pair)TuplesKt.to((Object)this.id, (Object)element.getText())), false, 16, null);
        editor2.getCaretModel().moveToOffset(option.getTextOffset() + option.getTextLength());
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor2.getSelectionModel().removeSelection();
        TemplateManager.getInstance((Project)project).startTemplate(editor2, (Template)template);
    }
}

