/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.internal.statistic.eventLog.ExternalEventLogSettings;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogListener;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J6\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005R)\u0010\u0003\u001a\u001d\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\b\u001a#\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00070\u00070\t\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogListenersManager;", "", "()V", "listenersFromEP", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogListener;", "subscribers", "Lcom/intellij/util/containers/MultiMap;", "kotlin.jvm.PlatformType", "addListenerFromEP", "", "recorderId", "addListenersFromEP", "notifySubscribers", "validatedEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rawEventId", "rawData", "", "subscribe", "subscriber", "unsubscribe", "intellij.platform.statistics"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEventLogListenersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLogListenersManager.kt\ncom/intellij/internal/statistic/eventLog/EventLogListenersManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n766#2:86\n857#2,2:87\n1549#2:89\n1620#2,3:90\n1855#2,2:93\n*S KotlinDebug\n*F\n+ 1 EventLogListenersManager.kt\ncom/intellij/internal/statistic/eventLog/EventLogListenersManager\n*L\n44#1:86\n44#1:87,2\n45#1:89\n45#1:90,3\n45#1:93,2\n*E\n"})
public final class EventLogListenersManager {
    @NotNull
    private final MultiMap<String, StatisticsEventLogListener> subscribers;
    @NotNull
    private ConcurrentMap<String, StatisticsEventLogListener> listenersFromEP;

    public EventLogListenersManager() {
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent(...)");
        this.subscribers = multiMap;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.listenersFromEP = concurrentMap;
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(ExternalEventLogSettings.EP_NAME)) {
            this.addListenersFromEP();
            ExternalEventLogSettings.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ExternalEventLogSettings>(){

                public void extensionAdded(@NotNull ExternalEventLogSettings extension, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    this.addListenersFromEP();
                }

                /*
                 * WARNING - void declaration
                 */
                public void extensionRemoved(@NotNull ExternalEventLogSettings extension, @NotNull PluginDescriptor pluginDescriptor) {
                    void $this$forEach$iv;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    if (listenersFromEP.isEmpty()) {
                        return;
                    }
                    Iterable $this$map$iv = StatisticsEventLogProviderUtil.getEventLogProviders();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        StatisticsEventLoggerProvider statisticsEventLoggerProvider = (StatisticsEventLoggerProvider)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getRecorderId());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    EventLogListenersManager eventLogListenersManager = this;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        StatisticsEventLogListener listener;
                        String recorderId = (String)element$iv;
                        boolean bl = false;
                        if ((StatisticsEventLogListener)eventLogListenersManager.listenersFromEP.get(recorderId) == null) continue;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)listener);
                        eventLogListenersManager.unsubscribe(listener, recorderId);
                        eventLogListenersManager.listenersFromEP.remove(recorderId);
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addListenersFromEP() {
        void $this$mapTo$iv$iv;
        StatisticsEventLoggerProvider it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StatisticsEventLogProviderUtil.getEventLogProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (StatisticsEventLoggerProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isLoggingAlwaysActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (StatisticsEventLoggerProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRecorderId());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            this.addListenerFromEP(it2);
        }
    }

    private final void addListenerFromEP(String recorderId) {
        block2: {
            ExternalEventLogSettings externalEventLogSettings2;
            if (this.listenersFromEP.get(recorderId) != null) {
                return;
            }
            ExternalEventLogSettings externalEventLogSettings3 = externalEventLogSettings2 = StatisticsEventLogProviderUtil.getExternalEventLogSettings();
            if (externalEventLogSettings3 == null) break block2;
            ExternalEventLogSettings it = externalEventLogSettings3;
            boolean bl = false;
            StatisticsEventLogListener statisticsEventLogListener = externalEventLogSettings2.getEventLogListener(recorderId);
            if (statisticsEventLogListener != null) {
                StatisticsEventLogListener eventLogListener = statisticsEventLogListener;
                boolean bl2 = false;
                ((Map)this.listenersFromEP).put(recorderId, eventLogListener);
                Intrinsics.checkNotNull((Object)eventLogListener);
                this.subscribe(eventLogListener, recorderId);
            }
        }
    }

    public final void notifySubscribers(@NotNull String recorderId, @NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
        Collection collection = this.subscribers.get((Object)recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection listeners = collection;
        for (StatisticsEventLogListener listener : listeners) {
            listener.onLogEvent(validatedEvent, rawEventId, rawData);
        }
    }

    public final void subscribe(@NotNull StatisticsEventLogListener subscriber, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        if (!PluginInfoDetectorKt.getPluginInfo(subscriber.getClass()).isDevelopedByJetBrains()) {
            return;
        }
        this.subscribers.putValue((Object)recorderId, (Object)subscriber);
    }

    public final void unsubscribe(@NotNull StatisticsEventLogListener subscriber, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.subscribers.remove((Object)recorderId, (Object)subscriber);
    }
}

