/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "", "command", "", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "(Ljava/lang/String;Lcom/intellij/openapi/editor/RangeMarker;)V", "getCommand", "()Ljava/lang/String;", "endOffset", "", "getEndOffset", "()I", "outputStartOffset", "getOutputStartOffset", "getRange", "()Lcom/intellij/openapi/editor/RangeMarker;", "startOffset", "getStartOffset", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.terminal"})
public final class CommandBlock {
    @Nullable
    private final String command;
    @NotNull
    private final RangeMarker range;

    public CommandBlock(@Nullable String command, @NotNull RangeMarker range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.command = command;
        this.range = range;
    }

    @Nullable
    public final String getCommand() {
        return this.command;
    }

    @NotNull
    public final RangeMarker getRange() {
        return this.range;
    }

    public final int getStartOffset() {
        return this.range.getStartOffset();
    }

    public final int getEndOffset() {
        return this.range.getEndOffset();
    }

    public final int getOutputStartOffset() {
        CharSequence charSequence;
        return this.range.getStartOffset() + (!((charSequence = (CharSequence)this.command) == null || charSequence.length() == 0) ? this.command.length() + 1 : 0);
    }

    @NotNull
    public final TextRange getTextRange() {
        TextRange textRange = this.range.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    @Nullable
    public final String component1() {
        return this.command;
    }

    @NotNull
    public final RangeMarker component2() {
        return this.range;
    }

    @NotNull
    public final CommandBlock copy(@Nullable String command, @NotNull RangeMarker range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new CommandBlock(command, range);
    }

    public static /* synthetic */ CommandBlock copy$default(CommandBlock commandBlock, String string, RangeMarker rangeMarker, int n, Object object) {
        if ((n & 1) != 0) {
            string = commandBlock.command;
        }
        if ((n & 2) != 0) {
            rangeMarker = commandBlock.range;
        }
        return commandBlock.copy(string, rangeMarker);
    }

    @NotNull
    public String toString() {
        return "CommandBlock(command=" + this.command + ", range=" + this.range + ")";
    }

    public int hashCode() {
        int result2 = this.command == null ? 0 : this.command.hashCode();
        result2 = result2 * 31 + this.range.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommandBlock)) {
            return false;
        }
        CommandBlock commandBlock = (CommandBlock)other;
        if (!Intrinsics.areEqual((Object)this.command, (Object)commandBlock.command)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.range, (Object)commandBlock.range);
    }
}

