/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.MathUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.TerminalFocusModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0007J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0007J$\u0010#\u001a\u00020\u00172\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionController;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel$TerminalSelectionListener;", "focusModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;", "selectionModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;)V", "primarySelection", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "getPrimarySelection", "()Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "selectedBlocks", "", "getSelectedBlocks", "()Ljava/util/List;", "textSelectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "getTextSelectionModel", "()Lcom/intellij/openapi/editor/SelectionModel;", "clearSelection", "", "getBlockUnderMouse", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "makeBlockVisible", "block", "mouseClicked", "mousePressed", "selectLastBlock", "selectRelativeBlock", "isBelow", "", "selectionChanged", "oldSelection", "newSelection", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalSelectionController.kt\norg/jetbrains/plugins/terminal/exp/TerminalSelectionController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class TerminalSelectionController
implements EditorMouseListener,
TerminalSelectionModel.TerminalSelectionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalFocusModel focusModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private static final DataKey<TerminalSelectionController> KEY;

    public TerminalSelectionController(@NotNull TerminalFocusModel focusModel, @NotNull TerminalSelectionModel selectionModel, @NotNull TerminalOutputModel outputModel) {
        Intrinsics.checkNotNullParameter((Object)focusModel, (String)"focusModel");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        this.focusModel = focusModel;
        this.selectionModel = selectionModel;
        this.outputModel = outputModel;
        this.outputModel.getEditor().addEditorMouseListener((EditorMouseListener)this);
        TerminalSelectionModel.addListener$default(this.selectionModel, this, null, 2, null);
        TerminalFocusModel.addPromptFocusListener$default(this.focusModel, new FocusAdapter(){

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                this.clearSelection();
            }
        }, null, 2, null);
        this.getTextSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.getNewRange().isEmpty()) {
                    selectionModel.setSelectedBlocks(CollectionsKt.emptyList());
                }
            }
        });
    }

    @NotNull
    public final List<CommandBlock> getSelectedBlocks() {
        return this.selectionModel.getSelectedBlocks();
    }

    @Nullable
    public final CommandBlock getPrimarySelection() {
        return this.selectionModel.getPrimarySelection();
    }

    private final SelectionModel getTextSelectionModel() {
        SelectionModel selectionModel = this.outputModel.getEditor().getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        return selectionModel;
    }

    @RequiresEdt
    public final void selectRelativeBlock(boolean isBelow) {
        int curIndex;
        CommandBlock selectedBlock = this.selectionModel.getPrimarySelection();
        if (selectedBlock != null && (curIndex = this.outputModel.getIndexOfBlock(selectedBlock)) >= 0) {
            int newIndex;
            int n = newIndex = isBelow ? curIndex + 1 : curIndex - 1;
            boolean bl = 0 <= newIndex ? newIndex < this.outputModel.getBlocksSize() : false;
            if (bl) {
                CommandBlock newBlock = this.outputModel.getByIndex(newIndex);
                this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)newBlock));
                this.makeBlockVisible(newBlock);
            } else if (isBelow) {
                EditorEx editor = this.outputModel.getEditor();
                int visibleHeight = editor.getScrollingModel().getVisibleArea().height;
                editor.getScrollingModel().scrollVertically(editor.getContentComponent().getHeight() - visibleHeight);
            }
        }
    }

    @RequiresEdt
    public final void selectLastBlock() {
        CommandBlock commandBlock = this.outputModel.getLastBlock();
        if (commandBlock == null) {
            return;
        }
        CommandBlock block = commandBlock;
        this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
        this.makeBlockVisible(block);
    }

    @RequiresEdt
    public final void clearSelection() {
        this.selectionModel.setSelectedBlocks(CollectionsKt.emptyList());
        this.getTextSelectionModel().removeSelection();
        this.focusModel.focusPrompt();
    }

    public void mouseClicked(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getMouseEvent().getClickCount() == 1) {
            CommandBlock block = this.getBlockUnderMouse(event);
            if (block != null) {
                this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
            } else {
                this.clearSelection();
            }
        }
    }

    public void mousePressed(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!SwingUtilities.isRightMouseButton(event.getMouseEvent())) {
            return;
        }
        CommandBlock block = this.getBlockUnderMouse(event);
        if (block != null) {
            SelectionModel it = this.getTextSelectionModel();
            boolean bl = false;
            int n = it.getSelectionStart();
            int n2 = it.getSelectionEnd();
            int n3 = event.getOffset();
            boolean insideTextSelection = n <= n3 ? n3 <= n2 : false;
            if (!this.selectionModel.getSelectedBlocks().contains(block) && !insideTextSelection) {
                this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
            }
        } else {
            this.clearSelection();
        }
    }

    @Override
    public void selectionChanged(@NotNull List<CommandBlock> oldSelection, @NotNull List<CommandBlock> newSelection) {
        Intrinsics.checkNotNullParameter(oldSelection, (String)"oldSelection");
        Intrinsics.checkNotNullParameter(newSelection, (String)"newSelection");
        if (!((Collection)newSelection).isEmpty()) {
            this.getTextSelectionModel().removeSelection();
            this.focusModel.focusOutput();
        } else if (!this.getTextSelectionModel().hasSelection()) {
            this.focusModel.focusPrompt();
        }
    }

    private final CommandBlock getBlockUnderMouse(EditorMouseEvent event) {
        Rectangle bounds;
        CommandBlock block = this.outputModel.getByOffset(event.getOffset());
        if (block != null && (bounds = this.outputModel.getBlockBounds(block)).contains(event.getMouseEvent().getPoint())) {
            return block;
        }
        return null;
    }

    private final void makeBlockVisible(CommandBlock block) {
        EditorEx editor = this.outputModel.getEditor();
        Rectangle bounds = this.outputModel.getBlockBounds(block);
        Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int n = visibleArea.y;
        int n2 = visibleArea.y + visibleArea.height;
        int n3 = bounds.y;
        if (!(n <= n3 ? n3 < n2 : false)) {
            int n4;
            if (bounds.y < visibleArea.y) {
                n4 = bounds.y - 6;
            } else {
                int blockMaxHeight = Math.min(bounds.height + 6, visibleArea.height);
                n4 = bounds.y + blockMaxHeight - visibleArea.height;
            }
            int scrollOffset = n4;
            int offset = MathUtil.clamp((int)scrollOffset, (int)0, (int)editor.getContentComponent().getHeight());
            editor.getScrollingModel().scrollVertically(offset);
        }
    }

    static {
        DataKey dataKey = DataKey.create((String)"TerminalSelectionController");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionController$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalSelectionController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

