/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB\u001b\b\u0002\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalTextHighlighter;", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "model", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;)V", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "(Ljava/util/List;)V", "getHighlightings", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "editor", "Lcom/intellij/openapi/editor/highlighter/HighlighterClient;", "createIterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "startOffset", "", "setEditor", "", "MyHighlighterIterator", "intellij.terminal"})
public final class TerminalTextHighlighter
implements EditorHighlighter {
    @NotNull
    private final Function0<List<HighlightingInfo>> getHighlightings;
    @Nullable
    private HighlighterClient editor;

    private TerminalTextHighlighter(Function0<? extends List<HighlightingInfo>> getHighlightings) {
        this.getHighlightings = getHighlightings;
    }

    public TerminalTextHighlighter(final @NotNull TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this((Function0<? extends List<HighlightingInfo>>)((Function0)new Function0<List<? extends HighlightingInfo>>(){

            @NotNull
            public final List<HighlightingInfo> invoke() {
                return model.getAllHighlightings();
            }
        }));
    }

    public TerminalTextHighlighter(final @NotNull List<HighlightingInfo> highlightings) {
        Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
        this((Function0<? extends List<HighlightingInfo>>)((Function0)new Function0<List<? extends HighlightingInfo>>(){

            @NotNull
            public final List<HighlightingInfo> invoke() {
                return highlightings;
            }
        }));
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        HighlighterClient highlighterClient = this.editor;
        return new MyHighlighterIterator((Document)(highlighterClient != null ? highlighterClient.getDocument() : null), (List)this.getHighlightings.invoke());
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalTextHighlighter$MyHighlighterIterator;", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "document", "Lcom/intellij/openapi/editor/Document;", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "(Lcom/intellij/openapi/editor/Document;Ljava/util/List;)V", "curInd", "", "advance", "", "atEnd", "", "getDocument", "getEnd", "getStart", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getTokenType", "Lcom/intellij/psi/tree/IElementType;", "retreat", "intellij.terminal"})
    private static final class MyHighlighterIterator
    implements HighlighterIterator {
        @Nullable
        private final Document document;
        @NotNull
        private final List<HighlightingInfo> highlightings;
        private int curInd;

        public MyHighlighterIterator(@Nullable Document document, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            this.document = document;
            this.highlightings = highlightings;
        }

        public int getStart() {
            return this.highlightings.get(this.curInd).getStartOffset();
        }

        public int getEnd() {
            return this.highlightings.get(this.curInd).getEndOffset();
        }

        @NotNull
        public TextAttributes getTextAttributes() {
            return this.highlightings.get(this.curInd).getTextAttributes();
        }

        @Nullable
        public IElementType getTokenType() {
            return null;
        }

        public void advance() {
            if (this.curInd < this.highlightings.size()) {
                int n = this.curInd;
                this.curInd = n + 1;
            }
        }

        public void retreat() {
            if (this.curInd > -1) {
                int n = this.curInd;
                this.curInd = n + -1;
            }
        }

        public boolean atEnd() {
            return this.curInd < 0 || this.curInd >= this.highlightings.size();
        }

        @Nullable
        public Document getDocument() {
            return this.document;
        }
    }
}

