/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.i18n.GitBundleExtensions;
import git4idea.push.GitRejectedPushUpdateDialog;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000o\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u001d\u0018\u0000 ,2\u00020\u0001:\u0001,B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0018\u001a\u00020\n2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\r\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\r\u0010\u001f\u001a\u00070\r\u00a2\u0006\u0002\b H\u0002J\u0015\u0010!\u001a\u00070\u001b\u00a2\u0006\u0002\b\"2\u0006\u0010#\u001a\u00020\u0006H\u0002J\r\u0010$\u001a\u00070\r\u00a2\u0006\u0002\b%H\u0002J\u0006\u0010&\u001a\u00020'J\u0014\u0010(\u001a\u00020)*\u00020)2\u0006\u0010*\u001a\u00020+H\u0002R\u0010\u0010\f\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lgit4idea/push/GitRejectedPushUpdateDialog;", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "initialSettings", "Lgit4idea/push/PushUpdateSettings;", "rebaseOverMergeProblemDetected", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Lgit4idea/push/PushUpdateSettings;Z)V", "cancelButtonText", "", "doNotAsk", "Lcom/intellij/openapi/ui/DoNotAskOption;", "helpButtonId", "mergeButtonText", "rebaseButtonText", "<set-?>", "shouldAutoUpdateInFuture", "getShouldAutoUpdateInFuture", "()Z", "title", "allBranchesHaveTheSameName", "branches", "", "Lgit4idea/GitBranch;", "createDoNotAsk", "git4idea/push/GitRejectedPushUpdateDialog$createDoNotAsk$1", "()Lgit4idea/push/GitRejectedPushUpdateDialog$createDoNotAsk$1;", "descriptionEnding", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getCurrentBranch", "Lcom/intellij/openapi/util/NlsSafe;", "repository", "makeDescription", "Lorg/jetbrains/annotations/Nls;", "showAndGet", "Lgit4idea/push/GitRejectedPushUpdateDialog$Companion$PushRejectedExitCode;", "setDefaultAndFocusedActions", "Lcom/intellij/openapi/ui/MessageDialogBuilder$Message;", "updateMethod", "Lgit4idea/config/UpdateMethod;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRejectedPushUpdateDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRejectedPushUpdateDialog.kt\ngit4idea/push/GitRejectedPushUpdateDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1#2:174\n1271#3,2:175\n1285#3,4:177\n*S KotlinDebug\n*F\n+ 1 GitRejectedPushUpdateDialog.kt\ngit4idea/push/GitRejectedPushUpdateDialog\n*L\n86#1:175,2\n86#1:177,4\n*E\n"})
public final class GitRejectedPushUpdateDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<GitRepository> repositories;
    @NotNull
    private final PushUpdateSettings initialSettings;
    private final boolean rebaseOverMergeProblemDetected;
    @NlsContexts.DialogTitle
    @NotNull
    private final String title;
    @Nls
    @NotNull
    private final String mergeButtonText;
    @Nls
    @NotNull
    private final String rebaseButtonText;
    @Nls
    @NotNull
    private final String cancelButtonText;
    @NotNull
    private final String helpButtonId;
    @NotNull
    private final DoNotAskOption doNotAsk;
    private boolean shouldAutoUpdateInFuture;

    public GitRejectedPushUpdateDialog(@NotNull Project project, @NotNull Set<? extends GitRepository> repositories2, @NotNull PushUpdateSettings initialSettings, boolean rebaseOverMergeProblemDetected) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)initialSettings, (String)"initialSettings");
        this.project = project;
        this.repositories = repositories2;
        this.initialSettings = initialSettings;
        this.rebaseOverMergeProblemDetected = rebaseOverMergeProblemDetected;
        String string2 = GitBundle.message("push.rejected.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.title = string2;
        String string3 = GitBundle.message("push.rejected.merge", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.mergeButtonText = string3;
        if (this.rebaseOverMergeProblemDetected) {
            String string4 = GitBundle.message("push.rejected.rebase.anyway", new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        } else {
            String string5 = GitBundle.message("push.rejected.rebase", new Object[0]);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        }
        this.rebaseButtonText = string;
        String string6 = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getCancelButtonText(...)");
        this.cancelButtonText = string6;
        this.helpButtonId = "reference.VersionControl.Git.UpdateOnRejectedPushDialog";
        this.doNotAsk = (DoNotAskOption)this.createDoNotAsk();
    }

    public final boolean getShouldAutoUpdateInFuture() {
        return this.shouldAutoUpdateInFuture;
    }

    @NotNull
    public final Companion.PushRejectedExitCode showAndGet() {
        Object object = new String[]{this.mergeButtonText, this.rebaseButtonText, this.cancelButtonText};
        MessageDialogBuilder.Message message = new MessageDialogBuilder.Message(this.title, this.makeDescription()).buttons(object);
        UpdateMethod updateMethod = this.initialSettings.getUpdateMethod();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)updateMethod), (String)"getUpdateMethod(...)");
        String exitCode = MessageDialogBuilder.Message.show$default((MessageDialogBuilder.Message)((MessageDialogBuilder.Message)((MessageDialogBuilder.Message)((MessageDialogBuilder.Message)this.setDefaultAndFocusedActions(message, updateMethod).help(this.helpButtonId)).doNotAsk(this.doNotAsk)).asWarning()), (Project)this.project, null, (int)2, null);
        object = exitCode;
        return Intrinsics.areEqual((Object)object, (Object)this.mergeButtonText) ? Companion.PushRejectedExitCode.MERGE : (Intrinsics.areEqual((Object)object, (Object)this.rebaseButtonText) ? Companion.PushRejectedExitCode.REBASE : Companion.PushRejectedExitCode.CANCEL);
    }

    /*
     * WARNING - void declaration
     */
    private final String makeDescription() {
        HtmlBuilder description2 = new HtmlBuilder();
        if (GitUtil.justOneGitRepository(this.project)) {
            boolean bl;
            boolean bl2 = bl = !((Collection)this.repositories).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-GitRejectedPushUpdateDialog$makeDescription$22 = false;
                String $i$a$-assert-GitRejectedPushUpdateDialog$makeDescription$22 = "repositories are empty";
                throw new AssertionError((Object)$i$a$-assert-GitRejectedPushUpdateDialog$makeDescription$22);
            }
            GitRepository repository = (GitRepository)CollectionsKt.single((Iterable)this.repositories);
            String string = this.getCurrentBranch(repository).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String currentBranch = string;
            Object[] objectArray = new Object[]{currentBranch};
            description2.appendRaw(GitBundle.message("push.rejected.only.one.git.repo", objectArray)).nbsp();
        } else if (this.repositories.size() == 1) {
            Object object = ContainerUtil.getFirstItem((Collection)this.repositories);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirstItem(...)");
            GitRepository repository = (GitRepository)object;
            String string = this.getCurrentBranch(repository).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String currentBranch = string;
            Object[] objectArray = new Object[]{currentBranch, DvcsUtil.getShortRepositoryName((Repository)repository)};
            description2.appendRaw(GitBundle.message("push.rejected.specific.repo", objectArray)).nbsp();
        } else {
            Iterable $this$associateWith$iv = this.repositories;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                GitRepository gitRepository = (GitRepository)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                GitBranch gitBranch = this.getCurrentBranch((GitRepository)it);
                map2.put(t, gitBranch);
            }
            Map currentBranches = result$iv;
            if (this.allBranchesHaveTheSameName(currentBranches)) {
                String string = ((GitBranch)ContainerUtil.getFirstItem(currentBranches.values())).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String branchName = string;
                Object[] objectArray = new Object[]{branchName};
                description2.appendRaw(GitBundle.message("push.rejected.many.repos.single.branch", objectArray)).br();
                for (GitRepository repository : DvcsUtil.sortRepositories((Collection)currentBranches.keySet())) {
                    description2.nbsp(4).append(DvcsUtil.getShortRepositoryName((Repository)repository)).br();
                }
            } else {
                description2.append(GitBundle.message("push.rejected.many.repos", new Object[0])).br();
                for (Map.Entry entry : currentBranches.entrySet()) {
                    GitRepository repository;
                    repository = (GitRepository)entry.getKey();
                    GitBranch branch = (GitBranch)entry.getValue();
                    Object[] objectArray = new Object[]{branch.getName(), DvcsUtil.getShortRepositoryName((Repository)repository)};
                    description2.nbsp(4).appendRaw(GitBundle.message("push.rejected.many.repos.item", objectArray)).br();
                }
            }
        }
        String string = description2.appendRaw(this.descriptionEnding()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String descriptionEnding() {
        String string;
        if (this.rebaseOverMergeProblemDetected) {
            String string2 = GitBundle.message("push.rejected.merge.needed.with.problem", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = GitBundle.message("push.rejected.merge.needed", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final GitBranch getCurrentBranch(GitRepository repository) {
        GitLocalBranch gitLocalBranch = repository.getCurrentBranch();
        if (gitLocalBranch == null) {
            throw new IllegalStateException(("Current branch can't be null here. " + repository).toString());
        }
        return gitLocalBranch;
    }

    private final boolean allBranchesHaveTheSameName(Map<GitRepository, ? extends GitBranch> branches2) {
        String name = null;
        for (GitBranch gitBranch : branches2.values()) {
            if (name == null) {
                name = gitBranch.getName();
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)gitBranch.getName())) continue;
            return false;
        }
        return true;
    }

    private final createDoNotAsk.1 createDoNotAsk() {
        return new DoNotAskOption.Adapter(this){
            final /* synthetic */ GitRejectedPushUpdateDialog this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getDoNotShowMessage() {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)CommonBundle.settingsTitle(), (String)"settingsTitle(...)");
                return GitBundleExtensions.html("push.rejected.remember.checkbox", objectArray);
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                GitRejectedPushUpdateDialog.access$setShouldAutoUpdateInFuture$p(this.this$0, isSelected);
            }
        };
    }

    private final MessageDialogBuilder.Message setDefaultAndFocusedActions(MessageDialogBuilder.Message $this$setDefaultAndFocusedActions, UpdateMethod updateMethod) {
        String defaultAction = null;
        String focusedAction = null;
        if (this.rebaseOverMergeProblemDetected) {
            defaultAction = this.mergeButtonText;
            focusedAction = this.cancelButtonText;
        } else if (updateMethod == UpdateMethod.REBASE) {
            defaultAction = this.rebaseButtonText;
            focusedAction = this.mergeButtonText;
        } else {
            defaultAction = this.mergeButtonText;
            focusedAction = this.rebaseButtonText;
        }
        $this$setDefaultAndFocusedActions.defaultButton(defaultAction);
        $this$setDefaultAndFocusedActions.focusedButton(focusedAction);
        return $this$setDefaultAndFocusedActions;
    }

    public static final /* synthetic */ void access$setShouldAutoUpdateInFuture$p(GitRejectedPushUpdateDialog $this, boolean bl) {
        $this.shouldAutoUpdateInFuture = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lgit4idea/push/GitRejectedPushUpdateDialog$Companion;", "", "()V", "PushRejectedExitCode", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lgit4idea/push/GitRejectedPushUpdateDialog$Companion$PushRejectedExitCode;", "", "exitCode", "", "(Ljava/lang/String;II)V", "getExitCode", "()I", "MERGE", "REBASE", "CANCEL", "intellij.vcs.git"})
        public static final class PushRejectedExitCode
        extends Enum<PushRejectedExitCode> {
            private final int exitCode;
            public static final /* enum */ PushRejectedExitCode MERGE = new PushRejectedExitCode(0);
            public static final /* enum */ PushRejectedExitCode REBASE = new PushRejectedExitCode(1);
            public static final /* enum */ PushRejectedExitCode CANCEL = new PushRejectedExitCode(2);
            private static final /* synthetic */ PushRejectedExitCode[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private PushRejectedExitCode(int exitCode) {
                this.exitCode = exitCode;
            }

            public final int getExitCode() {
                return this.exitCode;
            }

            public static PushRejectedExitCode[] values() {
                return (PushRejectedExitCode[])$VALUES.clone();
            }

            public static PushRejectedExitCode valueOf(String value) {
                return Enum.valueOf(PushRejectedExitCode.class, value);
            }

            @NotNull
            public static EnumEntries<PushRejectedExitCode> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = pushRejectedExitCodeArray = new PushRejectedExitCode[]{PushRejectedExitCode.MERGE, PushRejectedExitCode.REBASE, PushRejectedExitCode.CANCEL};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

